/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import java.util.List;
import junit.framework.Assert;
import org.drools.workbench.models.datamodel.oracle.DSLActionSentence;
import org.drools.workbench.models.datamodel.oracle.DSLConditionSentence;
import org.junit.Test;
import org.kie.soup.project.datamodel.oracle.ExtensionKind;
import org.kie.workbench.common.services.datamodel.backend.server.cache.DSLExtension;
import org.kie.workbench.common.services.datamodel.spi.DataModelExtension;

public class DSLExtensionTest {
    private DSLExtension extension = new DSLExtension();

    @Test
    public void testAddConditionDSLSentence() {
        List mappings = this.extension.getExtensions(null, "[when]There is a Smurf=Smurf()");
        Assert.assertEquals((int)1, (int)DSLExtensionTest.totalValues(mappings));
        Assert.assertEquals((int)1, (int)DSLExtensionTest.valuesOfKind(mappings, (ExtensionKind)DSLConditionSentence.INSTANCE));
    }

    @Test
    public void testAddActionDSLSentence() {
        List mappings = this.extension.getExtensions(null, "[then]Greet Smurf=System.out.println(\"Hello Smurf\");");
        Assert.assertEquals((int)1, (int)DSLExtensionTest.totalValues(mappings));
        Assert.assertEquals((int)1, (int)DSLExtensionTest.valuesOfKind(mappings, (ExtensionKind)DSLActionSentence.INSTANCE));
    }

    @Test
    public void testAddMultipleConditionDSLSentence() {
        List mappings = this.extension.getExtensions(null, "[when]There is a Smurf=Smurf()\n[when]There is Happy Smurf=Smurf( nature = HAPPY )");
        Assert.assertEquals((int)2, (int)DSLExtensionTest.totalValues(mappings));
        Assert.assertEquals((int)2, (int)DSLExtensionTest.valuesOfKind(mappings, (ExtensionKind)DSLConditionSentence.INSTANCE));
    }

    @Test
    public void testAddMultipleActionDSLSentence() {
        List mappings = this.extension.getExtensions(null, "[then]Report Smurfs=System.out.println(\"There is a Smurf\");\n[then]Greet Happy Smurf=System.out.println(\"Hello Happy Smurf\");");
        Assert.assertEquals((int)2, (int)DSLExtensionTest.totalValues(mappings));
        Assert.assertEquals((int)2, (int)DSLExtensionTest.valuesOfKind(mappings, (ExtensionKind)DSLActionSentence.INSTANCE));
    }

    private static int totalValues(List<DataModelExtension.ExtensionMapping<?>> mappings) {
        return (int)mappings.stream().flatMap(em -> em.getValues().stream()).count();
    }

    private static int valuesOfKind(List<DataModelExtension.ExtensionMapping<?>> mappings, ExtensionKind kind) {
        return (int)mappings.stream().filter(em -> kind.equals((Object)em.getKind())).flatMap(em -> em.getValues().stream()).count();
    }
}

