/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorPresenter;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorView;
import org.drools.workbench.screens.drltext.client.resources.i18n.DRLTextEditorConstants;
import org.drools.workbench.screens.drltext.client.widget.ClickEvent;
import org.drools.workbench.screens.drltext.client.widget.DSLSentenceBrowserWidget;
import org.drools.workbench.screens.drltext.client.widget.DrlEditor;
import org.drools.workbench.screens.drltext.client.widget.FactTypeBrowserWidget;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;

public class DRLEditorViewImpl
extends KieEditorViewImpl
implements DRLEditorView {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static int SCROLL_BAR_SIZE = 32;
    private static int CONTAINER_PADDING = 15;
    private static int VERTICAL_MARGIN = SCROLL_BAR_SIZE + CONTAINER_PADDING * 2;
    private DrlEditor drlEditor = null;
    private FactTypeBrowserWidget factTypeBrowser = null;
    private DSLSentenceBrowserWidget dslConditionsBrowser = null;
    private DSLSentenceBrowserWidget dslActionsBrowser = null;
    @UiField
    FlowPanel columnsContainer;
    @UiField
    FlowPanel columnBrowsers;
    @UiField
    FlowPanel columnDrl;

    public void init(DRLEditorPresenter presenter) {
        this.factTypeBrowser.init(presenter);
    }

    @PostConstruct
    public void init() {
        this.drlEditor = new DrlEditor();
        ClickEvent ce = new ClickEvent(){

            @Override
            public void selected(String text) {
                DRLEditorViewImpl.this.drlEditor.insertAtCursor(text);
            }
        };
        this.factTypeBrowser = new FactTypeBrowserWidget(ce);
        this.dslConditionsBrowser = new DSLSentenceBrowserWidget(ce, DRLTextEditorConstants.INSTANCE.showDSLConditions(), DRLTextEditorConstants.INSTANCE.dslConditions());
        this.dslActionsBrowser = new DSLSentenceBrowserWidget(ce, DRLTextEditorConstants.INSTANCE.showDSLActions(), DRLTextEditorConstants.INSTANCE.dslActions());
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.columnBrowsers.add((Widget)this.factTypeBrowser);
        this.columnBrowsers.add((Widget)this.dslConditionsBrowser);
        this.columnBrowsers.add((Widget)this.dslActionsBrowser);
        this.columnDrl.add((Widget)this.drlEditor);
    }

    @Override
    public void setContent(String drl, List<String> fullyQualifiedClassNames) {
        this.dslConditionsBrowser.setVisible(false);
        this.dslActionsBrowser.setVisible(false);
        this.factTypeBrowser.setFullyQualifiedClassNames(fullyQualifiedClassNames);
        this.factTypeBrowser.setDSLR(false);
        this.drlEditor.setText(drl);
    }

    @Override
    public void setContent(String dslr, List<String> fullyQualifiedClassNames, List<DSLSentence> dslConditions, List<DSLSentence> dslActions) {
        this.dslConditionsBrowser.setVisible(true);
        this.dslActionsBrowser.setVisible(true);
        this.factTypeBrowser.setFullyQualifiedClassNames(fullyQualifiedClassNames);
        this.factTypeBrowser.setDSLR(true);
        this.dslConditionsBrowser.setDSLSentences(dslConditions);
        this.dslActionsBrowser.setDSLSentences(dslActions);
        this.drlEditor.setText(dslr);
    }

    @Override
    public String getContent() {
        return this.drlEditor.getText();
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight() - VERTICAL_MARGIN;
        this.columnsContainer.setHeight((height > 0 ? height : 0) + "px");
        this.drlEditor.onResize();
    }

    static interface ViewBinder
    extends UiBinder<Widget, DRLEditorViewImpl> {
    }
}

