/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.widget;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorPresenter;
import org.drools.workbench.screens.drltext.client.resources.DRLTextEditorResources;
import org.drools.workbench.screens.drltext.client.resources.i18n.DRLTextEditorConstants;
import org.drools.workbench.screens.drltext.client.widget.ClickEvent;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.Util;

public class FactTypeBrowserWidget
extends Composite
implements UberView<DRLEditorPresenter> {
    private static final String LAZY_LOAD = CommonConstants.INSTANCE.Loading();
    private DRLEditorPresenter presenter;
    private final Tree tree = new Tree();
    private boolean isDSLR;

    public FactTypeBrowserWidget(final ClickEvent ev) {
        VerticalPanel panel = new VerticalPanel();
        final HorizontalPanel hpFactsAndHide = new HorizontalPanel();
        final HorizontalPanel hpShow = new HorizontalPanel();
        hpShow.add((Widget)new ClickableLabel(DRLTextEditorConstants.INSTANCE.ShowFactTypes(), new ClickHandler(){

            public void onClick(com.google.gwt.event.dom.client.ClickEvent event) {
                hpShow.setVisible(false);
                hpFactsAndHide.setVisible(true);
                FactTypeBrowserWidget.this.tree.setVisible(true);
            }
        }));
        panel.add((Widget)hpShow);
        hpFactsAndHide.add((Widget)new SmallLabel(DRLTextEditorConstants.INSTANCE.FactTypes()));
        hpFactsAndHide.add((Widget)new ClickableLabel(DRLTextEditorConstants.INSTANCE.hide(), new ClickHandler(){

            public void onClick(com.google.gwt.event.dom.client.ClickEvent event) {
                hpShow.setVisible(true);
                hpFactsAndHide.setVisible(false);
                FactTypeBrowserWidget.this.tree.setVisible(false);
            }
        }));
        panel.add((Widget)hpFactsAndHide);
        panel.add((Widget)this.tree);
        this.tree.setStyleName(DRLTextEditorResources.INSTANCE.CSS().categoryExplorerTree());
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                Object o = ((TreeItem)event.getSelectedItem()).getUserObject();
                if (o instanceof ClassUserObject) {
                    String text = ((ClassUserObject)o).textToInsert;
                    ev.selected(FactTypeBrowserWidget.this.isDSLR ? ">" + text : text);
                } else if (o instanceof String) {
                    ev.selected((String)o);
                }
            }
        });
        this.tree.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                final TreeItem item = (TreeItem)event.getTarget();
                if (FactTypeBrowserWidget.this.needsLoading(item)) {
                    Object userObject = ((TreeItem)event.getTarget()).getUserObject();
                    FactTypeBrowserWidget.this.presenter.loadClassFields(((ClassUserObject)userObject).fullyQualifiedClassName, new Callback<List<String>>(){

                        public void callback(List<String> fields) {
                            item.getChild(0).remove();
                            if (fields != null) {
                                for (String field : fields) {
                                    TreeItem fi = new TreeItem();
                                    fi.setHTML(AbstractImagePrototype.create((ImageResource)DRLTextEditorResources.INSTANCE.images().fieldImage()).getHTML() + "<small style=\"cursor: pointer\">" + field + "</small>");
                                    fi.setUserObject((Object)field);
                                    item.addItem(fi);
                                }
                            }
                        }
                    });
                }
            }
        });
        this.tree.setVisible(true);
        hpFactsAndHide.setVisible(true);
        hpShow.setVisible(false);
        this.initWidget((Widget)panel);
    }

    public void init(DRLEditorPresenter presenter) {
        this.presenter = presenter;
    }

    public void setDSLR(boolean isDSLR) {
        this.isDSLR = isDSLR;
    }

    public void setFullyQualifiedClassNames(List<String> fullyQualifiedClassNames) {
        if (this.tree.getItem(0) != null) {
            this.tree.clear();
        }
        if (fullyQualifiedClassNames != null) {
            for (String type : fullyQualifiedClassNames) {
                TreeItem it = new TreeItem();
                it.setHTML(AbstractImagePrototype.create((ImageResource)DRLTextEditorResources.INSTANCE.images().classImage()).getHTML() + "<small style=\"cursor: pointer\">" + type + "</small>");
                it.setUserObject((Object)new ClassUserObject(type + "( )", type));
                this.tree.addItem(it);
                it.addItem(Util.toSafeHtml((String)LAZY_LOAD));
            }
        }
    }

    private boolean needsLoading(TreeItem item) {
        return item.getChildCount() == 1 && LAZY_LOAD.equals(item.getChild(0).getText());
    }

    private static class ClassUserObject {
        private String textToInsert;
        private String fullyQualifiedClassName;

        ClassUserObject(String textToInsert, String fullyQualifiedClassName) {
            this.textToInsert = textToInsert;
            this.fullyQualifiedClassName = fullyQualifiedClassName;
        }
    }
}

