/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.handlers;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.drltext.client.resources.DRLTextEditorResources;
import org.drools.workbench.screens.drltext.client.resources.i18n.DRLTextEditorConstants;
import org.drools.workbench.screens.drltext.client.type.DRLResourceType;
import org.drools.workbench.screens.drltext.client.type.DSLRResourceType;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewDrlTextHandler
extends DefaultNewResourceHandler {
    @Inject
    private Caller<DRLTextEditorService> drlTextService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private DRLResourceType resourceTypeDRL;
    @Inject
    private DSLRResourceType resourceTypeDSLR;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    private CheckBox useDSLCheckbox = new CheckBox(DRLTextEditorConstants.INSTANCE.useDSL());

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(new Pair((Object)DRLTextEditorConstants.INSTANCE.useDSL(), (Object)this.useDSLCheckbox));
    }

    public String getDescription() {
        return DRLTextEditorConstants.INSTANCE.NewDrlDescription();
    }

    public IsWidget getIcon() {
        return new Image(DRLTextEditorResources.INSTANCE.images().typeDRL());
    }

    public ResourceTypeDefinition getResourceType() {
        boolean useDSL = this.useDSLCheckbox.getValue();
        ClientResourceType resourceType = useDSL ? this.resourceTypeDSLR : this.resourceTypeDRL;
        return resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        boolean useDSL = this.useDSLCheckbox.getValue();
        ClientResourceType resourceType = useDSL ? this.resourceTypeDSLR : this.resourceTypeDRL;
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((DRLTextEditorService)this.drlTextService.call(this.getSuccessCallback(presenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(pkg.getPackageMainResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)resourceType), (Object)"", "");
    }
}

