/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorView;
import org.drools.workbench.screens.drltext.client.type.DRLResourceType;
import org.drools.workbench.screens.drltext.client.type.DSLRResourceType;
import org.drools.workbench.screens.drltext.model.DrlModelContent;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="DRLEditor", supportedTypes={DRLResourceType.class, DSLRResourceType.class})
public class DRLEditorPresenter
extends KieEditor {
    @Inject
    private Caller<DRLTextEditorService> drlTextEditorService;
    @Inject
    private Event<NotificationEvent> notification;
    private DRLEditorView view;
    @Inject
    private DRLResourceType resourceTypeDRL;
    @Inject
    private DSLRResourceType resourceTypeDSLR;
    private boolean isDSLR;

    @Inject
    public DRLEditorPresenter(DRLEditorView view) {
        super((KieEditorView)view);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, this.getResourceType((Path)path));
        this.isDSLR = this.resourceTypeDSLR.accept((Path)path);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((DRLTextEditorService)this.drlTextEditorService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<DrlModelContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<DrlModelContent>(){

            public void callback(DrlModelContent content) {
                if (DRLEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                DRLEditorPresenter.this.resetEditorPages(content.getOverview());
                String drl = this.assertContent(content.getDrl());
                List fullyQualifiedClassNames = content.getFullyQualifiedClassNames();
                List dslConditions = content.getDslConditions();
                List dslActions = content.getDslActions();
                if (DRLEditorPresenter.this.isDSLR) {
                    DRLEditorPresenter.this.view.setContent(drl, fullyQualifiedClassNames, dslConditions, dslActions);
                } else {
                    DRLEditorPresenter.this.view.setContent(drl, fullyQualifiedClassNames);
                }
                DRLEditorPresenter.this.view.setReadOnly(DRLEditorPresenter.this.isReadOnly);
                DRLEditorPresenter.this.view.hideBusyIndicator();
                DRLEditorPresenter.this.createOriginalHash(DRLEditorPresenter.this.view.getContent());
            }

            private String assertContent(String drl) {
                if (drl == null || drl.isEmpty()) {
                    return "";
                }
                return drl;
            }
        };
    }

    public void loadClassFields(String fullyQualifiedClassName, Callback<List<String>> callback) {
        ((DRLTextEditorService)this.drlTextEditorService.call(this.getLoadClassFieldsSuccessCallback(callback), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).loadClassFields((Path)this.versionRecordManager.getCurrentPath(), fullyQualifiedClassName);
    }

    private RemoteCallback<List<String>> getLoadClassFieldsSuccessCallback(final Callback<List<String>> callback) {
        return new RemoteCallback<List<String>>(){

            public void callback(List<String> fields) {
                callback.callback(fields);
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((DRLTextEditorService)DRLEditorPresenter.this.drlTextEditorService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            DRLEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            ValidationPopup.showMessages(results);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback())).validate((Path)DRLEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)DRLEditorPresenter.this.view.getContent());
            }
        };
    }

    protected void save(String commitMessage) {
        ((DRLTextEditorService)this.drlTextEditorService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), this.metadata, commitMessage);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    private ClientResourceType getResourceType(Path path) {
        if (this.resourceTypeDRL.accept(path)) {
            return this.resourceTypeDRL;
        }
        return this.resourceTypeDSLR;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

