/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorView;
import org.drools.workbench.screens.drltext.client.type.DRLResourceType;
import org.drools.workbench.screens.drltext.client.type.DSLRResourceType;
import org.drools.workbench.screens.drltext.model.DrlModelContent;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.CommandErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="DRLEditor", supportedTypes={DRLResourceType.class, DSLRResourceType.class})
public class DRLEditorPresenter
extends KieEditor<String> {
    @Inject
    protected Caller<DRLTextEditorService> drlTextEditorService;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    protected ValidationPopup validationPopup;
    private DRLEditorView view;
    @Inject
    private DRLResourceType resourceTypeDRL;
    @Inject
    private DSLRResourceType resourceTypeDSLR;
    private boolean isDSLR;

    @Inject
    public DRLEditorPresenter(DRLEditorView view) {
        super((KieEditorView)view);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, this.getResourceType((Path)path));
        this.isDSLR = this.resourceTypeDSLR.accept((Path)path);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((DRLTextEditorService)this.drlTextEditorService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected Supplier<String> getContentSupplier() {
        return () -> this.view.getContent();
    }

    protected Caller<? extends SupportsSaveAndRename<String, Metadata>> getSaveAndRenameServiceCaller() {
        return this.drlTextEditorService;
    }

    private RemoteCallback<DrlModelContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<DrlModelContent>(){

            public void callback(DrlModelContent content) {
                if (DRLEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                DRLEditorPresenter.this.resetEditorPages(content.getOverview());
                String drl = this.assertContent(content.getDrl());
                List fullyQualifiedClassNames = content.getFullyQualifiedClassNames();
                List dslConditions = content.getDslConditions();
                List dslActions = content.getDslActions();
                if (DRLEditorPresenter.this.isDSLR) {
                    DRLEditorPresenter.this.view.setContent(drl, fullyQualifiedClassNames, dslConditions, dslActions);
                } else {
                    DRLEditorPresenter.this.view.setContent(drl, fullyQualifiedClassNames);
                }
                DRLEditorPresenter.this.view.setReadOnly(DRLEditorPresenter.this.isReadOnly);
                DRLEditorPresenter.this.view.hideBusyIndicator();
                DRLEditorPresenter.this.createOriginalHash(DRLEditorPresenter.this.view.getContent());
            }

            private String assertContent(String drl) {
                if (drl == null || drl.isEmpty()) {
                    return "";
                }
                return drl;
            }
        };
    }

    public void loadClassFields(String fullyQualifiedClassName, Callback<List<String>> callback) {
        ((DRLTextEditorService)this.drlTextEditorService.call(this.getLoadClassFieldsSuccessCallback(callback), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).loadClassFields((Path)this.versionRecordManager.getCurrentPath(), fullyQualifiedClassName);
    }

    private RemoteCallback<List<String>> getLoadClassFieldsSuccessCallback(final Callback<List<String>> callback) {
        return new RemoteCallback<List<String>>(){

            public void callback(List<String> fields) {
                callback.callback(fields);
            }
        };
    }

    protected void onValidate(Command finished) {
        ((DRLTextEditorService)this.drlTextEditorService.call((RemoteCallback)this.validationPopup.getValidationCallback(finished), (ErrorCallback)new CommandErrorCallback(finished))).validate((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent());
    }

    protected void save(String commitMessage) {
        ((DRLTextEditorService)this.drlTextEditorService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), (Object)this.metadata, commitMessage);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    private ClientResourceType getResourceType(Path path) {
        if (this.resourceTypeDRL.accept(path)) {
            return this.resourceTypeDRL;
        }
        return this.resourceTypeDSLR;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

