/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.widget;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorPresenter;
import org.drools.workbench.screens.drltext.client.resources.DRLTextEditorResources;
import org.drools.workbench.screens.drltext.client.resources.i18n.DRLTextEditorConstants;
import org.drools.workbench.screens.drltext.client.widget.ClickEvent;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class DSLSentenceBrowserWidget
extends Composite
implements UberView<DRLEditorPresenter> {
    private DRLEditorPresenter presenter;
    private final Tree tree = new Tree();

    public DSLSentenceBrowserWidget(final ClickEvent ev, String showDSLCaption, String dslCaption) {
        VerticalPanel container = new VerticalPanel();
        final HorizontalPanel hpDSLSentencesAndHide = new HorizontalPanel();
        final HorizontalPanel hpShow = new HorizontalPanel();
        hpShow.add((Widget)new ClickableLabel(showDSLCaption, new ClickHandler(){

            public void onClick(com.google.gwt.event.dom.client.ClickEvent event) {
                hpShow.setVisible(false);
                hpDSLSentencesAndHide.setVisible(true);
                DSLSentenceBrowserWidget.this.tree.setVisible(true);
            }
        }));
        container.add((Widget)hpShow);
        hpDSLSentencesAndHide.add((Widget)new SmallLabel(dslCaption));
        hpDSLSentencesAndHide.add((Widget)new ClickableLabel(DRLTextEditorConstants.INSTANCE.hide(), new ClickHandler(){

            public void onClick(com.google.gwt.event.dom.client.ClickEvent event) {
                hpShow.setVisible(true);
                hpDSLSentencesAndHide.setVisible(false);
                DSLSentenceBrowserWidget.this.tree.setVisible(false);
            }
        }));
        container.add((Widget)hpDSLSentencesAndHide);
        container.add((Widget)this.tree);
        this.tree.setStyleName(DRLTextEditorResources.INSTANCE.CSS().categoryExplorerTree());
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                Object o = ((TreeItem)event.getSelectedItem()).getUserObject();
                ev.selected(o.toString());
            }
        });
        this.tree.setVisible(true);
        hpDSLSentencesAndHide.setVisible(true);
        hpShow.setVisible(false);
        this.initWidget((Widget)container);
    }

    public void init(DRLEditorPresenter presenter) {
        this.presenter = presenter;
    }

    public void setDSLSentences(List<DSLSentence> dslSentences) {
        if (this.tree.getItem(0) != null) {
            this.tree.clear();
        }
        if (dslSentences != null) {
            for (DSLSentence dslSentence : dslSentences) {
                TreeItem it = new TreeItem();
                it.setHTML("<small>" + dslSentence.toString() + "</small>");
                it.setUserObject((Object)dslSentence);
                this.tree.addItem(it);
            }
        }
    }
}

