/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorPresenter;
import org.drools.workbench.screens.drltext.client.editor.DRLEditorView;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.gwtbootstrap3.client.ui.Modal;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.test.MockProvider;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.java.nio.IOException;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Modal.class})
public class DRLEditorPresenterValidationTest {
    @Mock
    private DRLEditorView view;
    @Mock
    protected DRLTextEditorService drlTextEditorService;
    private DRLEditorPresenter presenter;

    @Before
    public void setUp() throws Exception {
        this.presenter = new DRLEditorPresenter(this.view){
            {
                this.drlTextEditorService = new CallerMock((Object)DRLEditorPresenterValidationTest.this.drlTextEditorService);
                this.validationPopup = MockProvider.getMockValidationPopup();
                this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
            }
        };
    }

    @Test
    public void commandIsCalled() throws Exception {
        ((DRLTextEditorService)Mockito.doReturn(new ArrayList()).when((Object)this.drlTextEditorService)).validate((Path)Matchers.any(Path.class), (Object)Matchers.anyString());
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }

    @Test
    public void callFailsAndCommandIsCalled() throws Exception {
        ((DRLTextEditorService)Mockito.doThrow((Throwable)new IOException()).when((Object)this.drlTextEditorService)).validate((Path)Matchers.any(Path.class), (Object)Matchers.anyString());
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }
}

