/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.backend.server.indexing;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.dsltext.backend.server.indexing.TestDslFileIndexer;
import org.drools.workbench.screens.dsltext.type.DSLResourceTypeDefinition;
import org.guvnor.common.services.project.categories.Decision;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexDefaultPackageDslEntriesTest
extends BaseIndexingTest<DSLResourceTypeDefinition> {
    @Test
    public void testDefaultPackageIndexDslEntries() throws IOException, InterruptedException {
        Path path1 = this.basePath.resolve("dsl1.dsl");
        String dsl1 = this.loadText("dsl1.dsl");
        this.ioService().write(path1, dsl1, new OpenOption[0]);
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueResourceIndexTerm("*", ResourceType.RULE, ValueIndexTerm.TermSearchType.WILDCARD)).build();
        this.searchFor(index, query, 0, new Path[0]);
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("org.drools.workbench.screens.dsltext.backend.server.indexing.classes.Applicant", ResourceType.JAVA)).build();
        this.searchFor(index, query, 1, new Path[]{path1});
    }

    protected TestIndexer getIndexer() {
        return new TestDslFileIndexer("");
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("projectRoot", new FilenameAnalyzer());
            }
        };
    }

    protected DSLResourceTypeDefinition getResourceTypeDefinition() {
        return new DSLResourceTypeDefinition(new Decision());
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

