/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.client.editor;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.screens.dsltext.client.editor.DSLEditorView;
import org.drools.workbench.screens.dsltext.client.resources.DSLTextEditorResources;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;
import org.uberfire.ext.widgets.common.client.common.ResizableTextArea;

public class DSLEditorViewImpl
extends KieEditorViewImpl
implements RequiresResize,
DSLEditorView {
    private final ResizableTextArea dslText = new ResizableTextArea();

    public DSLEditorViewImpl() {
        this.dslText.setWidth("100%");
        this.dslText.getElement().setAttribute("spellcheck", "false");
        this.dslText.setStyleName(DSLTextEditorResources.INSTANCE.CSS().defaultTextArea());
        this.dslText.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 9) {
                    int pos = DSLEditorViewImpl.this.dslText.getCursorPos();
                    DSLEditorViewImpl.this.insertText("\t");
                    DSLEditorViewImpl.this.dslText.setCursorPos(pos + 1);
                    DSLEditorViewImpl.this.dslText.cancelKey();
                    DSLEditorViewImpl.this.dslText.setFocus(true);
                }
            }
        });
        this.initWidget((Widget)this.dslText);
    }

    private void insertText(String ins) {
        int i = this.dslText.getCursorPos();
        String left = this.dslText.getText().substring(0, i);
        String right = this.dslText.getText().substring(i, this.dslText.getText().length());
        this.dslText.setText(left + ins + right);
    }

    @Override
    public void setContent(String input) {
        String content = input == null ? "" : input;
        this.dslText.setText(content);
    }

    @Override
    public String getContent() {
        return this.dslText.getValue();
    }

    @Override
    public void makeReadOnly() {
        this.dslText.setEnabled(false);
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.setPixelSize(width, height);
        this.dslText.onResize();
    }
}

