/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.drools.workbench.screens.dsltext.client.editor.DSLEditorPresenter;
import org.drools.workbench.screens.dsltext.client.editor.DSLEditorView;
import org.drools.workbench.screens.dsltext.service.DSLTextEditorService;
import org.gwtbootstrap3.client.ui.Modal;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.test.MockProvider;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.java.nio.IOException;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Modal.class})
public class DSLEditorPresenterValidationTest {
    @Mock
    private DSLEditorView view;
    @Mock
    private DSLTextEditorService dslTextEditorService;
    private DSLEditorPresenter presenter;

    @Before
    public void setUp() throws Exception {
        this.presenter = new DSLEditorPresenter(this.view){
            {
                this.dslTextEditorService = new CallerMock((Object)DSLEditorPresenterValidationTest.this.dslTextEditorService);
                this.validationPopup = MockProvider.getMockValidationPopup();
                this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
            }
        };
    }

    @Test
    public void commandIsCalled() throws Exception {
        ((DSLTextEditorService)Mockito.doReturn(new ArrayList()).when((Object)this.dslTextEditorService)).validate((Path)Matchers.any(Path.class), (Object)Matchers.anyString());
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }

    @Test
    public void callFailsAndCommandIsCalled() throws Exception {
        ((DSLTextEditorService)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.dslTextEditorService)).validate((Path)Matchers.any(Path.class), (Object)Matchers.anyString());
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }
}

