/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.screens.dtablexls.backend.server.ExtendedDecisionTableXLSService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.StandardOpenOption;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.services.backend.exceptions.ExceptionUtilities;
import org.kie.workbench.common.services.shared.file.CopyService;
import org.kie.workbench.common.services.shared.file.DeleteService;
import org.kie.workbench.common.services.shared.file.RenameService;
import org.kie.workbench.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.services.shared.validation.model.BuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class DecisionTableXLSServiceImpl
implements DecisionTableXLSService,
ExtendedDecisionTableXLSService {
    private static final Logger log = LoggerFactory.getLogger(DecisionTableXLSServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private DecisionTableXLSConversionService conversionService;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;

    @Override
    public InputStream load(org.uberfire.backend.vfs.Path path) {
        try {
            InputStream inputStream = this.ioService.newInputStream(this.paths.convert(path), new OpenOption[]{StandardOpenOption.READ});
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path));
            return inputStream;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    @Override
    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path resource, InputStream content, String comment) {
        log.info("USER:" + this.identity.getName() + " CREATING asset [" + resource.getFileName() + "]");
        try {
            Path nioPath = this.paths.convert(resource);
            this.ioService.createFile(nioPath, new FileAttribute[0]);
            OutputStream outputStream = this.ioService.newOutputStream(nioPath, new OpenOption[]{this.makeCommentedOption(comment)});
            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath);
            this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newPath));
            org.uberfire.backend.vfs.Path path = newPath;
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                throw new org.kie.commons.java.nio.IOException(e.getMessage());
            }
        }
    }

    @Override
    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, InputStream content, String comment) {
        log.info("USER:" + this.identity.getName() + " UPDATING asset [" + resource.getFileName() + "]");
        try {
            Path nioPath = this.paths.convert(resource);
            OutputStream outputStream = this.ioService.newOutputStream(nioPath, new OpenOption[]{this.makeCommentedOption(comment)});
            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath);
            this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(newPath));
            org.uberfire.backend.vfs.Path path = newPath;
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                throw new org.kie.commons.java.nio.IOException(e.getMessage());
            }
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ConversionResult convert(org.uberfire.backend.vfs.Path path) {
        try {
            return this.conversionService.convert(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public BuilderResult validate(org.uberfire.backend.vfs.Path path, String content) {
        return new BuilderResult();
    }

    public boolean isValid(org.uberfire.backend.vfs.Path path, String content) {
        return !this.validate(path, content).hasLines();
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

