/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.util.DateUtils;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.template.model.Import;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.drools.workbench.screens.drltext.type.DRLResourceTypeDefinition;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.GuidedDecisionTableGeneratorListener;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.drools.workbench.screens.factmodel.type.FactModelResourceTypeDefinition;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.drools.workbench.screens.globals.type.GlobalResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.project.service.model.ProjectImports;
import org.kie.workbench.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.services.shared.metadata.model.Metadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class DecisionTableXLSToDecisionTableGuidedConverter
implements DecisionTableXLSConversionService {
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private DRLTextEditorService drlService;
    @Inject
    private GuidedDecisionTableEditorService guidedDecisionTableService;
    @Inject
    private GlobalsEditorService globalsService;
    @Inject
    private ProjectService projectService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private DecisionTableXLSResourceTypeDefinition xlsDTableType;
    @Inject
    private GuidedDTableResourceTypeDefinition guidedDTableType;
    @Inject
    private DRLResourceTypeDefinition drlType;
    @Inject
    private FactModelResourceTypeDefinition modelType;
    @Inject
    private GlobalResourceTypeDefinition globalsType;

    public ConversionResult convert(org.uberfire.backend.vfs.Path path) {
        ConversionResult result = new ConversionResult();
        if (!this.xlsDTableType.accept(path)) {
            result.addMessage("Source Asset is not an XLS Decision Table.", ConversionMessageType.ERROR);
            return result;
        }
        GuidedDecisionTableGeneratorListener listener = this.parseAssets(path, result);
        org.uberfire.backend.vfs.Path context = this.paths.convert(this.paths.convert(path).getParent());
        this.createNewImports(context, listener.getImports(), result);
        this.createNewFunctions(context, listener.getImports(), listener.getFunctions(), result);
        this.createNewQueries(context, listener.getImports(), listener.getQueries(), result);
        this.createNewDeclarativeTypes(context, listener.getImports(), listener.getTypeDeclarations(), result);
        this.createNewGlobals(context, listener.getGlobals(), result);
        this.createNewDecisionTables(context, listener.getImports(), listener.getGuidedDecisionTables(), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidedDecisionTableGeneratorListener parseAssets(org.uberfire.backend.vfs.Path path, ConversionResult result) {
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream stream = this.ioService.newInputStream(this.paths.convert(path), new OpenOption[0]);
        try {
            parser.parseFile(stream);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                result.addMessage(ioe.getMessage(), ConversionMessageType.ERROR);
            }
        }
        return listener;
    }

    private void createNewFunctions(org.uberfire.backend.vfs.Path context, List<Import> imports, List<String> functions, ConversionResult result) {
        if (functions == null || functions.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < functions.size(); ++iCounter) {
            String assetName = this.makeNewAssetName("Function " + (iCounter + 1), (ResourceTypeDefinition)this.drlType);
            String drl = this.makeDRL(imports, functions.get(iCounter));
            this.drlService.create(context, assetName, (Object)drl, "Converted from XLS Decision Table");
            result.addMessage("Created Function '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private void createNewQueries(org.uberfire.backend.vfs.Path context, List<Import> imports, List<String> queries, ConversionResult result) {
        if (queries == null || queries.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < queries.size(); ++iCounter) {
            String assetName = this.makeNewAssetName("Query " + (iCounter + 1), (ResourceTypeDefinition)this.drlType);
            String drl = this.makeDRL(imports, queries.get(iCounter));
            this.drlService.create(context, assetName, (Object)drl, "Converted from XLS Decision Table");
            result.addMessage("Created Query '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private void createNewDeclarativeTypes(org.uberfire.backend.vfs.Path context, List<Import> imports, List<String> declaredTypes, ConversionResult result) {
        if (declaredTypes == null || declaredTypes.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < declaredTypes.size(); ++iCounter) {
            String assetName = this.makeNewAssetName("Model " + (iCounter + 1), (ResourceTypeDefinition)this.modelType);
            String drl = this.makeDRL(imports, declaredTypes.get(iCounter));
            this.drlService.create(context, assetName, (Object)drl, "Converted from XLS Decision Table");
            result.addMessage("Created Declarative Model '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private String makeDRL(List<Import> imports, String baseDRL) {
        StringBuilder sb = new StringBuilder();
        if (imports != null && !imports.isEmpty()) {
            for (Import item : imports) {
                sb.append("import ").append(item.getClassName()).append(";\n");
            }
            sb.append("\n");
        }
        sb.append(baseDRL).append("\n");
        return sb.toString();
    }

    private void createNewGlobals(org.uberfire.backend.vfs.Path context, List<org.drools.template.model.Global> globals, ConversionResult result) {
        if (globals == null || globals.isEmpty()) {
            return;
        }
        String assetName = this.makeNewAssetName("Global", (ResourceTypeDefinition)this.globalsType);
        GlobalsModel model = this.makeGlobalsModel(globals);
        this.globalsService.create(context, assetName, (Object)model, "Converted from XLS Decision Table");
        result.addMessage("Created Globals '" + assetName + "'", ConversionMessageType.INFO);
    }

    private GlobalsModel makeGlobalsModel(List<org.drools.template.model.Global> globals) {
        GlobalsModel model = new GlobalsModel();
        for (org.drools.template.model.Global global : globals) {
            model.getGlobals().add(new Global(global.getIdentifier(), global.getClassName()));
        }
        return model;
    }

    private void createNewImports(org.uberfire.backend.vfs.Path context, List<Import> imports, ConversionResult result) {
        if (imports == null || imports.isEmpty()) {
            return;
        }
        ProjectImports projectImports = new ProjectImports();
        Path nioExternalImportsPath = this.paths.convert(context).resolve("project.imports");
        org.uberfire.backend.vfs.Path externalImportsPath = this.paths.convert(nioExternalImportsPath);
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            projectImports = (ProjectImports)this.projectService.load(externalImportsPath);
        }
        ArrayList<String> existingImports = new ArrayList<String>();
        for (org.drools.workbench.models.commons.shared.imports.Import item : projectImports.getImports().getImports()) {
            existingImports.add(item.getType());
        }
        boolean isModified = false;
        for (Import item : imports) {
            if (existingImports.contains(item.getClassName())) continue;
            isModified = true;
            result.addMessage("Created Import for '" + item.getClassName() + "'.", ConversionMessageType.INFO);
            projectImports.getImports().addImport(new org.drools.workbench.models.commons.shared.imports.Import(item.getClassName()));
        }
        if (isModified) {
            Metadata metadata = this.metadataService.getMetadata(context);
            this.projectService.save(externalImportsPath, (Object)projectImports, metadata, "Imports added during XLS conversion");
        }
    }

    private void createNewDecisionTables(org.uberfire.backend.vfs.Path context, List<Import> imports, List<GuidedDecisionTable52> dtables, ConversionResult result) {
        if (dtables == null || dtables.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < dtables.size(); ++iCounter) {
            GuidedDecisionTable52 dtable = dtables.get(iCounter);
            for (Import item : imports) {
                dtable.getImports().addImport(new org.drools.workbench.models.commons.shared.imports.Import(item.getClassName()));
            }
            String assetName = this.makeNewAssetName(dtable.getTableName(), (ResourceTypeDefinition)this.guidedDTableType);
            this.guidedDecisionTableService.create(context, assetName, (Object)dtable, "Converted from XLS Decision Table");
            result.addMessage("Created Guided Decision Table '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private String makeNewAssetName(String baseName, ResourceTypeDefinition type) {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder(baseName);
        sb.append(" (converted on ");
        sb.append(DateUtils.format((Date)now.getTime()));
        sb.append(" ");
        sb.append(now.get(11));
        sb.append(":");
        sb.append(now.get(12));
        sb.append(":");
        sb.append(now.get(13));
        sb.append(")");
        sb.append(".").append(type.getSuffix());
        return sb.toString();
    }
}

