/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.AbstractGuidedDecisionTableAttributeBuilder;

public class GuidedDecisionTableSalienceBuilder
extends AbstractGuidedDecisionTableAttributeBuilder {
    private final boolean isSequential;

    public GuidedDecisionTableSalienceBuilder(int row, int column, boolean isSequential, ConversionResult conversionResult) {
        super(row, column, ActionType.Code.SALIENCE, conversionResult);
        this.isSequential = isSequential;
    }

    @Override
    public void populateDecisionTable(GuidedDecisionTable52 dtable) {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("salience");
        if (this.isSequential) {
            column.setUseRowNumber(true);
            column.setReverseOrder(true);
            int maxRow = this.values.size();
            for (int iRow = 0; iRow < maxRow; ++iRow) {
                DTCellValue52 dcv = (DTCellValue52)this.values.get(iRow);
                dcv.setNumericValue(new Integer(maxRow - iRow));
            }
        }
        dtable.getAttributeCols().add(column);
        this.addColumnData(dtable, (DTColumnConfig52)column);
    }

    public void addCellValue(int row, int column, String content) {
        String value = content;
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.lastIndexOf(")") - 1);
        }
        DTCellValue52 dcv = new DTCellValue52();
        try {
            dcv.setNumericValue(new Integer(value));
        }
        catch (NumberFormatException nfe) {
            String message = "Priority is not an integer literal, in cell " + RuleSheetParserUtil.rc2name((int)row, (int)column);
            this.conversionResult.addMessage(message, ConversionMessageType.WARNING);
        }
        this.values.add(dcv);
    }
}

