/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.PackageDescrIndexVisitor;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.metadata.engine.Indexer;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KObjectKey;

@ApplicationScoped
public class DecisionTableXLSFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(DecisionTableXLSFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected DecisionTableXLSResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KObject toKObject(Path path) {
        KObject index = null;
        InputStream inputStream = null;
        try {
            inputStream = this.ioService.newInputStream(path, new OpenOption[]{StandardOpenOption.READ});
            String drl = DecisionTableFactory.loadFromInputStream((InputStream)inputStream, null);
            DrlParser drlParser = new DrlParser();
            PackageDescr packageDescr = drlParser.parse(true, drl);
            if (packageDescr == null) {
                logger.error("Unable to parse DRL for '" + path.toUri().toString() + "'.");
                KObject kObject = index;
                return kObject;
            }
            ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
            DefaultIndexBuilder builder = new DefaultIndexBuilder();
            PackageDescrIndexVisitor visitor = new PackageDescrIndexVisitor(dmo, builder, packageDescr);
            visitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }
}

