/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.screens.dtablexls.backend.server.indexing.TestDecisionTableXLSFileIndexer;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeIndexTerm;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.metadata.engine.Index;
import org.uberfire.metadata.model.KObject;

public class IndexDecisionTableXLSAttributeNameTest
extends BaseIndexingTest<DecisionTableXLSResourceTypeDefinition> {
    @Test
    public void testIndexDecisionTableXLSAttributeName() throws IOException, InterruptedException {
        Path path1 = this.loadXLSFile(this.basePath, "dtable1.xls");
        Path path2 = this.loadXLSFile(this.basePath, "dtable2.xls");
        Thread.sleep(5000L);
        Index index = IndexDecisionTableXLSAttributeNameTest.getConfig().getIndexManager().get(org.uberfire.metadata.io.KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        Query query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueRuleAttributeIndexTerm("ruleflow-group")).build();
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        ArrayList<KObject> results = new ArrayList<KObject>();
        for (int i = 0; i < hits.length; ++i) {
            results.add(KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path1);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestDecisionTableXLSFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("rule_attribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected DecisionTableXLSResourceTypeDefinition getResourceTypeDefinition() {
        return new DecisionTableXLSResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private Path loadXLSFile(Path basePath, String fileName) throws IOException {
        Path path = basePath.resolve(fileName);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        OutputStream os = this.ioService().newOutputStream(path, new OpenOption[0]);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        os.close();
        return path;
    }
}

