/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.HasColumnHeadings;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.IndexedParametersValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.LiteralValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.SingleParameterValueBuilder;

public class GuidedDecisionTableRHSBuilder
implements HasColumnHeadings,
GuidedDecisionTableSourceBuilder {
    private final int headerRow;
    private final int headerCol;
    private final String variable;
    private final Map<Integer, String> columnHeaders = new HashMap<Integer, String>();
    private final Map<Integer, ParameterizedValueBuilder> valueBuilders = new HashMap<Integer, ParameterizedValueBuilder>();
    private final ParameterUtilities parameterUtilities;
    private ConversionResult conversionResult;

    public GuidedDecisionTableRHSBuilder(int row, int column, String boundVariable, ParameterUtilities parameterUtilities, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.variable = boundVariable == null ? "" : boundVariable.trim();
        this.parameterUtilities = parameterUtilities;
        this.conversionResult = conversionResult;
    }

    @Override
    public void populateDecisionTable(GuidedDecisionTable52 dtable, int maxRowCount) {
        TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(this.valueBuilders.keySet());
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = this.valueBuilders.get(index);
            this.addColumn(dtable, vb, maxRowCount, index);
        }
    }

    private void addColumn(GuidedDecisionTable52 dtable, ParameterizedValueBuilder vb, int maxRowCount, int index) {
        if (vb instanceof LiteralValueBuilder) {
            this.addLiteralColumn(dtable, (LiteralValueBuilder)vb, maxRowCount, index);
        } else {
            this.addBRLFragmentColumn(dtable, vb, maxRowCount, index);
        }
    }

    private void addLiteralColumn(GuidedDecisionTable52 dtable, LiteralValueBuilder vb, int maxRowCount, int index) {
        BRLActionColumn column = new BRLActionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText(vb.getTemplate());
        column.getDefinition().add(ffl);
        BRLActionVariableColumn parameterColumn = new BRLActionVariableColumn("", "Boolean");
        column.getChildColumns().add(parameterColumn);
        column.setHeader(this.columnHeaders.get(index));
        dtable.getActionCols().add(column);
        List<List<DTCellValue52>> columnData = this.assertColumnData(vb, maxRowCount);
        int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(0));
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
        }
    }

    private void addBRLFragmentColumn(GuidedDecisionTable52 dtable, ParameterizedValueBuilder vb, int maxRowCount, int index) {
        BRLActionColumn column = new BRLActionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText(vb.getTemplate());
        column.getDefinition().add(ffl);
        for (String parameter : vb.getParameters()) {
            BRLActionVariableColumn parameterColumn = new BRLActionVariableColumn(parameter, "Object");
            column.getChildColumns().add(parameterColumn);
        }
        column.setHeader(this.columnHeaders.get(index));
        dtable.getActionCols().add(column);
        List<List<DTCellValue52>> columnData = this.assertColumnData(vb, maxRowCount);
        int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(0));
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
        }
    }

    public void addTemplate(int row, int column, String content) {
        if (this.valueBuilders.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionMessageType.ERROR);
            return;
        }
        String template = content.trim();
        if (this.isBoundVar()) {
            template = this.variable + "." + template;
        }
        if (!template.endsWith(";")) {
            template = template + ";";
        }
        try {
            this.valueBuilders.put(column, this.getValueBuilder(template));
        }
        catch (DecisionTableParseException pe) {
            this.conversionResult.addMessage(pe.getMessage(), ConversionMessageType.WARNING);
        }
    }

    private boolean isBoundVar() {
        return !"".equals(this.variable);
    }

    @Override
    public void setColumnHeader(int column, String value) {
        this.columnHeaders.put(column, value.trim());
    }

    private ParameterizedValueBuilder getValueBuilder(String template) {
        SnippetBuilder.SnippetType type = SnippetBuilder.getType((String)template);
        switch (type) {
            case INDEXED: {
                return new IndexedParametersValueBuilder(template, this.parameterUtilities);
            }
            case PARAM: {
                return new SingleParameterValueBuilder(template, this.parameterUtilities);
            }
            case SINGLE: {
                return new LiteralValueBuilder(template);
            }
        }
        throw new DecisionTableParseException("SnippetBuilder.SnippetType '" + type.toString() + "' is not supported. The column will not be added.");
    }

    public void addCellValue(int row, int column, String value) {
        ParameterizedValueBuilder vb = this.valueBuilders.get(column);
        if (vb == null) {
            String message = "No code snippet for ACTION, above cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionMessageType.ERROR);
            return;
        }
        vb.addCellValue(row, column, value);
    }

    public String getResult() {
        throw new UnsupportedOperationException("GuidedDecisionTableRHSBuilder does not return DRL.");
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.ACTION;
    }

    public void clearValues() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRowCount() {
        int maxRowCount = 0;
        for (ParameterizedValueBuilder pvb : this.valueBuilders.values()) {
            maxRowCount = Math.max(maxRowCount, pvb.getColumnData().size());
        }
        return maxRowCount;
    }

    private List<List<DTCellValue52>> assertColumnData(ParameterizedValueBuilder pvb, int maxRowCount) {
        List<List<DTCellValue52>> columnData = pvb.getColumnData();
        List<String> parameters = pvb.getParameters();
        if (columnData.size() < maxRowCount) {
            for (int iRow = columnData.size(); iRow < maxRowCount; ++iRow) {
                ArrayList<DTCellValue52> brlFragmentData = new ArrayList<DTCellValue52>();
                for (int iCol = 0; iCol < parameters.size(); ++iCol) {
                    brlFragmentData.add(new DTCellValue52());
                }
                columnData.add(brlFragmentData);
            }
        }
        return columnData;
    }
}

