/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;

public class IndexedParametersValueBuilder
implements ParameterizedValueBuilder {
    private static final Pattern delimiter = Pattern.compile("(.*?[^\\\\])(,|\\z)");
    private final String template;
    private final List<String> parameters = new ArrayList<String>();
    private List<List<DTCellValue52>> values = new ArrayList<List<DTCellValue52>>();

    public IndexedParametersValueBuilder(String template, ParameterUtilities parameterUtilities) {
        this.template = parameterUtilities.convertIndexedParametersToTemplateKeys(template);
        this.parameters.addAll(parameterUtilities.extractTemplateKeys(this.template));
    }

    @Override
    public void addCellValue(int row, int column, String value) {
        List<String> cellVals = this.split(value);
        ArrayList<DTCellValue52> rowValues = new ArrayList<DTCellValue52>();
        for (int parameterIndex = 0; parameterIndex < this.getParameters().size(); ++parameterIndex) {
            String cv = cellVals.size() > parameterIndex ? cellVals.get(parameterIndex) : "";
            rowValues.add(new DTCellValue52(cv));
        }
        this.values.add(rowValues);
    }

    private List<String> split(String input) {
        Matcher m = delimiter.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1).replaceAll("\\\\,", ","));
        }
        return result;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public List<List<DTCellValue52>> getColumnData() {
        return this.values;
    }
}

