/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessage;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.GuidedDecisionTableGeneratorListener;
import org.junit.Assert;
import org.junit.Test;

public class DecisionTableXLSToDecisionTableGuidedConverterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributes() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Attributes.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"AttributesTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)12L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(3) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(4) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(5) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(6) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(7) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(8) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(9) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(10) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(11) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"salience", (Object)attrCol2.getAttribute());
        Assert.assertFalse((boolean)attrCol2.isUseRowNumber());
        Assert.assertFalse((boolean)attrCol2.isReverseOrder());
        AttributeCol52 attrCol3 = (AttributeCol52)columns.get(3);
        Assert.assertEquals((Object)"activation-group", (Object)attrCol3.getAttribute());
        AttributeCol52 attrCol4 = (AttributeCol52)columns.get(4);
        Assert.assertEquals((Object)"duration", (Object)attrCol4.getAttribute());
        AttributeCol52 attrCol5 = (AttributeCol52)columns.get(5);
        Assert.assertEquals((Object)"timer", (Object)attrCol5.getAttribute());
        AttributeCol52 attrCol6 = (AttributeCol52)columns.get(6);
        Assert.assertEquals((Object)"calendars", (Object)attrCol6.getAttribute());
        AttributeCol52 attrCol7 = (AttributeCol52)columns.get(7);
        Assert.assertEquals((Object)"no-loop", (Object)attrCol7.getAttribute());
        AttributeCol52 attrCol8 = (AttributeCol52)columns.get(8);
        Assert.assertEquals((Object)"lock-on-active", (Object)attrCol8.getAttribute());
        AttributeCol52 attrCol9 = (AttributeCol52)columns.get(9);
        Assert.assertEquals((Object)"auto-focus", (Object)attrCol9.getAttribute());
        AttributeCol52 attrCol10 = (AttributeCol52)columns.get(10);
        Assert.assertEquals((Object)"agenda-group", (Object)attrCol10.getAttribute());
        AttributeCol52 attrCol11 = (AttributeCol52)columns.get(11);
        Assert.assertEquals((Object)"ruleflow-group", (Object)attrCol11.getAttribute());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Specific rule 1", "1", "g1", "100", "T1", "CAL1", "TRUE", "TRUE", "TRUE", "AG1", "RFG1"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Specific rule 2", "2", "g2", "200", "T2", "CAL2", "FALSE", "FALSE", "FALSE", "AG2", "RFG2"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequentialSalience() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("SequentialSalience.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"SequentialSalienceTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"salience", (Object)attrCol2.getAttribute());
        Assert.assertTrue((boolean)attrCol2.isUseRowNumber());
        Assert.assertTrue((boolean)attrCol2.isReverseOrder());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 8", "2"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 9", "1"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSalienceWarnings() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("SalienceWarnings.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)2L, (long)result.getMessages().size());
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(0)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(0)).getMessage().indexOf("Priority is not an integer literal, in cell C7") == -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(1)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(1)).getMessage().indexOf("Priority is not an integer literal, in cell C8") == -1 ? 1 : 0) != 0);
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"SalienceWarningsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"salience", (Object)attrCol2.getAttribute());
        Assert.assertFalse((boolean)attrCol2.isUseRowNumber());
        Assert.assertFalse((boolean)attrCol2.isReverseOrder());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 7", ""}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 8", ""}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDurationWarnings() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("DurationWarnings.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)2L, (long)result.getMessages().size());
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(0)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(0)).getMessage().indexOf("Duration is not an long literal, in cell C7") == -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(1)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(1)).getMessage().indexOf("Duration is not an long literal, in cell C8") == -1 ? 1 : 0) != 0);
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"DurationWarningsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"duration", (Object)attrCol2.getAttribute());
        Assert.assertFalse((boolean)attrCol2.isUseRowNumber());
        Assert.assertFalse((boolean)attrCol2.isReverseOrder());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 7", ""}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 8", ""}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadata() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Metadata.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"MetadataTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof MetadataCol52));
        MetadataCol52 mdCol2 = (MetadataCol52)columns.get(2);
        Assert.assertEquals((Object)"cheese", (Object)mdCol2.getMetadata());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 7", "cheddar"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 8", "edam"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActions() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Actions.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"ActionsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)7L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)4L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        Assert.assertTrue((boolean)(dtable.getActionCols().get(1) instanceof BRLActionColumn));
        Assert.assertTrue((boolean)(dtable.getActionCols().get(2) instanceof BRLActionColumn));
        Assert.assertTrue((boolean)(dtable.getActionCols().get(3) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Multi-parameters", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)2L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"policy.setBasePrice(@{param1}, @{param2});", (Object)actionCol0ffl.getText());
        BRLActionVariableColumn actionCol0param0 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)actionCol0param0.getVarName());
        Assert.assertEquals((Object)"Multi-parameters", (Object)actionCol0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0param0.getFieldType());
        Assert.assertNull((Object)actionCol0param0.getFactType());
        Assert.assertNull((Object)actionCol0param0.getFactField());
        BRLActionVariableColumn actionCol0param1 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)actionCol0param1.getVarName());
        Assert.assertEquals((Object)"Multi-parameters", (Object)actionCol0param1.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0param1.getFieldType());
        Assert.assertNull((Object)actionCol0param1.getFactType());
        Assert.assertNull((Object)actionCol0param1.getFactField());
        BRLActionColumn actionCol1 = (BRLActionColumn)dtable.getActionCols().get(1);
        Assert.assertEquals((Object)"Single-parameter", (Object)actionCol1.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol1.getChildColumns().size());
        List actionCol1definition = actionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol1definition.size());
        Assert.assertTrue((boolean)(actionCol1definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol1ffl = (FreeFormLine)actionCol1definition.get(0);
        Assert.assertEquals((Object)"policy.setSmurf(@{param3});", (Object)actionCol1ffl.getText());
        BRLActionVariableColumn actionCol1param0 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param3", (Object)actionCol1param0.getVarName());
        Assert.assertEquals((Object)"Single-parameter", (Object)actionCol1param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol1param0.getFieldType());
        Assert.assertNull((Object)actionCol1param0.getFactType());
        Assert.assertNull((Object)actionCol1param0.getFactField());
        BRLActionColumn actionCol2 = (BRLActionColumn)dtable.getActionCols().get(2);
        Assert.assertEquals((Object)"Log-single-parameter", (Object)actionCol2.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol2.getChildColumns().size());
        List actionCol2definition = actionCol2.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol2definition.size());
        Assert.assertTrue((boolean)(actionCol2definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol2ffl = (FreeFormLine)actionCol2definition.get(0);
        Assert.assertEquals((Object)"System.out.println(\"@{param4}\");", (Object)actionCol2ffl.getText());
        BRLActionVariableColumn actionCol2param0 = (BRLActionVariableColumn)actionCol2.getChildColumns().get(0);
        Assert.assertEquals((Object)"param4", (Object)actionCol2param0.getVarName());
        Assert.assertEquals((Object)"Log-single-parameter", (Object)actionCol2param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol2param0.getFieldType());
        Assert.assertNull((Object)actionCol2param0.getFactType());
        Assert.assertNull((Object)actionCol2param0.getFactField());
        BRLActionColumn actionCol3 = (BRLActionColumn)dtable.getActionCols().get(3);
        Assert.assertEquals((Object)"Zero-parameters", (Object)actionCol3.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol3.getChildColumns().size());
        List actionCol3definition = actionCol3.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol3definition.size());
        Assert.assertTrue((boolean)(actionCol3definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol3ffl = (FreeFormLine)actionCol3definition.get(0);
        Assert.assertEquals((Object)"System.out.println(\"Woot\");", (Object)actionCol3ffl.getText());
        BRLActionVariableColumn actionCol3param0 = (BRLActionVariableColumn)actionCol3.getChildColumns().get(0);
        Assert.assertEquals((Object)"", (Object)actionCol3param0.getVarName());
        Assert.assertEquals((Object)"Zero-parameters", (Object)actionCol3param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol3param0.getFieldType());
        Assert.assertNull((Object)actionCol3param0.getFactType());
        Assert.assertNull((Object)actionCol3param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 7", "10", "20", "30", "hello", "TRUE"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 8", "50", "60", "70", "goodbye", "FALSE"}, (List)dtable.getData().get(1)));
    }

    @Test
    public void testConditions() {
        ArrayList<String[]> expectedRows = new ArrayList<String[]>(2);
        expectedRows.add(new String[]{"1", "Created from row 7", "20", "Mike", "Brown", "BMW", "M3"});
        expectedRows.add(new String[]{"2", "Created from row 8", "30", "Jason", "Grey", "Audi", "S4"});
        this.conditionsTest("Conditions.xls", expectedRows);
    }

    @Test
    public void testConditionsIndexedParameters() {
        ArrayList<String[]> expectedRows = new ArrayList<String[]>(2);
        expectedRows.add(new String[]{"1", "Created from row 7", "20", "Mike", "Brown", "BMW", "M3"});
        expectedRows.add(new String[]{"2", "Created from row 8", "30", "Jason", "Grey", "", ""});
        this.conditionsTest("Conditions-indexedParameters.xls", expectedRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conditionsTest(String xlsFileName, List<String[]> expectedRows) {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream(xlsFileName);
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"ConditionsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)7L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLConditionVariableColumn));
        Assert.assertEquals((long)2L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        Assert.assertTrue((boolean)(dtable.getConditions().get(1) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from cell [C4]", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)3L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine conditionCol0ffl = (FreeFormLine)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Driver(age > \"@{param1}\", firstName == \"@{param2}\", surname == \"@{param3}\")", (Object)conditionCol0ffl.getText());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Converted from cell [C4]", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol0param0.getFieldType());
        Assert.assertNull((Object)conditionCol0param0.getFactType());
        Assert.assertNull((Object)conditionCol0param0.getFactField());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"Converted from cell [C4]", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol0param1.getFieldType());
        Assert.assertNull((Object)conditionCol0param1.getFactType());
        Assert.assertNull((Object)conditionCol0param1.getFactField());
        BRLConditionVariableColumn conditionCol0param2 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(2);
        Assert.assertEquals((Object)"param3", (Object)conditionCol0param2.getVarName());
        Assert.assertEquals((Object)"Converted from cell [C4]", (Object)conditionCol0param2.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol0param2.getFieldType());
        Assert.assertNull((Object)conditionCol0param2.getFactType());
        Assert.assertNull((Object)conditionCol0param2.getFactField());
        BRLConditionColumn conditionCol1 = (BRLConditionColumn)dtable.getConditions().get(1);
        Assert.assertEquals((Object)"something", (Object)conditionCol1.getHeader());
        Assert.assertEquals((long)2L, (long)conditionCol1.getChildColumns().size());
        List conditionCol1definition = conditionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol1definition.size());
        Assert.assertTrue((boolean)(conditionCol1definition.get(0) instanceof FreeFormLine));
        FreeFormLine conditionCol1ffl = (FreeFormLine)conditionCol1definition.get(0);
        Assert.assertEquals((Object)"Vehicle(make == \"@{param4}\", model == \"@{param5}\")", (Object)conditionCol1ffl.getText());
        BRLConditionVariableColumn conditionCol1param0 = (BRLConditionVariableColumn)conditionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param4", (Object)conditionCol1param0.getVarName());
        Assert.assertEquals((Object)"something", (Object)conditionCol1param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol1param0.getFieldType());
        Assert.assertNull((Object)conditionCol1param0.getFactType());
        Assert.assertNull((Object)conditionCol1param0.getFactField());
        BRLConditionVariableColumn conditionCol1param1 = (BRLConditionVariableColumn)conditionCol1.getChildColumns().get(1);
        Assert.assertEquals((Object)"param5", (Object)conditionCol1param1.getVarName());
        Assert.assertEquals((Object)"something", (Object)conditionCol1param1.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol1param1.getFieldType());
        Assert.assertNull((Object)conditionCol1param1.getFactType());
        Assert.assertNull((Object)conditionCol1param1.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertNotNull(expectedRows);
        Assert.assertTrue((expectedRows.size() == 2 ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.isRowEquivalent(expectedRows.get(i), (List)dtable.getData().get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRuleTables() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("MultipleRuleTables.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)2L, (long)dtables.size());
        GuidedDecisionTable52 dtable0 = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"Table1", (Object)dtable0.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable0.getTableFormat());
        GuidedDecisionTable52 dtable1 = (GuidedDecisionTable52)dtables.get(1);
        Assert.assertEquals((Object)"Table2", (Object)dtable1.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable1.getTableFormat());
        List columns0 = dtable0.getExpandedColumns();
        Assert.assertNotNull((Object)columns0);
        Assert.assertEquals((long)5L, (long)columns0.size());
        Assert.assertTrue((boolean)(columns0.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns0.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns0.get(2) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns0.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns0.get(4) instanceof BRLActionVariableColumn));
        AttributeCol52 attrCol0_2 = (AttributeCol52)columns0.get(2);
        Assert.assertEquals((Object)"agenda-group", (Object)attrCol0_2.getAttribute());
        Assert.assertEquals((long)1L, (long)dtable0.getConditions().size());
        Assert.assertTrue((boolean)(dtable0.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0_0 = (BRLConditionColumn)dtable0.getConditions().get(0);
        Assert.assertEquals((Object)"Person's name", (Object)conditionCol0_0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0_0.getChildColumns().size());
        List conditionCol0_0definition = conditionCol0_0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0_0definition.size());
        Assert.assertTrue((boolean)(conditionCol0_0definition.get(0) instanceof FreeFormLine));
        FreeFormLine conditionCol0_0ffl = (FreeFormLine)conditionCol0_0definition.get(0);
        Assert.assertEquals((Object)"Person(name == \"@{param1}\")", (Object)conditionCol0_0ffl.getText());
        BRLConditionVariableColumn conditionCol0_0param0 = (BRLConditionVariableColumn)conditionCol0_0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0_0param0.getVarName());
        Assert.assertEquals((Object)"Person's name", (Object)conditionCol0_0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol0_0param0.getFieldType());
        Assert.assertNull((Object)conditionCol0_0param0.getFactType());
        Assert.assertNull((Object)conditionCol0_0param0.getFactField());
        BRLActionColumn actionCol0_0 = (BRLActionColumn)dtable0.getActionCols().get(0);
        Assert.assertEquals((Object)"Salutation", (Object)actionCol0_0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0_0.getChildColumns().size());
        List actionCol0_0definition = actionCol0_0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0_0definition.size());
        Assert.assertTrue((boolean)(actionCol0_0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0_0ffl = (FreeFormLine)actionCol0_0definition.get(0);
        Assert.assertEquals((Object)"System.out.println(\"@{param2}\");", (Object)actionCol0_0ffl.getText());
        BRLActionVariableColumn actionCol0_0param0 = (BRLActionVariableColumn)actionCol0_0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param2", (Object)actionCol0_0param0.getVarName());
        Assert.assertEquals((Object)"Salutation", (Object)actionCol0_0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0_0param0.getFieldType());
        Assert.assertNull((Object)actionCol0_0param0.getFactType());
        Assert.assertNull((Object)actionCol0_0param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable0.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 7", "AG1", "John", "Hello Sir"}, (List)dtable0.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 8", "AG2", "Jane", "Hello Madam"}, (List)dtable0.getData().get(1)));
        List columns1 = dtable1.getExpandedColumns();
        Assert.assertNotNull((Object)columns1);
        Assert.assertEquals((long)4L, (long)columns1.size());
        Assert.assertTrue((boolean)(columns1.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns1.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns1.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns1.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable0.getConditions().size());
        Assert.assertTrue((boolean)(dtable0.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol1_0 = (BRLConditionColumn)dtable1.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from cell [C12]", (Object)conditionCol1_0.getHeader());
        Assert.assertEquals((long)2L, (long)conditionCol1_0.getChildColumns().size());
        List conditionCol1_0definition = conditionCol1_0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol1_0definition.size());
        Assert.assertTrue((boolean)(conditionCol1_0definition.get(0) instanceof FreeFormLine));
        FreeFormLine conditionCol1_0ffl = (FreeFormLine)conditionCol1_0definition.get(0);
        Assert.assertEquals((Object)"Person(name == \"@{param1}\", age == \"@{param2}\")", (Object)conditionCol1_0ffl.getText());
        BRLConditionVariableColumn conditionCol1_0param0 = (BRLConditionVariableColumn)conditionCol1_0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol1_0param0.getVarName());
        Assert.assertEquals((Object)"Converted from cell [C12]", (Object)conditionCol1_0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol1_0param0.getFieldType());
        Assert.assertNull((Object)conditionCol1_0param0.getFactType());
        Assert.assertNull((Object)conditionCol1_0param0.getFactField());
        BRLConditionVariableColumn conditionCol1_0param1 = (BRLConditionVariableColumn)conditionCol1_0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol1_0param1.getVarName());
        Assert.assertEquals((Object)"Converted from cell [C12]", (Object)conditionCol1_0param1.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol1_0param1.getFieldType());
        Assert.assertNull((Object)conditionCol1_0param1.getFactType());
        Assert.assertNull((Object)conditionCol1_0param1.getFactField());
        Assert.assertEquals((long)2L, (long)dtable1.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 15", "John", "25"}, (List)dtable1.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 16", "Jane", "29"}, (List)dtable1.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSingleParameters() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("MultipleSingleParameters.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"MultipleSingleParameters", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Re-using single parameter", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine conditionCol0ffl = (FreeFormLine)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Driver(@{param1} != null, @{param1} == true)", (Object)conditionCol0ffl.getText());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Re-using single parameter", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol0param0.getFieldType());
        Assert.assertNull((Object)conditionCol0param0.getFactType());
        Assert.assertNull((Object)conditionCol0param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"1", "Created from row 7", "isQualified"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new String[]{"2", "Created from row 8", "isLicensed"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperties() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Properties.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List functions = listener.getFunctions();
        Assert.assertNotNull((Object)functions);
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertEquals((Object)"function a() { }", functions.get(0));
        List globals = listener.getGlobals();
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)1L, (long)globals.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Global)globals.get(0)).getClassName());
        Assert.assertEquals((Object)"list", (Object)((Global)globals.get(0)).getIdentifier());
        List imports = listener.getImports();
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"org.yourco.model.*", (Object)((Import)imports.get(0)).getClassName());
        Assert.assertEquals((Object)"java.util.Date", (Object)((Import)imports.get(1)).getClassName());
        List queries = listener.getQueries();
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        Assert.assertEquals((Object)"A query", queries.get(0));
        List types = listener.getTypeDeclarations();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)"declare Smurf name : String end", types.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTestNonExistentCellsFromPOI() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2188.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyCells() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("EmptySpreadsheetCells.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"ExceptionPrivateCar", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)20L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(3) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(7) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(8) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(9) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(10) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(11) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(12) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(13) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(14) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(15) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(16) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(17) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(18) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(19) instanceof BRLActionVariableColumn));
    }

    private boolean isRowEquivalent(String[] expected, List<DTCellValue52> actual) {
        if (expected.length != actual.size()) {
            return false;
        }
        block12: for (int i = 0; i < expected.length; ++i) {
            DTCellValue52 dcv = actual.get(i);
            switch (dcv.getDataType()) {
                case NUMERIC: {
                    BigDecimal numeric = (BigDecimal)dcv.getNumericValue();
                    if (expected[i].equals(numeric.toPlainString())) continue block12;
                    return false;
                }
                case NUMERIC_BIGDECIMAL: {
                    BigDecimal numericBigDecimal = (BigDecimal)dcv.getNumericValue();
                    if (expected[i].equals(numericBigDecimal.toPlainString())) continue block12;
                    return false;
                }
                case NUMERIC_BIGINTEGER: {
                    BigInteger numericBigInteger = (BigInteger)dcv.getNumericValue();
                    if (expected[i].equals(numericBigInteger.toString())) continue block12;
                    return false;
                }
                case NUMERIC_BYTE: {
                    Byte numericByte = (Byte)dcv.getNumericValue();
                    if (expected[i].equals(numericByte.toString())) continue block12;
                    return false;
                }
                case NUMERIC_DOUBLE: {
                    Double numericDouble = (Double)dcv.getNumericValue();
                    if (expected[i].equals(numericDouble.toString())) continue block12;
                    return false;
                }
                case NUMERIC_FLOAT: {
                    Float numericFloat = (Float)dcv.getNumericValue();
                    if (expected[i].equals(numericFloat.toString())) continue block12;
                    return false;
                }
                case NUMERIC_INTEGER: {
                    Integer numericInteger = (Integer)dcv.getNumericValue();
                    if (expected[i].equals(numericInteger.toString())) continue block12;
                    return false;
                }
                case NUMERIC_LONG: {
                    Long numericLong = (Long)dcv.getNumericValue();
                    if (expected[i].equals(numericLong.toString())) continue block12;
                    return false;
                }
                case NUMERIC_SHORT: {
                    Short numericShort = (Short)dcv.getNumericValue();
                    if (expected[i].equals(numericShort.toString())) continue block12;
                    return false;
                }
                case BOOLEAN: {
                    if (Boolean.parseBoolean(expected[i]) == dcv.getBooleanValue()) continue block12;
                    return false;
                }
                default: {
                    if (expected[i].equals(dcv.getStringValue())) continue block12;
                    return false;
                }
            }
        }
        return true;
    }
}

