/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderIndirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.HasColumnHeadings;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.IndexedParametersValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.LiteralValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.SingleParameterValueBuilder;

public class GuidedDecisionTableLHSBuilder
implements HasColumnHeadings,
GuidedDecisionTableSourceBuilderIndirect {
    private final int headerRow;
    private final int headerCol;
    private String colDefPrefix;
    private String colDefSuffix;
    private boolean hasPattern;
    private String andop;
    private List<String> drlFragments = new ArrayList<String>();
    private static Set<String> operators = new HashSet<String>();
    private static final Pattern patParFrm;
    private static final Pattern patFrm;
    private static final Pattern patPar;
    private static final Pattern patEval;
    private final Map<Integer, String> columnHeaders = new HashMap<Integer, String>();
    private final Map<Integer, ParameterizedValueBuilder> valueBuilders = new HashMap<Integer, ParameterizedValueBuilder>();
    private final ParameterUtilities parameterUtilities;
    private ConversionResult conversionResult;

    public GuidedDecisionTableLHSBuilder(int row, int column, String colDefinition, ParameterUtilities parameterUtilities, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.parameterUtilities = parameterUtilities;
        this.conversionResult = conversionResult;
        this.preProcessColumnDefinition(colDefinition);
    }

    private void preProcessColumnDefinition(String colDefinition) {
        String colDef;
        String string = colDef = colDefinition == null ? "" : colDefinition;
        if ("".equals(colDef)) {
            this.colDefSuffix = "";
            this.colDefPrefix = "";
            this.hasPattern = false;
            this.andop = "";
            return;
        }
        this.hasPattern = true;
        Matcher matEval = patEval.matcher(colDef);
        if (matEval.find()) {
            this.colDefPrefix = colDef.substring(0, matEval.start()) + "eval(";
            this.colDefSuffix = ")";
            this.andop = " && ";
            return;
        }
        this.andop = ", ";
        Matcher matParFrm = patParFrm.matcher(colDef);
        if (matParFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matParFrm.start()) + '(';
            this.colDefSuffix = ") from" + colDef.substring(matParFrm.end());
            return;
        }
        Matcher matFrm = patFrm.matcher(colDef);
        if (matFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matFrm.start()) + "(";
            this.colDefSuffix = ") from " + colDef.substring(matFrm.end());
            return;
        }
        Matcher matPar = patPar.matcher(colDef);
        if (matPar.find()) {
            this.colDefPrefix = colDef.substring(0, matPar.start()) + '(';
            this.colDefSuffix = ")" + colDef.substring(matPar.end());
            return;
        }
        this.colDefPrefix = colDef + '(';
        this.colDefSuffix = ")";
    }

    @Override
    public List<BRLVariableColumn> getVariableColumns() {
        if (!this.hasPattern) {
            return this.addExplicitColumns();
        }
        return this.addPatternColumn();
    }

    @Override
    public Map<Integer, ParameterizedValueBuilder> getValueBuilders() {
        return this.valueBuilders;
    }

    private List<BRLVariableColumn> addExplicitColumns() {
        TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(this.valueBuilders.keySet());
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = this.valueBuilders.get(index);
            ArrayList<BRLVariableColumn> vbVariableColumns = new ArrayList<BRLVariableColumn>();
            if (vb instanceof LiteralValueBuilder) {
                vbVariableColumns.addAll(this.addLiteralColumn((LiteralValueBuilder)vb));
                for (BRLVariableColumn vbVariableColumn : vbVariableColumns) {
                    ((BRLConditionVariableColumn)vbVariableColumn).setHeader(this.columnHeaders.get(index));
                }
            } else {
                vbVariableColumns.addAll(this.addBRLFragmentColumn(vb));
                for (BRLVariableColumn vbVariableColumn : vbVariableColumns) {
                    ((BRLConditionVariableColumn)vbVariableColumn).setHeader(this.columnHeaders.get(index));
                }
            }
            variableColumns.addAll(vbVariableColumns);
        }
        return variableColumns;
    }

    private List<BRLVariableColumn> addLiteralColumn(LiteralValueBuilder vb) {
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        BRLConditionVariableColumn parameterColumn = new BRLConditionVariableColumn("", "Boolean");
        variableColumns.add((BRLVariableColumn)parameterColumn);
        this.drlFragments.add(vb.getTemplate());
        return variableColumns;
    }

    private List<BRLVariableColumn> addBRLFragmentColumn(ParameterizedValueBuilder vb) {
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        for (String parameter : vb.getParameters()) {
            BRLConditionVariableColumn parameterColumn = new BRLConditionVariableColumn(parameter, "Object");
            variableColumns.add((BRLVariableColumn)parameterColumn);
        }
        this.drlFragments.add(vb.getTemplate());
        return variableColumns;
    }

    private List<BRLVariableColumn> addPatternColumn() {
        TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(this.valueBuilders.keySet());
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        String columnHeader = this.columnHeaders.get(sortedIndexes.first());
        if (sortedIndexes.size() > 1) {
            columnHeader = "Converted from cell [" + RuleSheetParserUtil.rc2name((int)(this.headerRow + 1), (int)this.headerCol) + "]";
        }
        StringBuffer drl = new StringBuffer();
        drl.append(this.colDefPrefix);
        String sep = "";
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = this.valueBuilders.get(index);
            for (String parameter : vb.getParameters()) {
                BRLConditionVariableColumn parameterColumn = new BRLConditionVariableColumn(parameter, "Object");
                parameterColumn.setHeader(columnHeader);
                variableColumns.add((BRLVariableColumn)parameterColumn);
            }
            drl.append(sep).append(vb.getTemplate());
            sep = this.andop;
        }
        drl.append(this.colDefSuffix);
        this.drlFragments.add(drl.toString());
        return variableColumns;
    }

    public void addTemplate(int row, int column, String content) {
        if (this.valueBuilders.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionMessageType.ERROR);
            return;
        }
        String template = content.trim();
        try {
            this.valueBuilders.put(column, this.getValueBuilder(template));
        }
        catch (DecisionTableParseException pe) {
            this.conversionResult.addMessage(pe.getMessage(), ConversionMessageType.WARNING);
        }
    }

    @Override
    public void setColumnHeader(int column, String value) {
        this.columnHeaders.put(column, value.trim());
    }

    private ParameterizedValueBuilder getValueBuilder(String content) {
        String template = content.trim();
        SnippetBuilder.SnippetType type = SnippetBuilder.getType((String)template);
        if (type == SnippetBuilder.SnippetType.SINGLE) {
            type = SnippetBuilder.SnippetType.PARAM;
            boolean hasExplicitOperator = false;
            for (String op : operators) {
                if (!template.endsWith(op)) continue;
                hasExplicitOperator = true;
                break;
            }
            if (!hasExplicitOperator) {
                template = template + " ==";
            }
            template = template + " \"";
            template = template + "$param" + "\"";
        }
        switch (type) {
            case INDEXED: {
                return new IndexedParametersValueBuilder(template, this.parameterUtilities);
            }
            case PARAM: {
                return new SingleParameterValueBuilder(template, this.parameterUtilities);
            }
            case SINGLE: {
                return new LiteralValueBuilder(template);
            }
        }
        throw new DecisionTableParseException("SnippetBuilder.SnippetType '" + type.toString() + "' is not supported. The column will not be added.");
    }

    public void addCellValue(int row, int column, String value) {
        ParameterizedValueBuilder vb = this.valueBuilders.get(column);
        if (vb == null) {
            String message = "No code snippet for CONDITION, above cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionMessageType.ERROR);
            return;
        }
        vb.addCellValue(row, column, value);
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.CONDITION;
    }

    public String getResult() {
        StringBuilder sb = new StringBuilder();
        for (String drlFragment : this.drlFragments) {
            sb.append(drlFragment).append("\n");
        }
        return sb.toString();
    }

    public void clearValues() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRowCount() {
        int maxRowCount = 0;
        for (ParameterizedValueBuilder pvb : this.valueBuilders.values()) {
            maxRowCount = Math.max(maxRowCount, pvb.getColumnData().size());
        }
        return maxRowCount;
    }

    static {
        operators.add("==");
        operators.add("=");
        operators.add("!=");
        operators.add("<");
        operators.add(">");
        operators.add("<=");
        operators.add(">=");
        operators.add("contains");
        operators.add("matches");
        operators.add("memberOf");
        operators.add("str[startsWith]");
        operators.add("str[endsWith]");
        operators.add("str[length]");
        patParFrm = Pattern.compile("\\(\\s*\\)\\s*from\\b");
        patFrm = Pattern.compile("\\s+from\\s+");
        patPar = Pattern.compile("\\(\\s*\\)");
        patEval = Pattern.compile("\\beval\\s*(?:\\(\\s*\\)\\s*)?$");
    }
}

