/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.dtablexls.backend.server.DecisionTableXLSServiceImpl;
import org.drools.workbench.screens.dtablexls.backend.server.ExtendedDecisionTableXLSService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.util.CommentedOptionFactoryImpl;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTableXLSServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private CopyService copyService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Mock
    private DecisionTableXLSConversionService conversionService;
    @Mock
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory = new CommentedOptionFactoryImpl();
    @Mock
    private AuthenticationService authenticationService;
    @Mock
    private User user;
    @Mock
    private org.uberfire.backend.vfs.Path path;
    @Mock
    private InputStream inputstream;
    @Mock
    private OutputStream outputStream;
    @Captor
    private ArgumentCaptor<CommentedOption> commentedOptionArgumentCaptor;
    private final String sessionId = "123";
    private final String comment = "comment";
    private ExtendedDecisionTableXLSService service;

    @Before
    public void setup() throws IOException {
        this.service = new DecisionTableXLSServiceImpl(this.ioService, this.copyService, this.deleteService, this.renameService, this.resourceOpenedEvent, this.conversionService, this.genericValidator, this.commentedOptionFactory, this.authenticationService){

            void validate(File tempFile) {
            }
        };
        Mockito.when((Object)this.authenticationService.getUser()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://p0/src/main/resources/dtable.xls");
        Mockito.when((Object)this.inputstream.read((byte[])Mockito.any(byte[].class))).thenReturn((Object)-1);
        Mockito.when((Object)this.ioService.newOutputStream((Path)Mockito.any(Path.class), new OpenOption[]{(OpenOption)this.commentedOptionArgumentCaptor.capture()})).thenReturn((Object)this.outputStream);
    }

    @Test
    public void testSessionInfoOnCreate() {
        this.service.create(this.path, this.inputstream, "123", "comment");
        CommentedOption commentedOption = (CommentedOption)this.commentedOptionArgumentCaptor.getValue();
        Assert.assertNotNull((Object)commentedOption);
        Assert.assertEquals((Object)"user", (Object)commentedOption.getName());
        Assert.assertEquals((Object)"123", (Object)commentedOption.getSessionId());
    }

    @Test
    public void testSessionInfoOnSave() {
        this.service.save(this.path, this.inputstream, "123", "comment");
        CommentedOption commentedOption = (CommentedOption)this.commentedOptionArgumentCaptor.getValue();
        Assert.assertNotNull((Object)commentedOption);
        Assert.assertEquals((Object)"user", (Object)commentedOption.getName());
        Assert.assertEquals((Object)"123", (Object)commentedOption.getSessionId());
    }
}

