/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.DTCellValueUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableLHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableRHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderDirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderIndirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.LiteralValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;

public class GuidedDecisionTablePopulater {
    private final GuidedDecisionTable52 dtable;
    private final List<GuidedDecisionTableSourceBuilder> sourceBuilders;
    private final PackageDataModelOracle dmo;

    public GuidedDecisionTablePopulater(GuidedDecisionTable52 dtable, List<GuidedDecisionTableSourceBuilder> sourceBuilders, PackageDataModelOracle dmo) {
        this.dtable = dtable;
        this.sourceBuilders = sourceBuilders;
        this.dmo = dmo;
    }

    public void populate() {
        int maxRowCount = this.getMaxRowCount();
        this.processDirectSourceBuilders(maxRowCount);
        this.processIndirectSourceBuilders(maxRowCount);
    }

    private int getMaxRowCount() {
        int maxRowCount = 0;
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            maxRowCount = Math.max(maxRowCount, sb.getRowCount());
        }
        return maxRowCount;
    }

    private void processDirectSourceBuilders(int maxRowCount) {
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableSourceBuilderDirect)) continue;
            ((GuidedDecisionTableSourceBuilderDirect)sb).populateDecisionTable(this.dtable, maxRowCount);
        }
    }

    private void processIndirectSourceBuilders(int maxRowCount) {
        this.addIndirectSourceBuildersColumns();
        this.addIndirectSourceBuildersData(maxRowCount);
    }

    private void addIndirectSourceBuildersColumns() {
        BRLConditionVariableColumn target;
        BRLConditionVariableColumn source;
        String dataType;
        String varName;
        InterpolationVariable iv;
        Iterator ivsIts;
        ArrayList ivs;
        RuleModelVisitor rmv;
        HashMap templateKeys;
        BRLConditionColumn column;
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        for (GuidedDecisionTableSourceBuilder guidedDecisionTableSourceBuilder : this.sourceBuilders) {
            if (!(guidedDecisionTableSourceBuilder instanceof GuidedDecisionTableSourceBuilderIndirect)) continue;
            for (BRLVariableColumn variableColumn : ((GuidedDecisionTableSourceBuilderIndirect)guidedDecisionTableSourceBuilder).getVariableColumns()) {
                variableColumns.add(variableColumn);
            }
        }
        StringBuilder rule = new StringBuilder();
        if (this.dmo.getPackageName() != null && !this.dmo.getPackageName().isEmpty()) {
            rule.append("package ").append(this.dmo.getPackageName()).append("\n");
        }
        rule.append("rule 'temp' \n").append("when \n");
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableLHSBuilder)) continue;
            rule.append(sb.getResult());
        }
        rule.append("\nthen \n");
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableRHSBuilder)) continue;
            rule.append(sb.getResult());
        }
        rule.append("end");
        RuleModel ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshal(rule.toString(), Collections.EMPTY_LIST, this.dmo);
        if (ruleModel.lhs != null) {
            for (IPattern iPattern : ruleModel.lhs) {
                column = new BRLConditionColumn();
                column.getDefinition().add(iPattern);
                this.dtable.getConditions().add(column);
                templateKeys = new HashMap();
                rmv = new RuleModelVisitor(templateKeys);
                rmv.visit((Object)iPattern);
                ivs = new ArrayList(templateKeys.keySet());
                for (BRLVariableColumn variableColumn : variableColumns) {
                    ivsIts = ivs.iterator();
                    while (ivsIts.hasNext()) {
                        iv = (InterpolationVariable)ivsIts.next();
                        if (!iv.getVarName().equals(variableColumn.getVarName())) continue;
                        BRLConditionVariableColumn source2 = (BRLConditionVariableColumn)variableColumn;
                        varName = source2.getVarName();
                        dataType = iv.getDataType() == null ? "Object" : iv.getDataType();
                        BRLConditionVariableColumn target2 = new BRLConditionVariableColumn(varName, dataType);
                        target2.setHeader(source2.getHeader());
                        column.setHeader(source2.getHeader());
                        column.getChildColumns().add(target2);
                        ivsIts.remove();
                    }
                }
                if (column.getChildColumns().size() != 0) continue;
                source = this.findZeroParameterSourceConditionColumn(variableColumns);
                target = new BRLConditionVariableColumn("", "Boolean");
                target.setHeader(source.getHeader());
                column.setHeader(source.getHeader());
                column.getChildColumns().add(target);
            }
        }
        if (ruleModel.rhs != null) {
            for (IPattern iPattern : ruleModel.rhs) {
                column = new BRLActionColumn();
                column.getDefinition().add(iPattern);
                this.dtable.getActionCols().add(column);
                templateKeys = new HashMap();
                rmv = new RuleModelVisitor(templateKeys);
                rmv.visit((Object)iPattern);
                ivs = new ArrayList(templateKeys.keySet());
                for (BRLVariableColumn variableColumn : variableColumns) {
                    ivsIts = ivs.iterator();
                    while (ivsIts.hasNext()) {
                        iv = (InterpolationVariable)ivsIts.next();
                        if (!iv.getVarName().equals(variableColumn.getVarName())) continue;
                        BRLActionVariableColumn source2 = (BRLActionVariableColumn)variableColumn;
                        varName = source2.getVarName();
                        dataType = iv.getDataType() == null ? "Object" : iv.getDataType();
                        BRLActionVariableColumn target2 = new BRLActionVariableColumn(varName, dataType);
                        target2.setHeader(source2.getHeader());
                        column.setHeader(source2.getHeader());
                        column.getChildColumns().add(target2);
                        ivsIts.remove();
                    }
                }
                if (column.getChildColumns().size() != 0) continue;
                source = this.findZeroParameterSourceActionColumn(variableColumns);
                target = new BRLActionVariableColumn("", "Boolean");
                target.setHeader(source.getHeader());
                column.setHeader(source.getHeader());
                column.getChildColumns().add(target);
            }
        }
    }

    private BRLConditionVariableColumn findZeroParameterSourceConditionColumn(List<BRLVariableColumn> variableColumns) {
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!(variableColumn instanceof BRLConditionVariableColumn) || !variableColumn.getVarName().equals("")) continue;
            return (BRLConditionVariableColumn)variableColumn;
        }
        return null;
    }

    private BRLActionVariableColumn findZeroParameterSourceActionColumn(List<BRLVariableColumn> variableColumns) {
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!(variableColumn instanceof BRLActionVariableColumn) || !variableColumn.getVarName().equals("")) continue;
            return (BRLActionVariableColumn)variableColumn;
        }
        return null;
    }

    private void addIndirectSourceBuildersData(int maxRowCount) {
        ArrayList<ParameterizedValueBuilder> valueBuilders = new ArrayList<ParameterizedValueBuilder>();
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableSourceBuilderIndirect)) continue;
            GuidedDecisionTableSourceBuilderIndirect isb = (GuidedDecisionTableSourceBuilderIndirect)sb;
            TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(isb.getValueBuilders().keySet());
            for (Integer index : sortedIndexes) {
                ParameterizedValueBuilder vb = isb.getValueBuilders().get(index);
                this.assertFragmentData(vb, maxRowCount);
                valueBuilders.add(vb);
            }
        }
        List allColumns = this.dtable.getExpandedColumns();
        for (int iColIndex = 0; iColIndex < allColumns.size(); ++iColIndex) {
            BaseColumn column = (BaseColumn)allColumns.get(iColIndex);
            if (!(column instanceof BRLVariableColumn)) continue;
            String varName = ((BRLVariableColumn)column).getVarName();
            String varDataType = ((BRLVariableColumn)column).getFieldType();
            this.assertDecisionTableData(varName, varDataType, valueBuilders, maxRowCount);
        }
    }

    private List<List<DTCellValue52>> assertFragmentData(ParameterizedValueBuilder pvb, int maxRowCount) {
        List<List<DTCellValue52>> columnData = pvb.getColumnData();
        List<String> parameters = pvb.getParameters();
        if (columnData.size() < maxRowCount) {
            for (int iRow = columnData.size(); iRow < maxRowCount; ++iRow) {
                ArrayList<DTCellValue52> brlFragmentData = new ArrayList<DTCellValue52>();
                for (int iCol = 0; iCol < parameters.size(); ++iCol) {
                    brlFragmentData.add(new DTCellValue52());
                }
                columnData.add(brlFragmentData);
            }
        }
        return columnData;
    }

    private void assertDecisionTableData(String varName, String varDataType, List<ParameterizedValueBuilder> valueBuilders, int maxRowCount) {
        if (varName.equals("")) {
            for (ParameterizedValueBuilder pvb : valueBuilders) {
                if (!(pvb instanceof LiteralValueBuilder)) continue;
                for (int iRowIndex = 0; iRowIndex < maxRowCount; ++iRowIndex) {
                    List<DTCellValue52> fragmentRow = pvb.getColumnData().get(iRowIndex);
                    List dtableRow = (List)this.dtable.getData().get(iRowIndex);
                    DTCellValue52 fragmentCell = fragmentRow.get(0);
                    DTCellValueUtilities.assertDTCellValue(varDataType, fragmentCell);
                    dtableRow.add(fragmentCell);
                }
                break;
            }
        } else {
            for (ParameterizedValueBuilder pvb : valueBuilders) {
                int varNameIndex = pvb.getParameters().indexOf(varName);
                if (varNameIndex <= -1) continue;
                for (int iRowIndex = 0; iRowIndex < maxRowCount; ++iRowIndex) {
                    List<DTCellValue52> fragmentRow = pvb.getColumnData().get(iRowIndex);
                    List dtableRow = (List)this.dtable.getData().get(iRowIndex);
                    DTCellValue52 fragmentCell = fragmentRow.get(varNameIndex);
                    DTCellValueUtilities.assertDTCellValue(varDataType, fragmentCell);
                    dtableRow.add(fragmentCell);
                }
                break;
            }
        }
    }
}

