/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.ActionType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderDirect;

public abstract class AbstractGuidedDecisionTableAttributeBuilder
implements GuidedDecisionTableSourceBuilderDirect {
    protected final int headerRow;
    protected final int headerCol;
    protected final ActionType.Code actionType;
    protected final Map<Integer, String> definitions;
    protected final List<DTCellValue52> values;
    protected final ConversionResult conversionResult;

    public AbstractGuidedDecisionTableAttributeBuilder(int row, int column, ActionType.Code actionType, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.actionType = actionType;
        this.definitions = new HashMap<Integer, String>();
        this.values = new ArrayList<DTCellValue52>();
        this.conversionResult = conversionResult;
    }

    protected void addColumnData(GuidedDecisionTable52 dtable, DTColumnConfig52 column) {
        int rowCount = this.values.size();
        int iColIndex = dtable.getExpandedColumns().indexOf(column);
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.add(iColIndex, this.values.get(iRow));
        }
    }

    public ActionType.Code getActionTypeCode() {
        return this.actionType;
    }

    public void clearValues() {
        this.values.clear();
    }

    public boolean hasValues() {
        return this.values.size() > 0;
    }

    public void addTemplate(int row, int column, String content) {
        if (content == null || content.trim().equals("")) {
            return;
        }
        String message = "Internal error: ActionType '" + this.actionType.getColHeader() + "' does not need a code snippet.";
        this.conversionResult.addMessage(message, ConversionMessageType.ERROR);
    }

    public String getResult() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not return DRL.");
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }
}

