/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;

public class ParameterUtilities {
    private static final Pattern patternSingleParameter = Pattern.compile("\\$param");
    private static final Pattern patternIndexedParameter = Pattern.compile("\\$\\d+");
    private static final Pattern patternTemplateKey = Pattern.compile("@\\{.+?\\}");
    private static final Pattern patternUnwrapExistingQuotes = Pattern.compile("\"(@\\{.+?\\})\"");
    private static final String PARAMETER_PREFIX = "param";
    private int parameterCounter = 1;

    public String convertIndexedParametersToTemplateKeys(String xlsTemplate, ParameterizedValueBuilder.Part part) {
        StringBuffer result = new StringBuffer();
        Matcher matcherIndexedParameter = patternIndexedParameter.matcher(xlsTemplate);
        while (matcherIndexedParameter.find()) {
            matcherIndexedParameter.appendReplacement(result, "@{param" + this.parameterCounter++ + "}");
        }
        matcherIndexedParameter.appendTail(result);
        return this.assertTemplateKeyConversion(result, part);
    }

    public String convertSingleParameterToTemplateKey(String xlsTemplate, ParameterizedValueBuilder.Part part) {
        StringBuffer result = new StringBuffer();
        Matcher matcherSingleParameter = patternSingleParameter.matcher(xlsTemplate);
        while (matcherSingleParameter.find()) {
            matcherSingleParameter.appendReplacement(result, "@{param" + this.parameterCounter + "}");
        }
        ++this.parameterCounter;
        matcherSingleParameter.appendTail(result);
        return this.assertTemplateKeyConversion(result, part);
    }

    private String assertTemplateKeyConversion(StringBuffer result, ParameterizedValueBuilder.Part part) {
        String expression;
        ViabilityVisitor visitor;
        if (part == ParameterizedValueBuilder.Part.LHS && (visitor = new ViabilityVisitor(expression = this.addQuotesToTemplateKeys(result).toString())).isViable()) {
            return expression;
        }
        return result.toString();
    }

    public Set<String> extractTemplateKeys(String template) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Matcher matcherTemplateKey = patternTemplateKey.matcher(template);
        while (matcherTemplateKey.find()) {
            String fullKey = matcherTemplateKey.group();
            result.add(fullKey.substring(2, fullKey.length() - 1));
        }
        return result;
    }

    private StringBuffer addQuotesToTemplateKeys(StringBuffer source) {
        StringBuffer unwrapped = new StringBuffer();
        Matcher unwrappedMatcher = patternUnwrapExistingQuotes.matcher(source);
        while (unwrappedMatcher.find()) {
            unwrappedMatcher.appendReplacement(unwrapped, unwrappedMatcher.group(1));
        }
        unwrappedMatcher.appendTail(unwrapped);
        StringBuffer wrapped = new StringBuffer();
        Matcher wrappedMatcher = patternTemplateKey.matcher(unwrapped);
        while (wrappedMatcher.find()) {
            wrappedMatcher.appendReplacement(wrapped, "\"" + wrappedMatcher.group(0) + "\"");
        }
        wrappedMatcher.appendTail(wrapped);
        return wrapped;
    }

    private class ViabilityVisitor {
        private final String expression;

        ViabilityVisitor(String expression) {
            this.expression = expression;
        }

        private boolean isViable() {
            DrlExprParser parser = new DrlExprParser(DrlParser.DEFAULT_LANGUAGE_LEVEL);
            ConstraintConnectiveDescr result = parser.parse(this.expression);
            if (parser.hasErrors() || result == null) {
                return false;
            }
            try {
                for (BaseDescr descr : result.getDescrs()) {
                    this.visit(descr);
                }
            }
            catch (RuleModelDRLPersistenceImpl.RuleModelUnmarshallingException e) {
                return false;
            }
            return true;
        }

        private void visit(BaseDescr descr) {
            if (descr instanceof RelationalExprDescr) {
                this.visit(((RelationalExprDescr)descr).getLeft());
            } else if (descr instanceof AtomicExprDescr) {
                this.visit((AtomicExprDescr)descr);
            }
        }

        private void visit(AtomicExprDescr descr) {
            if (descr.getExpression().contains("@{")) {
                throw new RuleModelDRLPersistenceImpl.RuleModelUnmarshallingException();
            }
        }
    }
}

