/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.screens.dtablexls.backend.server.ExtendedDecisionTableXLSService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSContent;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DecisionTableXLSServiceImpl
extends KieService<DecisionTableXLSContent>
implements DecisionTableXLSService,
ExtendedDecisionTableXLSService {
    private static final Logger log = LoggerFactory.getLogger(DecisionTableXLSServiceImpl.class);
    private IOService ioService;
    private CopyService copyService;
    private DeleteService deleteService;
    private RenameService renameService;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private DecisionTableXLSConversionService conversionService;
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory;
    private AuthenticationService authenticationService;

    public DecisionTableXLSServiceImpl() {
    }

    @Inject
    public DecisionTableXLSServiceImpl(@Named(value="ioStrategy") IOService ioService, CopyService copyService, DeleteService deleteService, RenameService renameService, Event<ResourceOpenedEvent> resourceOpenedEvent, DecisionTableXLSConversionService conversionService, GenericValidator genericValidator, CommentedOptionFactory commentedOptionFactory, AuthenticationService authenticationService) {
        this.ioService = ioService;
        this.copyService = copyService;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.conversionService = conversionService;
        this.genericValidator = genericValidator;
        this.commentedOptionFactory = commentedOptionFactory;
        this.authenticationService = authenticationService;
    }

    public DecisionTableXLSContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (DecisionTableXLSContent)super.loadContent(path);
    }

    protected DecisionTableXLSContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        DecisionTableXLSContent content = new DecisionTableXLSContent();
        content.setOverview(overview);
        return content;
    }

    @Override
    public InputStream load(org.uberfire.backend.vfs.Path path, String sessionId) {
        try {
            InputStream inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[]{StandardOpenOption.READ});
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.getSessionInfo(sessionId)));
            return inputStream;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    @Override
    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment) {
        SessionInfo sessionInfo = this.getSessionInfo(sessionId);
        log.info("USER:" + sessionInfo.getIdentity().getIdentifier() + " CREATING asset [" + resource.getFileName() + "]");
        try {
            org.uberfire.backend.vfs.Path newPath;
            File tempFile = File.createTempFile("testxls", null);
            FileOutputStream tempFOS = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)content, (OutputStream)tempFOS);
            tempFOS.flush();
            tempFOS.close();
            this.validate(tempFile);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)resource);
            this.ioService.createFile(nioPath, new FileAttribute[0]);
            OutputStream outputStream = this.ioService.newOutputStream(nioPath, new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment, sessionInfo.getIdentity(), sessionInfo)});
            IOUtils.copy((InputStream)new FileInputStream(tempFile), (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            org.uberfire.backend.vfs.Path path = newPath = Paths.convert((Path)nioPath);
            return path;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
        }
    }

    void validate(File tempFile) {
        try {
            WorkbookFactory.create((InputStream)new FileInputStream(tempFile));
        }
        catch (InvalidFormatException e) {
            throw new DecisionTableParseException("DecisionTableParseException: An error occurred opening the workbook. It is possible that the encoding of the document did not match the encoding of the reader.", (Throwable)e);
        }
        catch (IOException e) {
            throw new DecisionTableParseException("DecisionTableParseException: Failed to open Excel stream, please check that the content is xls97 format.", (Throwable)e);
        }
        catch (Throwable e) {
            throw new DecisionTableParseException("DecisionTableParseException: " + e.getMessage(), e);
        }
    }

    @Override
    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, InputStream content, String sessionId, String comment) {
        SessionInfo sessionInfo = this.getSessionInfo(sessionId);
        log.info("USER:" + sessionInfo.getIdentity().getIdentifier() + " UPDATING asset [" + resource.getFileName() + "]");
        try {
            org.uberfire.backend.vfs.Path newPath;
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)resource);
            OutputStream outputStream = this.ioService.newOutputStream(nioPath, new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment, sessionInfo.getIdentity(), sessionInfo)});
            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            org.uberfire.backend.vfs.Path path = newPath = Paths.convert((Path)nioPath);
            return path;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
        }
    }

    public String getSource(org.uberfire.backend.vfs.Path path) {
        InputStream inputStream = null;
        try {
            String drl;
            SpreadsheetCompiler compiler = new SpreadsheetCompiler();
            inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[]{StandardOpenOption.READ});
            String string = drl = compiler.compile(inputStream, InputType.XLS);
            return string;
        }
        catch (Exception e) {
            throw new SourceGenerationFailedException(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ConversionResult convert(org.uberfire.backend.vfs.Path path) {
        try {
            return this.conversionService.convert(path);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, org.uberfire.backend.vfs.Path resource) {
        try {
            InputStream inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[]{StandardOpenOption.READ});
            String content = IOUtils.toString((InputStream)inputStream, (String)Charsets.UTF_8.name());
            return this.genericValidator.validate(path, content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private SessionInfo getSessionInfo(String sessionId) {
        return new SafeSessionInfo((SessionInfo)new SessionInfoImpl(sessionId, this.authenticationService.getUser()));
    }
}

