/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.apache.commons.io.IOUtils;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.workbench.screens.dtablexls.backend.server.DecisionTableXLSServiceImpl;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.util.CommentedOptionFactoryImpl;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@PrepareForTest(value={IOUtils.class})
@RunWith(value=PowerMockRunner.class)
public class DecisionTableXLSServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private CopyService copyService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Mock
    private DecisionTableXLSConversionService conversionService;
    @Mock
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory = new CommentedOptionFactoryImpl();
    @Mock
    private AuthenticationService authenticationService;
    @Mock
    private User user;
    @Mock
    private org.uberfire.backend.vfs.Path path;
    @Mock
    private InputStream inputstream;
    @Mock
    private OutputStream outputStream;
    @Captor
    private ArgumentCaptor<CommentedOption> commentedOptionArgumentCaptor;
    private final String sessionId = "123";
    private final String comment = "comment";
    private DecisionTableXLSServiceImpl service;

    @Before
    public void setup() throws IOException {
        Mockito.when((Object)this.authenticationService.getUser()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://p0/src/main/resources/dtable.xls");
        Mockito.when((Object)this.inputstream.read((byte[])Mockito.anyObject())).thenReturn((Object)-1);
        Mockito.when((Object)this.ioService.newOutputStream((Path)Mockito.any(Path.class), new OpenOption[]{(OpenOption)this.commentedOptionArgumentCaptor.capture()})).thenReturn((Object)this.outputStream);
    }

    @Test
    public void testSessionInfoOnCreate() {
        this.service = this.getServiceWithValidationOverride(tempFile -> {});
        this.service.create(this.path, this.inputstream, "123", "comment");
        this.assertCommentedOption();
    }

    @Test
    public void testSessionInfoOnSave() {
        this.service = this.getServiceWithValidationOverride(tempFile -> {});
        this.service.save(this.path, this.inputstream, "123", "comment");
        this.assertCommentedOption();
    }

    @Test
    public void inputStreamShouldNotBeReused() throws IOException {
        this.service = this.getServiceWithValidationOverride(tempFile -> {});
        PowerMockito.mockStatic(IOUtils.class, (Class[])new Class[0]);
        this.service.create(this.path, this.inputstream, "123", "comment");
        PowerMockito.verifyStatic((VerificationMode)Mockito.times((int)1));
        IOUtils.copy((InputStream)((InputStream)Mockito.eq((Object)this.inputstream)), (OutputStream)((OutputStream)Mockito.any(OutputStream.class)));
    }

    private void assertCommentedOption() {
        this.service = this.getServiceWithValidationOverride(tempFile -> {});
        CommentedOption commentedOption = (CommentedOption)this.commentedOptionArgumentCaptor.getValue();
        Assert.assertNotNull((Object)commentedOption);
        Assert.assertEquals((Object)"user", (Object)commentedOption.getName());
        Assert.assertEquals((Object)"123", (Object)commentedOption.getSessionId());
    }

    @Test
    public void testInvalidTableNotCreated() throws IOException {
        this.testInvalidTable(s -> s.create(this.path, this.inputstream, "123", "comment"));
    }

    @Test
    public void testInvalidTableNotSaved() throws IOException {
        this.testInvalidTable(s -> s.save(this.path, this.inputstream, "123", "comment"));
    }

    private void testInvalidTable(Consumer<DecisionTableXLSServiceImpl> serviceConsumer) throws IOException {
        this.service = this.getServiceWithValidationOverride(tempFile -> {
            Throwable t = new Throwable("testing invalid xls dt creation");
            throw new DecisionTableParseException("DecisionTableParseException: " + t.getMessage(), t);
        });
        PowerMockito.mockStatic(IOUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)IOUtils.copy((InputStream)((InputStream)Mockito.any(InputStream.class)), (OutputStream)((OutputStream)Mockito.any(OutputStream.class)))).thenReturn((Object)0);
        try {
            serviceConsumer.accept(this.service);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).newOutputStream((Path)Mockito.any(Path.class), new OpenOption[]{(OpenOption)Mockito.any(CommentedOption.class)});
        PowerMockito.verifyStatic((VerificationMode)Mockito.never());
    }

    @Test(expected=DecisionTableParseException.class)
    public void testValidateNonexistentFile() {
        this.service = this.getServiceWithValidationOverride(null);
        this.service.validate(new File(""));
    }

    @Test(expected=DecisionTableParseException.class)
    public void testValidateEmptyFile() throws IOException {
        this.service = this.getServiceWithValidationOverride(null);
        this.service.validate(File.createTempFile("emptyxls", null));
    }

    @Test(expected=DecisionTableParseException.class)
    public void testValidateFileWithInvalidContent() throws IOException {
        this.service = this.getServiceWithValidationOverride(null);
        File tempFile = File.createTempFile("emptyxls", null);
        try (FileOutputStream tempFOS = new FileOutputStream(tempFile);){
            IOUtils.write((String)"birdplane!", (OutputStream)tempFOS);
            tempFOS.flush();
            this.service.validate(tempFile);
        }
    }

    @Test
    public void testValidateFileWithValidContent() throws IOException, URISyntaxException {
        this.service = this.getServiceWithValidationOverride(null);
        File tempFile = new File(this.getClass().getResource("dummy.xls").toURI());
        this.service.validate(tempFile);
    }

    private DecisionTableXLSServiceImpl getServiceWithValidationOverride(final Consumer<File> validationOverride) {
        return new DecisionTableXLSServiceImpl(this.ioService, this.copyService, this.deleteService, this.renameService, this.resourceOpenedEvent, this.conversionService, this.genericValidator, this.commentedOptionFactory, this.authenticationService){

            void validate(File tempFile) {
                if (validationOverride != null) {
                    validationOverride.accept(tempFile);
                } else {
                    super.validate(tempFile);
                }
            }
        };
    }
}

