/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.dtablexls.backend.server.indexing.TestDecisionTableXLSFileIndexer;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeValueIndexTerm;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexDecisionTableXLSAttributeNameAndValueCompositionTest
extends BaseIndexingTest<DecisionTableXLSResourceTypeDefinition> {
    @Test
    public void testIndexDecisionTableXLSAttributeNameAndValueComposition() throws IOException, InterruptedException {
        Path path1 = this.loadXLSFile(this.basePath, "dtable3.xls");
        Thread.sleep(5000L);
        Index index = IndexDecisionTableXLSAttributeNameAndValueCompositionTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueRuleAttributeIndexTerm("ruleflow-group")).addTerm((ValueIndexTerm)new ValueRuleAttributeValueIndexTerm("myRuleFlowGroup")).build();
        this.searchFor(index, query, 1, new Path[]{path1});
        query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueRuleAttributeIndexTerm("ruleflow-group")).addTerm((ValueIndexTerm)new ValueRuleAttributeValueIndexTerm("myAgendaGroup")).build();
        this.searchFor(index, query, 0, new Path[0]);
    }

    protected TestIndexer getIndexer() {
        return new TestDecisionTableXLSFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleAttribute", new RuleAttributeNameAnalyzer());
            }
        };
    }

    protected DecisionTableXLSResourceTypeDefinition getResourceTypeDefinition() {
        return new DecisionTableXLSResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private Path loadXLSFile(Path basePath, String fileName) throws IOException {
        Path path = basePath.resolve(fileName);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        OutputStream os = this.ioService().newOutputStream(path, new OpenOption[0]);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        os.close();
        return path;
    }
}

