/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.DTCellValueUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableLHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableRHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderDirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderIndirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.LiteralValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;

public class GuidedDecisionTablePopulater {
    private static final String UNDEFINED = "(undefined)";
    private final GuidedDecisionTable52 dtable;
    private final List<GuidedDecisionTableSourceBuilder> sourceBuilders;
    private final ConversionResult conversionResult;
    private final PackageDataModelOracle dmo;
    private final int ruleRowStartIndex;
    private final int ruleColumnStartIndex;

    public GuidedDecisionTablePopulater(GuidedDecisionTable52 dtable, List<GuidedDecisionTableSourceBuilder> sourceBuilders, ConversionResult conversionResult, PackageDataModelOracle dmo, int ruleRowStartIndex, int ruleColumnStartIndex) {
        this.dtable = dtable;
        this.sourceBuilders = sourceBuilders;
        this.conversionResult = conversionResult;
        this.dmo = dmo;
        this.ruleRowStartIndex = ruleRowStartIndex;
        this.ruleColumnStartIndex = ruleColumnStartIndex;
    }

    public void populate() {
        int maxRowCount = this.getMaxRowCount();
        this.processDirectSourceBuilders(maxRowCount);
        this.processIndirectSourceBuilders(maxRowCount);
    }

    private int getMaxRowCount() {
        int maxRowCount = 0;
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            maxRowCount = Math.max(maxRowCount, sb.getRowCount());
        }
        return maxRowCount;
    }

    private void processDirectSourceBuilders(int maxRowCount) {
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableSourceBuilderDirect)) continue;
            ((GuidedDecisionTableSourceBuilderDirect)sb).populateDecisionTable(this.dtable, maxRowCount);
        }
    }

    private void processIndirectSourceBuilders(int maxRowCount) {
        this.addIndirectSourceBuildersColumns();
        this.addIndirectSourceBuildersData(maxRowCount);
    }

    private void addIndirectSourceBuildersColumns() {
        BRLConditionVariableColumn target;
        BRLConditionVariableColumn source;
        InterpolationVariable iv;
        Iterator ivsIts;
        ArrayList ivs;
        RuleModelVisitor rmv;
        HashMap templateKeys;
        BRLConditionColumn column;
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        for (GuidedDecisionTableSourceBuilder guidedDecisionTableSourceBuilder : this.sourceBuilders) {
            if (!(guidedDecisionTableSourceBuilder instanceof GuidedDecisionTableSourceBuilderIndirect)) continue;
            for (BRLVariableColumn variableColumn : ((GuidedDecisionTableSourceBuilderIndirect)guidedDecisionTableSourceBuilder).getVariableColumns()) {
                variableColumns.add(variableColumn);
            }
        }
        StringBuilder rule = new StringBuilder();
        if (this.dmo.getPackageName() != null && !this.dmo.getPackageName().isEmpty()) {
            rule.append("package ").append(this.dmo.getPackageName()).append("\n");
        }
        rule.append("rule 'temp' \n").append("when \n");
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableLHSBuilder)) continue;
            rule.append(sb.getResult());
        }
        rule.append("\nthen \n");
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableRHSBuilder)) continue;
            rule.append(sb.getResult());
        }
        rule.append("end");
        RuleModel ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshal(rule.toString(), Collections.emptyList(), this.dmo);
        if (ruleModel.lhs != null) {
            for (IPattern iPattern : ruleModel.lhs) {
                column = new BRLConditionColumn();
                column.getDefinition().add(iPattern);
                this.dtable.getConditions().add(column);
                templateKeys = new HashMap();
                rmv = new RuleModelVisitor(templateKeys);
                rmv.visit((Object)iPattern);
                ivs = new ArrayList(templateKeys.keySet());
                for (BRLVariableColumn variableColumn : variableColumns) {
                    ivsIts = ivs.iterator();
                    while (ivsIts.hasNext()) {
                        iv = (InterpolationVariable)ivsIts.next();
                        if (!iv.getVarName().equals(variableColumn.getVarName())) continue;
                        source = (BRLConditionVariableColumn)variableColumn;
                        target = this.makeBRLConditionVariableColumn(source, iv);
                        column.getChildColumns().add(target);
                        ivsIts.remove();
                    }
                }
                if (column.getChildColumns().isEmpty()) {
                    this.setZeroParameterConditionColumnHeader(column, variableColumns);
                    continue;
                }
                this.setCompositeColumnHeader(column);
            }
        }
        if (ruleModel.rhs != null) {
            for (IPattern iPattern : ruleModel.rhs) {
                column = new BRLActionColumn();
                column.getDefinition().add(iPattern);
                this.dtable.getActionCols().add(column);
                templateKeys = new HashMap();
                rmv = new RuleModelVisitor(ruleModel.lhs, templateKeys);
                rmv.visit((Object)iPattern);
                ivs = new ArrayList(templateKeys.keySet());
                for (BRLVariableColumn variableColumn : variableColumns) {
                    ivsIts = ivs.iterator();
                    while (ivsIts.hasNext()) {
                        iv = (InterpolationVariable)ivsIts.next();
                        if (!iv.getVarName().equals(variableColumn.getVarName())) continue;
                        source = (BRLActionVariableColumn)variableColumn;
                        target = this.makeBRLActionVariableColumn((BRLActionVariableColumn)source, iv);
                        column.getChildColumns().add(target);
                        ivsIts.remove();
                    }
                }
                if (column.getChildColumns().isEmpty()) {
                    this.setZeroParameterActionColumnHeader((BRLActionColumn)column, variableColumns);
                    continue;
                }
                this.setCompositeColumnHeader((BRLActionColumn)column);
            }
        }
    }

    private BRLConditionVariableColumn makeBRLConditionVariableColumn(BRLConditionVariableColumn source, InterpolationVariable iv) {
        String varName = source.getVarName();
        String dataType = iv.getDataType() == null ? "Object" : iv.getDataType();
        String factType = iv.getFactType();
        String factField = iv.getFactField();
        BRLConditionVariableColumn target = factType != null && factField != null ? new BRLConditionVariableColumn(varName, dataType, factType, factField) : new BRLConditionVariableColumn(varName, dataType);
        target.setHeader(source.getHeader());
        return target;
    }

    private void setZeroParameterConditionColumnHeader(BRLConditionColumn column, List<BRLVariableColumn> allVariableColumns) {
        BRLConditionVariableColumn source = this.findZeroParameterSourceConditionColumn(allVariableColumns);
        BRLConditionVariableColumn target = new BRLConditionVariableColumn("", "Boolean");
        column.getChildColumns().add(target);
        this.setZeroParameterColumnHeader((BRLColumn)column, (BaseColumn)source, (BaseColumn)target);
    }

    private BRLConditionVariableColumn findZeroParameterSourceConditionColumn(List<BRLVariableColumn> variableColumns) {
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!(variableColumn instanceof BRLConditionVariableColumn) || !variableColumn.getVarName().equals("")) continue;
            return (BRLConditionVariableColumn)variableColumn;
        }
        return null;
    }

    private void setCompositeColumnHeader(BRLConditionColumn column) {
        BRLConditionVariableColumn variableColumn;
        int i;
        List columnVariableColumns = column.getChildColumns();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> variableColumnHeaders = new ArrayList<String>();
        sb.append("Converted from [");
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLConditionVariableColumn)columnVariableColumns.get(i);
            String header = variableColumn.getHeader();
            variableColumnHeaders.add(header);
            sb.append("'").append(header).append("'");
            sb.append(i < columnVariableColumns.size() - 1 ? ", " : "");
        }
        sb.append("]");
        column.setHeader(sb.toString());
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLConditionVariableColumn)columnVariableColumns.get(i);
            variableColumn.setHeader((String)variableColumnHeaders.get(i));
        }
    }

    private BRLActionVariableColumn makeBRLActionVariableColumn(BRLActionVariableColumn source, InterpolationVariable iv) {
        String varName = source.getVarName();
        String dataType = iv.getDataType() == null ? "Object" : iv.getDataType();
        String factType = iv.getFactType();
        String factField = iv.getFactField();
        BRLActionVariableColumn target = factType != null && factField != null ? new BRLActionVariableColumn(varName, dataType, factType, factField) : new BRLActionVariableColumn(varName, dataType);
        target.setHeader(source.getHeader());
        return target;
    }

    private void setZeroParameterActionColumnHeader(BRLActionColumn column, List<BRLVariableColumn> allVariableColumns) {
        BRLActionVariableColumn source = this.findZeroParameterSourceActionColumn(allVariableColumns);
        BRLActionVariableColumn target = new BRLActionVariableColumn("", "Boolean");
        column.getChildColumns().add(target);
        this.setZeroParameterColumnHeader((BRLColumn)column, (BaseColumn)source, (BaseColumn)target);
    }

    private void setCompositeColumnHeader(BRLActionColumn column) {
        BRLActionVariableColumn variableColumn;
        int i;
        List columnVariableColumns = column.getChildColumns();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> variableColumnHeaders = new ArrayList<String>();
        sb.append("Converted from [");
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLActionVariableColumn)columnVariableColumns.get(i);
            String header = variableColumn.getHeader();
            variableColumnHeaders.add(header);
            sb.append("'").append(header).append("'");
            sb.append(i < columnVariableColumns.size() - 1 ? ", " : "");
        }
        sb.append("]");
        column.setHeader(sb.toString());
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLActionVariableColumn)columnVariableColumns.get(i);
            variableColumn.setHeader((String)variableColumnHeaders.get(i));
        }
    }

    private BRLActionVariableColumn findZeroParameterSourceActionColumn(List<BRLVariableColumn> variableColumns) {
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!(variableColumn instanceof BRLActionVariableColumn) || !variableColumn.getVarName().equals("")) continue;
            return (BRLActionVariableColumn)variableColumn;
        }
        return null;
    }

    private void setZeroParameterColumnHeader(BRLColumn column, BaseColumn source, BaseColumn target) {
        StringBuilder sb = new StringBuilder();
        String header = source == null ? UNDEFINED : source.getHeader();
        sb.append(source == null ? "" : "Converted from ['");
        sb.append(header);
        sb.append(source == null ? "" : "']");
        column.setHeader(sb.toString());
        target.setHeader(header);
    }

    private void addIndirectSourceBuildersData(int maxRowCount) {
        ArrayList<ParameterizedValueBuilder> valueBuilders = new ArrayList<ParameterizedValueBuilder>();
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableSourceBuilderIndirect)) continue;
            GuidedDecisionTableSourceBuilderIndirect isb = (GuidedDecisionTableSourceBuilderIndirect)sb;
            TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(isb.getValueBuilders().keySet());
            for (Integer index : sortedIndexes) {
                ParameterizedValueBuilder vb = isb.getValueBuilders().get(index);
                this.assertFragmentData(vb, maxRowCount);
                valueBuilders.add(vb);
            }
        }
        List allColumns = this.dtable.getExpandedColumns();
        for (int iColIndex = 0; iColIndex < allColumns.size(); ++iColIndex) {
            BaseColumn column = (BaseColumn)allColumns.get(iColIndex);
            if (!(column instanceof BRLVariableColumn)) continue;
            String varName = ((BRLVariableColumn)column).getVarName();
            String varDataType = ((BRLVariableColumn)column).getFieldType();
            this.assertDecisionTableData(varName, varDataType, valueBuilders, maxRowCount);
        }
    }

    private List<List<DTCellValue52>> assertFragmentData(ParameterizedValueBuilder pvb, int maxRowCount) {
        List<List<DTCellValue52>> columnData = pvb.getColumnData();
        List<String> parameters = pvb.getParameters();
        if (columnData.size() < maxRowCount) {
            for (int iRow = columnData.size(); iRow < maxRowCount; ++iRow) {
                ArrayList<DTCellValue52> brlFragmentData = new ArrayList<DTCellValue52>();
                for (int iCol = 0; iCol < parameters.size(); ++iCol) {
                    brlFragmentData.add(new DTCellValue52());
                }
                columnData.add(brlFragmentData);
            }
        }
        return columnData;
    }

    private void assertDecisionTableData(String varName, String varDataType, List<ParameterizedValueBuilder> valueBuilders, int maxRowCount) {
        if (varName.equals("")) {
            for (ParameterizedValueBuilder pvb : valueBuilders) {
                if (!(pvb instanceof LiteralValueBuilder)) continue;
                for (int iRowIndex = 0; iRowIndex < maxRowCount; ++iRowIndex) {
                    int _rowIndex = this.ruleRowStartIndex + iRowIndex;
                    int _columnIndex = this.ruleColumnStartIndex + valueBuilders.indexOf(pvb) + 1;
                    List<DTCellValue52> fragmentRow = pvb.getColumnData().get(iRowIndex);
                    List dtableRow = (List)this.dtable.getData().get(iRowIndex);
                    DTCellValue52 fragmentCell = fragmentRow.get(0);
                    DTCellValueUtilities.assertDTCellValue(varDataType, fragmentCell, (value, dataType) -> this.addConversionMessage(value, dataType, _rowIndex, _columnIndex));
                    dtableRow.add(fragmentCell);
                }
                break;
            }
        } else {
            for (ParameterizedValueBuilder pvb : valueBuilders) {
                int varNameIndex = pvb.getParameters().indexOf(varName);
                if (varNameIndex <= -1) continue;
                for (int iRowIndex = 0; iRowIndex < maxRowCount; ++iRowIndex) {
                    int _rowIndex = this.ruleRowStartIndex + iRowIndex;
                    int _columnIndex = this.ruleColumnStartIndex + valueBuilders.indexOf(pvb) + 1;
                    List<DTCellValue52> fragmentRow = pvb.getColumnData().get(iRowIndex);
                    List dtableRow = (List)this.dtable.getData().get(iRowIndex);
                    DTCellValue52 fragmentCell = fragmentRow.get(varNameIndex);
                    DTCellValueUtilities.assertDTCellValue(varDataType, fragmentCell, (value, dataType) -> this.addConversionMessage(value, dataType, _rowIndex, _columnIndex));
                    dtableRow.add(fragmentCell);
                }
                break;
            }
        }
    }

    private void addConversionMessage(String value, DataType.DataTypes dataType, int rowIndex, int columnIndex) {
        this.conversionResult.addMessage("Unable to convert value '" + value + "' to " + dataType + ". Cell (" + this.toColumnName(columnIndex) + rowIndex + ")", ConversionMessageType.WARNING);
    }

    private String toColumnName(int columnIndex) {
        StringBuilder sb = new StringBuilder();
        while (columnIndex-- > 0) {
            sb.append((char)(65 + columnIndex % 26));
            columnIndex /= 26;
        }
        return sb.reverse().toString();
    }
}

