/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.drools.workbench.screens.drltext.type.DRLResourceTypeDefinition;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.DecisionTableXLSToDecisionTableGuidedConverter;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSXResourceTypeDefinition;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.drools.workbench.screens.globals.type.GlobalResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTableXLSToDecisionTableGuidedConverterTest {
    @Mock
    private IOService ioService;
    @Mock
    private DRLTextEditorService drlService;
    @Mock
    private GuidedDecisionTableEditorService guidedDecisionTableService;
    @Mock
    private GlobalsEditorService globalsService;
    @Mock
    private KieProjectService projectService;
    @Mock
    private ProjectImportsService importsService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private DataModelerService modellerService;
    @Mock
    private DataModelService dataModelService;
    @Mock
    private AppConfigService appConfigService;
    @Mock
    private org.uberfire.backend.vfs.Path path;
    @Mock
    private PackageDataModelOracle dmo;
    private Map<String, ModelField[]> packageModelFields = new HashMap<String, ModelField[]>();
    @Mock
    private KieProject project;
    @Mock
    private org.uberfire.backend.vfs.Path expectedProjectImportsPath;
    private DecisionTableXLSResourceTypeDefinition xlsDTableType = new DecisionTableXLSResourceTypeDefinition();
    private DecisionTableXLSXResourceTypeDefinition xlsxDTableType = new DecisionTableXLSXResourceTypeDefinition();
    private GuidedDTableResourceTypeDefinition guidedDTableType = new GuidedDTableResourceTypeDefinition();
    private DRLResourceTypeDefinition drlType = new DRLResourceTypeDefinition();
    private GlobalResourceTypeDefinition globalsType = new GlobalResourceTypeDefinition();
    private DecisionTableXLSToDecisionTableGuidedConverter converter;

    @BeforeClass
    public static void setup() {
        DecisionTableXLSToDecisionTableGuidedConverterTest.setupPreferences();
        DecisionTableXLSToDecisionTableGuidedConverterTest.setupSystemProperties();
    }

    private static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
    }

    private static void setupSystemProperties() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
        System.setProperty("org.uberfire.sys.repo.monitor.disabled", "true");
    }

    @Before
    public void setupMocks() {
        this.converter = new DecisionTableXLSToDecisionTableGuidedConverter(this.ioService, this.drlService, this.guidedDecisionTableService, this.globalsService, this.projectService, this.importsService, this.metadataService, this.modellerService, this.dataModelService, this.appConfigService, this.xlsDTableType, this.xlsxDTableType, this.guidedDTableType, this.drlType, this.globalsType);
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://project0/src/main/resources/p0/source.xls");
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"source.xls");
        Mockito.when((Object)this.dataModelService.getDataModel((org.uberfire.backend.vfs.Path)Matchers.eq((Object)this.path))).thenReturn((Object)this.dmo);
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        Mockito.when((Object)this.dmo.getProjectModelFields()).thenReturn(this.packageModelFields);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.project);
        Mockito.when((Object)this.project.getImportsPath()).thenReturn((Object)this.expectedProjectImportsPath);
        Mockito.when((Object)this.expectedProjectImportsPath.toURI()).thenReturn((Object)"default://project0/project.imports");
    }

    @Test
    public void testGlobalGeneration() {
        InputStream is = this.getClass().getResourceAsStream("BZ1310208.xls");
        Mockito.when((Object)this.ioService.newInputStream((Path)Mockito.any(Path.class), new OpenOption[0])).thenReturn((Object)is);
        ConversionResult result = this.converter.convert(this.path);
        Assert.assertNotNull((Object)result);
        ArgumentCaptor globalsModelArgumentCaptor = ArgumentCaptor.forClass(GlobalsModel.class);
        ((GlobalsEditorService)Mockito.verify((Object)this.globalsService, (VerificationMode)Mockito.times((int)1))).create((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (String)Mockito.any(String.class), globalsModelArgumentCaptor.capture(), (String)Mockito.any(String.class));
        Assert.assertNotNull((Object)globalsModelArgumentCaptor.getValue());
        GlobalsModel globalsModel = (GlobalsModel)globalsModelArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)globalsModel.getGlobals().size());
        Assert.assertEquals((Object)"list", (Object)((Global)globalsModel.getGlobals().get(0)).getAlias());
        Assert.assertEquals((Object)"java.util.List", (Object)((Global)globalsModel.getGlobals().get(0)).getClassName());
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.guidedDecisionTableService, (VerificationMode)Mockito.times((int)1))).create((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (String)Mockito.any(String.class), Mockito.any(GuidedDecisionTable52.class), (String)Mockito.any(String.class));
        ((DRLTextEditorService)Mockito.verify((Object)this.drlService, (VerificationMode)Mockito.never())).create((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (String)Mockito.any(String.class), Mockito.any(String.class), (String)Mockito.any(String.class));
    }

    @Test
    public void testImportGeneration() {
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2478.xls");
        Mockito.when((Object)this.ioService.newInputStream((Path)Mockito.any(Path.class), new OpenOption[0])).thenReturn((Object)is);
        ConversionResult result = this.converter.convert(this.path);
        Assert.assertNotNull((Object)result);
        ArgumentCaptor projectImportsPathArgumentCaptor = ArgumentCaptor.forClass(org.uberfire.backend.vfs.Path.class);
        ArgumentCaptor projectImportsArgumentCaptor = ArgumentCaptor.forClass(ProjectImports.class);
        ((ProjectImportsService)Mockito.verify((Object)this.importsService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)projectImportsPathArgumentCaptor.capture(), projectImportsArgumentCaptor.capture(), (Metadata)Mockito.any(Metadata.class), (String)Mockito.any(String.class));
        Assert.assertNotNull((Object)projectImportsPathArgumentCaptor.getValue());
        org.uberfire.backend.vfs.Path actualProjectImportsPath = (org.uberfire.backend.vfs.Path)projectImportsPathArgumentCaptor.getValue();
        Assert.assertEquals((Object)this.expectedProjectImportsPath.toURI(), (Object)actualProjectImportsPath.toURI());
        Assert.assertNotNull((Object)projectImportsArgumentCaptor.getValue());
        ProjectImports projectImports = (ProjectImports)projectImportsArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)projectImports.getImports().getImports().size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Import)projectImports.getImports().getImports().get(0)).getType());
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.guidedDecisionTableService, (VerificationMode)Mockito.times((int)1))).create((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (String)Mockito.any(String.class), Mockito.any(GuidedDecisionTable52.class), (String)Mockito.any(String.class));
    }

    @Test
    public void checkConversionOfXLSXFiles() {
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2696.xlsx");
        Mockito.when((Object)this.ioService.newInputStream((Path)Mockito.any(Path.class), new OpenOption[0])).thenReturn((Object)is);
        ConversionResult result = this.converter.convert(this.path);
        Assert.assertNotNull((Object)result);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.guidedDecisionTableService, (VerificationMode)Mockito.times((int)1))).create((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class), (String)Mockito.any(String.class), Mockito.any(GuidedDecisionTable52.class), (String)Mockito.any(String.class));
    }
}

