/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.GuidedDecisionTablePopulater;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.DefaultDescriptionBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableActivationGroupBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableAgendaGroupBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableAutoFocusBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableCalendarsBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableDateEffectiveBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableDateExpiresBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableDescriptionBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableDurationBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableLHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableLockonActiveBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableMetadataBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableNameBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableNoLoopBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableRHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableRuleflowGroupBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSalienceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderDirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderIndirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableTimerBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.HasColumnHeadings;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.RowNumberBuilder;

public class GuidedDecisionTableGeneratorListener
implements RuleSheetListener {
    private static final int ACTION_ROW = 1;
    private static final int OBJECT_TYPE_ROW = 2;
    private static final int CODE_ROW = 3;
    private static final int LABEL_ROW = 4;
    private static final int ROW_NUMBER_COLUMN_INDEX = 0;
    private static final int DESCRIPTION_COLUMN_INDEX = 1;
    private static GuidedDecisionTableSourceBuilder ROW_NUMBER_BUILDER = new RowNumberBuilder();
    private static GuidedDecisionTableSourceBuilder DEFAULT_DESCRIPTION_BUILDER = new DefaultDescriptionBuilder();
    private boolean _isInRuleTable = false;
    private int _ruleRow;
    private int _ruleStartColumn;
    private int _ruleEndColumn;
    private int _ruleStartRow;
    private boolean _currentSequentialFlag = false;
    private boolean _currentEscapeQuotesFlag = true;
    private GuidedDecisionTable52 _dtable;
    private boolean _isNewDataRow = false;
    private Map<Integer, ActionType> _actions;
    private final List<GuidedDecisionTable52> _dtables = new ArrayList<GuidedDecisionTable52>();
    private List<GuidedDecisionTableSourceBuilder> _sourceBuilders;
    private final PropertiesSheetListener _propertiesListener = new PropertiesSheetListener();
    private ConversionResult _conversionResult;
    private PackageDataModelOracle _dmo;
    private ParameterUtilities _parameterUtilities;

    public GuidedDecisionTableGeneratorListener(ConversionResult conversionResult, PackageDataModelOracle _dmo) {
        this._conversionResult = conversionResult;
        this._dmo = _dmo;
    }

    public PropertiesSheetListener.CaseInsensitiveMap getProperties() {
        return this._propertiesListener.getProperties();
    }

    public Package getRuleSet() {
        throw new UnsupportedOperationException("Use getGuidedDecisionTables() instead.");
    }

    public List<Import> getImports() {
        return RuleSheetParserUtil.getImportList((List)this.getProperties().getProperty("Import"));
    }

    public List<Global> getGlobals() {
        return RuleSheetParserUtil.getVariableList((List)this.getProperties().getProperty("Variables"));
    }

    public List<String> getFunctions() {
        return this.getProperties().getProperty("Functions");
    }

    public List<String> getQueries() {
        return this.getProperties().getProperty("Queries");
    }

    public List<String> getTypeDeclarations() {
        return this.getProperties().getProperty("Declare");
    }

    public List<GuidedDecisionTable52> getGuidedDecisionTables() {
        return this._dtables;
    }

    public void startSheet(String name) {
    }

    public void finishSheet() {
        this._propertiesListener.finishSheet();
        this.finishRuleTable();
    }

    public void newRow(int rowNumber, int columns) {
        if (rowNumber > this._ruleStartRow + 4) {
            this._isNewDataRow = true;
        }
    }

    public void newCell(int row, int column, String value, int mergedColStart) {
        if (this.isCellValueEmpty(value) && column > this._ruleEndColumn) {
            return;
        }
        if (this._isInRuleTable && row == this._ruleStartRow) {
            return;
        }
        if (this._isInRuleTable) {
            this.processRuleCell(row, column, value, mergedColStart);
        } else {
            this.processNonRuleCell(row, column, value);
        }
    }

    private void initRuleTable(int row, int column, String value) {
        this.preInitRuleTable(row, column, value);
        this._isInRuleTable = true;
        this._actions = new HashMap<Integer, ActionType>();
        this._ruleStartColumn = column;
        this._ruleEndColumn = column;
        this._ruleStartRow = row;
        this._ruleRow = row + 4 + 1;
        this._isNewDataRow = false;
        this._currentSequentialFlag = this.getSequentialFlag();
        this._currentEscapeQuotesFlag = this.getEscapeQuotesFlag();
        this._parameterUtilities = new ParameterUtilities();
        this._dtable = new GuidedDecisionTable52();
        this._dtable.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this._dtable.setTableName(RuleSheetParserUtil.getRuleName((String)value));
        this._dtable.setPackageName(this._dmo.getPackageName());
        this._sourceBuilders = new ArrayList<GuidedDecisionTableSourceBuilder>();
        ROW_NUMBER_BUILDER.clearValues();
        DEFAULT_DESCRIPTION_BUILDER.clearValues();
        this._sourceBuilders.add(0, ROW_NUMBER_BUILDER);
        this._sourceBuilders.add(1, DEFAULT_DESCRIPTION_BUILDER);
        this.postInitRuleTable(row, column, value);
    }

    private void finishRuleTable() {
        if (this._isInRuleTable) {
            this.populateDecisionTable();
            this._dtables.add(this._dtable);
            this._currentSequentialFlag = false;
            this._isInRuleTable = false;
            this._isNewDataRow = false;
        }
    }

    private void populateDecisionTable() {
        GuidedDecisionTablePopulater populator = new GuidedDecisionTablePopulater(this._dtable, this._sourceBuilders, this._conversionResult, this._dmo, this._ruleRow, this._ruleStartColumn);
        populator.populate();
    }

    protected void preInitRuleTable(int row, int column, String value) {
    }

    protected void postInitRuleTable(int row, int column, String value) {
    }

    private boolean getSequentialFlag() {
        String seqFlag = this.getProperties().getSingleProperty("Sequential", "false");
        return RuleSheetParserUtil.isStringMeaningTrue((String)seqFlag);
    }

    private boolean getEscapeQuotesFlag() {
        String escFlag = this.getProperties().getSingleProperty("EscapeQuotes", "true");
        return RuleSheetParserUtil.isStringMeaningTrue((String)escFlag);
    }

    private void processNonRuleCell(int row, int column, String value) {
        String testVal = value.trim().toLowerCase();
        if (testVal.startsWith("ruletable")) {
            this.initRuleTable(row, column, value.trim());
        } else {
            this._propertiesListener.newCell(row, column, value, -1);
        }
    }

    private void processRuleCell(int row, int column, String value, int mergedColStart) {
        String trimVal = value.trim();
        String testVal = trimVal.toLowerCase();
        if (testVal.startsWith("ruletable")) {
            this.finishRuleTable();
            this.initRuleTable(row, column, trimVal);
            return;
        }
        if (column < this._ruleStartColumn) {
            if (row - this._ruleStartRow > 4 && column + 1 == this._ruleStartColumn && row - this._ruleRow < 2) {
                DEFAULT_DESCRIPTION_BUILDER.addCellValue(row, 1, trimVal);
            }
            return;
        }
        if (row == this._ruleStartRow) {
            return;
        }
        switch (row - this._ruleStartRow) {
            case 1: {
                this.doActionTypeCell(row, column, trimVal);
                break;
            }
            case 2: {
                this.doObjectTypeCell(row, column, trimVal, mergedColStart);
                break;
            }
            case 3: {
                this.doCodeCell(row, column, trimVal);
                break;
            }
            case 4: {
                this.doLabelCell(row, column, trimVal);
                break;
            }
            default: {
                if (this._isNewDataRow) {
                    this._isNewDataRow = false;
                    ROW_NUMBER_BUILDER.addCellValue(row, 0, "");
                }
                this.doDataCell(row, column, trimVal);
            }
        }
    }

    private void doActionTypeCell(int row, int column, String trimVal) {
        this._ruleEndColumn = column;
        ActionType.addNewActionType(this._actions, (String)trimVal, (int)column, (int)row);
        ActionType actionType = this.getActionForColumn(row, column);
        GuidedDecisionTableSourceBuilderDirect sb = null;
        switch (actionType.getCode()) {
            case CONDITION: 
            case ACTION: {
                break;
            }
            case NAME: {
                sb = new GuidedDecisionTableNameBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case DESCRIPTION: {
                this._sourceBuilders.remove(DEFAULT_DESCRIPTION_BUILDER);
                sb = new GuidedDecisionTableDescriptionBuilder(row - 1, column, this._conversionResult);
                this._sourceBuilders.add(1, sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
                break;
            }
            case SALIENCE: {
                sb = new GuidedDecisionTableSalienceBuilder(row - 1, column, this._currentSequentialFlag, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case DURATION: {
                sb = new GuidedDecisionTableDurationBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case TIMER: {
                sb = new GuidedDecisionTableTimerBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case CALENDARS: {
                sb = new GuidedDecisionTableCalendarsBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case NOLOOP: {
                sb = new GuidedDecisionTableNoLoopBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case LOCKONACTIVE: {
                sb = new GuidedDecisionTableLockonActiveBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case AUTOFOCUS: {
                sb = new GuidedDecisionTableAutoFocusBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case ACTIVATIONGROUP: {
                sb = new GuidedDecisionTableActivationGroupBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case AGENDAGROUP: {
                sb = new GuidedDecisionTableAgendaGroupBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case RULEFLOWGROUP: {
                sb = new GuidedDecisionTableRuleflowGroupBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case DATEEFFECTIVE: {
                sb = new GuidedDecisionTableDateEffectiveBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case DATEEXPIRES: {
                sb = new GuidedDecisionTableDateExpiresBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
                break;
            }
            case METADATA: {
                sb = new GuidedDecisionTableMetadataBuilder(row - 1, column, this._conversionResult);
                actionType.setSourceBuilder((SourceBuilder)sb);
                this._sourceBuilders.add(sb);
            }
        }
    }

    private void doObjectTypeCell(int row, int column, String value, int mergedColStart) {
        if (value.indexOf("$param") > -1 || value.indexOf("$1") > -1) {
            String message = "It looks like you have snippets in the row that is meant for object declarations. Please insert an additional row before the snippets, at cell " + RuleSheetParserUtil.rc2name((int)row, (int)column);
            this._conversionResult.addMessage(message, ConversionMessageType.ERROR);
        }
        ActionType actionType = this.getActionForColumn(row, column);
        if (mergedColStart == -1) {
            if (actionType.getCode() == ActionType.Code.CONDITION) {
                GuidedDecisionTableLHSBuilder sb = new GuidedDecisionTableLHSBuilder(row - 1, column, value, this._parameterUtilities, this._conversionResult);
                this._sourceBuilders.add(sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
            } else if (actionType.getCode() == ActionType.Code.ACTION) {
                GuidedDecisionTableRHSBuilder sb = new GuidedDecisionTableRHSBuilder(row - 1, column, value, this._sourceBuilders, this._parameterUtilities, this._conversionResult);
                this._sourceBuilders.add(sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
            }
        } else if (column == mergedColStart) {
            if (actionType.getCode() == ActionType.Code.CONDITION) {
                GuidedDecisionTableLHSBuilder sb = new GuidedDecisionTableLHSBuilder(row - 1, column, value, this._parameterUtilities, this._conversionResult);
                this._sourceBuilders.add(sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
            } else if (actionType.getCode() == ActionType.Code.ACTION) {
                GuidedDecisionTableRHSBuilder sb = new GuidedDecisionTableRHSBuilder(row - 1, column, value, this._sourceBuilders, this._parameterUtilities, this._conversionResult);
                this._sourceBuilders.add(sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
            }
        } else {
            ActionType startOfMergeAction = this.getActionForColumn(row, mergedColStart);
            actionType.setSourceBuilder(startOfMergeAction.getSourceBuilder());
        }
    }

    private void doCodeCell(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (actionType.getSourceBuilder() == null) {
            GuidedDecisionTableSourceBuilderIndirect sb;
            if (actionType.getCode() == ActionType.Code.CONDITION) {
                sb = new GuidedDecisionTableLHSBuilder(row - 2, column, "", this._parameterUtilities, this._conversionResult);
                this._sourceBuilders.add(sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
            } else if (actionType.getCode() == ActionType.Code.ACTION) {
                sb = new GuidedDecisionTableRHSBuilder(row - 2, column, "", this._sourceBuilders, this._parameterUtilities, this._conversionResult);
                this._sourceBuilders.add(sb);
                actionType.setSourceBuilder((SourceBuilder)sb);
            }
        }
        if (value.trim().equals("") && (actionType.getCode() == ActionType.Code.ACTION || actionType.getCode() == ActionType.Code.CONDITION || actionType.getCode() == ActionType.Code.METADATA)) {
            String message = "Code description in cell " + RuleSheetParserUtil.rc2name((int)row, (int)column) + " does not contain any code specification. It should!";
            this._conversionResult.addMessage(message, ConversionMessageType.ERROR);
        }
        actionType.addTemplate(row, column, value);
    }

    private void doLabelCell(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        SourceBuilder sb = actionType.getSourceBuilder();
        if (sb instanceof HasColumnHeadings) {
            ((HasColumnHeadings)sb).setColumnHeader(column, value);
        }
    }

    private void doDataCell(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (row - this._ruleRow > 1) {
            this.finishRuleTable();
            this.processNonRuleCell(row, column, value);
            return;
        }
        if (row > this._ruleRow) {
            ++this._ruleRow;
        }
        actionType.addCellValue(row, column, value, this._currentEscapeQuotesFlag);
    }

    private boolean isCellValueEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    private ActionType getActionForColumn(int row, int column) {
        ActionType actionType = this._actions.get(column);
        if (actionType == null) {
            String message = "Code description in cell " + RuleSheetParserUtil.rc2name((int)row, (int)column) + " does not have an 'ACTION' or 'CONDITION' column header.";
            this._conversionResult.addMessage(message, ConversionMessageType.ERROR);
        }
        return actionType;
    }
}

