/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.DTCellValueUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

@RunWith(value=Parameterized.class)
public class DTCellValueUtilitiesTest {
    private static final String DATE_FORMAT = "dd/mm/yyyy";
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("dd/mm/yyyy");
    private String type;
    private DTCellValue52 provided;
    private DataType.DataTypes expectedDataType;
    private Object expectedValue;
    private boolean hasConversionError;

    @BeforeClass
    public static void setup() {
        DTCellValueUtilitiesTest.setupPreferences();
    }

    private static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", DTCellValueUtilitiesTest.DATE_FORMAT);
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
    }

    public DTCellValueUtilitiesTest(String type, DTCellValue52 provided, DataType.DataTypes expectedDataType, Object expectedValue, boolean hasConversionError) {
        this.type = type;
        this.provided = provided;
        this.expectedDataType = expectedDataType;
        this.expectedValue = expectedValue;
        this.hasConversionError = hasConversionError;
    }

    @Parameterized.Parameters(name="{0}:{1}:{2}:{3}:{4}")
    public static Collection testParameters() throws ParseException {
        return Arrays.asList({"Numeric", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_BIGDECIMAL, new BigDecimal(100), false}, {"BigDecimal", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_BIGDECIMAL, new BigDecimal(100), false}, {"BigInteger", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_BIGINTEGER, new BigInteger("100"), false}, {"Byte", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_BYTE, new Byte("100"), false}, {"Double", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_DOUBLE, 100.0, false}, {"Float", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_FLOAT, Float.valueOf(100.0f), false}, {"Integer", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_INTEGER, 100, false}, {"Long", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_LONG, 100L, false}, {"Short", new DTCellValue52("100"), DataType.DataTypes.NUMERIC_SHORT, new Short("100"), false}, {"Boolean", new DTCellValue52("true"), DataType.DataTypes.BOOLEAN, true, false}, {"Date", new DTCellValue52("31/12/2016"), DataType.DataTypes.DATE, FORMATTER.parse("31/12/2016"), false}, {"String", new DTCellValue52("String"), DataType.DataTypes.STRING, "String", false}, {"Numeric", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_BIGDECIMAL, null, true}, {"BigDecimal", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_BIGDECIMAL, null, true}, {"BigInteger", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_BIGINTEGER, null, true}, {"Byte", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_BYTE, null, true}, {"Double", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_DOUBLE, null, true}, {"Float", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_FLOAT, null, true}, {"Integer", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_INTEGER, null, true}, {"Long", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_LONG, null, true}, {"Short", new DTCellValue52("a"), DataType.DataTypes.NUMERIC_SHORT, null, true}, {"Boolean", new DTCellValue52("a"), DataType.DataTypes.BOOLEAN, false, false}, {"Date", new DTCellValue52("a"), DataType.DataTypes.DATE, null, true});
    }

    @Test
    public void conversion() {
        DTCellValueUtilities.assertDTCellValue((String)this.type, (DTCellValue52)this.provided, (value, dataType) -> Assert.assertTrue((boolean)this.hasConversionError));
        Assert.assertEquals((Object)this.expectedDataType, (Object)this.provided.getDataType());
        Assert.assertEquals((Object)this.expectedValue, (Object)this.extractValue(this.provided));
    }

    private Object extractValue(DTCellValue52 dcv) {
        switch (dcv.getDataType()) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                return dcv.getNumericValue();
            }
            case BOOLEAN: {
                return dcv.getBooleanValue();
            }
            case DATE: {
                return dcv.getDateValue();
            }
        }
        return dcv.getStringValue();
    }
}

