/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ParameterUtilitiesTest {
    private ParameterUtilities utilities = new ParameterUtilities();

    @Test
    public void testIndexedParameters_LHSFieldValue() {
        String result = this.utilities.convertIndexedParametersToTemplateKeys("field1 == $1, field2 == $2", ParameterizedValueBuilder.Part.LHS);
        Assert.assertEquals((Object)"field1 == \"@{param1}\", field2 == \"@{param2}\"", (Object)result);
    }

    @Test
    public void testIndexedParameters_LHSFieldName() {
        String result = this.utilities.convertIndexedParametersToTemplateKeys("$1 != null, $2 != null", ParameterizedValueBuilder.Part.LHS);
        Assert.assertEquals((Object)"@{param1} != null, @{param2} != null", (Object)result);
    }

    @Test
    public void testSingleParameter_LHSFieldValue() {
        String result = this.utilities.convertSingleParameterToTemplateKey("field1 == $param", ParameterizedValueBuilder.Part.LHS);
        Assert.assertEquals((Object)"field1 == \"@{param1}\"", (Object)result);
    }

    @Test
    public void testSingleParameter_LHSFieldName() {
        String result = this.utilities.convertSingleParameterToTemplateKey("$param != null", ParameterizedValueBuilder.Part.LHS);
        Assert.assertEquals((Object)"@{param1} != null", (Object)result);
    }

    @Test
    public void testIndexedParameters_RHSFieldValue() {
        String result = this.utilities.convertIndexedParametersToTemplateKeys("setField1( $1 ); setField2( $2 )", ParameterizedValueBuilder.Part.RHS);
        Assert.assertEquals((Object)"setField1( @{param1} ); setField2( @{param2} )", (Object)result);
    }

    @Test
    public void testSingleParameter_RHSFieldValue() {
        String result = this.utilities.convertSingleParameterToTemplateKey("setField( $param )", ParameterizedValueBuilder.Part.RHS);
        Assert.assertEquals((Object)"setField( @{param1} )", (Object)result);
    }
}

