/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderDirect;

public class GuidedDecisionTableMetadataBuilder
implements GuidedDecisionTableSourceBuilderDirect {
    private int headerRow;
    private int headerCol;
    private Map<Integer, String> definitions = new HashMap<Integer, String>();
    private List<DTCellValue52> values = new ArrayList<DTCellValue52>();
    private ConversionResult conversionResult;

    public GuidedDecisionTableMetadataBuilder(int row, int column, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.conversionResult = conversionResult;
    }

    @Override
    public void populateDecisionTable(GuidedDecisionTable52 dtable, int maxRowCount) {
        MetadataCol52 column = new MetadataCol52();
        String value = this.definitions.get(this.headerCol);
        column.setHideColumn(true);
        column.setMetadata(value);
        dtable.getMetadataCols().add(column);
        if (this.values.size() < maxRowCount) {
            for (int iRow = this.values.size(); iRow < maxRowCount; ++iRow) {
                this.values.add(new DTCellValue52(""));
            }
        }
        this.addColumnData(dtable, (DTColumnConfig52)column);
    }

    private void addColumnData(GuidedDecisionTable52 dtable, DTColumnConfig52 column) {
        int rowCount = this.values.size();
        int iColIndex = dtable.getExpandedColumns().indexOf(column);
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.add(iColIndex, this.values.get(iRow));
        }
    }

    public void addTemplate(int row, int column, String content) {
        if (this.definitions.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionMessageType.ERROR);
        }
        this.definitions.put(column, content.trim());
    }

    public void addCellValue(int row, int column, String value) {
        String content = this.definitions.get(column);
        if (content == null) {
            String message = "No code snippet for METADATA in cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionMessageType.ERROR);
        }
        DTCellValue52 dcv = new DTCellValue52(value);
        this.values.add(dcv);
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.METADATA;
    }

    public void clearValues() {
        this.values.clear();
    }

    public boolean hasValues() {
        return this.values.size() > 0;
    }

    public String getResult() {
        throw new UnsupportedOperationException("GuidedDecisionTableMetadataBuilder does not return DRL.");
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }
}

