/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.dtablexls.backend.server.indexing.TestDecisionTableXLSFileIndexer;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexDecisionTableXLSAttributeNameTest
extends BaseIndexingTest<DecisionTableXLSResourceTypeDefinition> {
    @Test
    public void testIndexDecisionTableXLSAttributeName() throws IOException, InterruptedException {
        Path path1 = this.loadXLSFile(this.basePath, "dtable1.xls");
        Path path2 = this.loadXLSFile(this.basePath, "dtable2.xls");
        Thread.sleep(5000L);
        Index index = IndexDecisionTableXLSAttributeNameTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD)).build();
        this.searchFor(index, query, 1, new Path[]{path1});
    }

    protected TestIndexer getIndexer() {
        return new TestDecisionTableXLSFileIndexer();
    }

    protected DecisionTableXLSResourceTypeDefinition getResourceTypeDefinition() {
        return new DecisionTableXLSResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private Path loadXLSFile(Path basePath, String fileName) throws IOException {
        Path path = basePath.resolve(fileName);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        OutputStream os = this.ioService().newOutputStream(path, new OpenOption[0]);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        os.close();
        return path;
    }
}

