/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

public class DTCellValueUtilities {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat(DATE_FORMAT);

    public static void assertDTCellValue(String type, DTCellValue52 dcv, ConversionErrorCallback callback) {
        if (dcv == null) {
            return;
        }
        DataType.DataTypes dataType = DTCellValueUtilities.convertToTypeSafeType(type);
        if (dataType.equals((Object)dcv.getDataType())) {
            return;
        }
        switch (dcv.getDataType()) {
            case NUMERIC: {
                DTCellValueUtilities.convertDTCellValueFromNumeric(dataType, dcv);
                break;
            }
            default: {
                DTCellValueUtilities.convertDTCellValueFromString(dataType, dcv, callback);
            }
        }
    }

    private static DataType.DataTypes convertToTypeSafeType(String type) {
        if (type.equals("Numeric")) {
            return DataType.DataTypes.NUMERIC;
        }
        if (type.equals("BigDecimal")) {
            return DataType.DataTypes.NUMERIC_BIGDECIMAL;
        }
        if (type.equals("BigInteger")) {
            return DataType.DataTypes.NUMERIC_BIGINTEGER;
        }
        if (type.equals("Byte")) {
            return DataType.DataTypes.NUMERIC_BYTE;
        }
        if (type.equals("Double")) {
            return DataType.DataTypes.NUMERIC_DOUBLE;
        }
        if (type.equals("Float")) {
            return DataType.DataTypes.NUMERIC_FLOAT;
        }
        if (type.equals("Integer")) {
            return DataType.DataTypes.NUMERIC_INTEGER;
        }
        if (type.equals("Long")) {
            return DataType.DataTypes.NUMERIC_LONG;
        }
        if (type.equals("Short")) {
            return DataType.DataTypes.NUMERIC_SHORT;
        }
        if (type.equals("Boolean")) {
            return DataType.DataTypes.BOOLEAN;
        }
        if (type.equals("Date")) {
            return DataType.DataTypes.DATE;
        }
        return DataType.DataTypes.STRING;
    }

    private static void convertDTCellValueFromString(DataType.DataTypes dataType, DTCellValue52 dcv, ConversionErrorCallback callback) {
        String text = dcv.getStringValue();
        switch (dataType) {
            case BOOLEAN: {
                dcv.setBooleanValue(text == null ? Boolean.FALSE : Boolean.valueOf(text));
                break;
            }
            case DATE: {
                Date d = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        d = FORMATTER.parse(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (ParseException e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setDateValue(d);
                break;
            }
            case NUMERIC: {
                BigDecimal numericValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        numericValue = new BigDecimal(DTCellValueUtilities.stripTrailing(DTCellValueUtilities.stripQuotes(text), "B"));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(numericValue);
                break;
            }
            case NUMERIC_BIGDECIMAL: {
                BigDecimal bigDecimalValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        bigDecimalValue = new BigDecimal(DTCellValueUtilities.stripTrailing(DTCellValueUtilities.stripQuotes(text), "B"));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(bigDecimalValue);
                break;
            }
            case NUMERIC_BIGINTEGER: {
                BigInteger bigIntegerValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        bigIntegerValue = new BigInteger(DTCellValueUtilities.stripTrailing(DTCellValueUtilities.stripQuotes(text), "I"));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(bigIntegerValue);
                break;
            }
            case NUMERIC_BYTE: {
                Byte byteValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        byteValue = Byte.valueOf(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(byteValue);
                break;
            }
            case NUMERIC_DOUBLE: {
                Double doubleValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        doubleValue = Double.valueOf(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(doubleValue);
                break;
            }
            case NUMERIC_FLOAT: {
                Float floatValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        floatValue = Float.valueOf(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(floatValue);
                break;
            }
            case NUMERIC_INTEGER: {
                Integer integerValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        integerValue = Integer.valueOf(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(integerValue);
                break;
            }
            case NUMERIC_LONG: {
                Long longValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        longValue = Long.valueOf(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(longValue);
                break;
            }
            case NUMERIC_SHORT: {
                Short shortValue = null;
                try {
                    if (text != null && !text.isEmpty()) {
                        shortValue = Short.valueOf(DTCellValueUtilities.stripQuotes(text));
                    }
                }
                catch (Exception e) {
                    callback.onConversionError(text, dataType);
                }
                dcv.setNumericValue(shortValue);
            }
        }
    }

    static String stripQuotes(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.startsWith("\"")) {
            text = text.substring(1);
        }
        if (text.endsWith("\"")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    static String stripTrailing(String text, String suffix) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static void convertDTCellValueFromNumeric(DataType.DataTypes dataType, DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        switch (dataType) {
            case NUMERIC_BIGDECIMAL: {
                dcv.setNumericValue(value == null ? null : value);
                break;
            }
            case NUMERIC_BIGINTEGER: {
                dcv.setNumericValue(value == null ? null : value.toBigInteger());
                break;
            }
            case NUMERIC_BYTE: {
                dcv.setNumericValue(value == null ? null : Byte.valueOf(value.byteValue()));
                break;
            }
            case NUMERIC_DOUBLE: {
                dcv.setNumericValue(value == null ? null : Double.valueOf(value.doubleValue()));
                break;
            }
            case NUMERIC_FLOAT: {
                dcv.setNumericValue(value == null ? null : Float.valueOf(value.floatValue()));
                break;
            }
            case NUMERIC_INTEGER: {
                dcv.setNumericValue(value == null ? null : Integer.valueOf(value.intValue()));
                break;
            }
            case NUMERIC_LONG: {
                dcv.setNumericValue(value == null ? null : Long.valueOf(value.longValue()));
                break;
            }
            case NUMERIC_SHORT: {
                dcv.setNumericValue(value == null ? null : Short.valueOf(value.shortValue()));
            }
        }
    }

    public static interface ConversionErrorCallback {
        public void onConversionError(String var1, DataType.DataTypes var2);
    }
}

