/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessage;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.GuidedDecisionTableGeneratorListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableGeneratorListenerTest {
    private PackageDataModelOracle dmo;
    private Map<String, ModelField[]> packageModelFields = new HashMap<String, ModelField[]>();

    @BeforeClass
    public static void setup() {
        GuidedDecisionTableGeneratorListenerTest.setupPreferences();
        GuidedDecisionTableGeneratorListenerTest.setupSystemProperties();
    }

    private static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
    }

    private static void setupSystemProperties() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
        System.setProperty("org.uberfire.sys.repo.monitor.disabled", "true");
    }

    @Before
    public void setupMocks() throws Exception {
        this.dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        Mockito.when((Object)this.dmo.getProjectModelFields()).thenReturn(this.packageModelFields);
    }

    @After
    public void cleanUp() throws Exception {
        this.packageModelFields.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributes() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Attributes.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"AttributesTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)12L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(3) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(4) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(5) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(6) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(7) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(8) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(9) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(10) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(11) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"salience", (Object)attrCol2.getAttribute());
        Assert.assertFalse((boolean)attrCol2.isUseRowNumber());
        Assert.assertFalse((boolean)attrCol2.isReverseOrder());
        AttributeCol52 attrCol3 = (AttributeCol52)columns.get(3);
        Assert.assertEquals((Object)"activation-group", (Object)attrCol3.getAttribute());
        AttributeCol52 attrCol4 = (AttributeCol52)columns.get(4);
        Assert.assertEquals((Object)"duration", (Object)attrCol4.getAttribute());
        AttributeCol52 attrCol5 = (AttributeCol52)columns.get(5);
        Assert.assertEquals((Object)"timer", (Object)attrCol5.getAttribute());
        AttributeCol52 attrCol6 = (AttributeCol52)columns.get(6);
        Assert.assertEquals((Object)"calendars", (Object)attrCol6.getAttribute());
        AttributeCol52 attrCol7 = (AttributeCol52)columns.get(7);
        Assert.assertEquals((Object)"no-loop", (Object)attrCol7.getAttribute());
        AttributeCol52 attrCol8 = (AttributeCol52)columns.get(8);
        Assert.assertEquals((Object)"lock-on-active", (Object)attrCol8.getAttribute());
        AttributeCol52 attrCol9 = (AttributeCol52)columns.get(9);
        Assert.assertEquals((Object)"auto-focus", (Object)attrCol9.getAttribute());
        AttributeCol52 attrCol10 = (AttributeCol52)columns.get(10);
        Assert.assertEquals((Object)"agenda-group", (Object)attrCol10.getAttribute());
        AttributeCol52 attrCol11 = (AttributeCol52)columns.get(11);
        Assert.assertEquals((Object)"ruleflow-group", (Object)attrCol11.getAttribute());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Specific rule 1", 1, "g1", 100L, "T1", "CAL1", true, true, true, "AG1", "RFG1"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Specific rule 2", 2, "g2", 200L, "T2", "CAL2", false, false, false, "AG2", "RFG2"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequentialSalience() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("SequentialSalience.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"SequentialSalienceTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"salience", (Object)attrCol2.getAttribute());
        Assert.assertTrue((boolean)attrCol2.isUseRowNumber());
        Assert.assertTrue((boolean)attrCol2.isReverseOrder());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Rule 1", 2}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Rule 2", 1}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSalienceWarnings() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("SalienceWarnings.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)2L, (long)result.getMessages().size());
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(0)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(0)).getMessage().indexOf("Priority is not an integer literal, in cell C7") == -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(1)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(1)).getMessage().indexOf("Priority is not an integer literal, in cell C8") == -1 ? 1 : 0) != 0);
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"SalienceWarningsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"salience", (Object)attrCol2.getAttribute());
        Assert.assertFalse((boolean)attrCol2.isUseRowNumber());
        Assert.assertFalse((boolean)attrCol2.isReverseOrder());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Rule 1", 0}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Rule 2", 0}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDurationWarnings() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("DurationWarnings.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)2L, (long)result.getMessages().size());
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(0)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(0)).getMessage().indexOf("Duration is not an long literal, in cell C7") == -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ConversionMessageType.WARNING, (Object)((ConversionMessage)result.getMessages().get(1)).getMessageType());
        Assert.assertFalse((((ConversionMessage)result.getMessages().get(1)).getMessage().indexOf("Duration is not an long literal, in cell C8") == -1 ? 1 : 0) != 0);
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"DurationWarningsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        AttributeCol52 attrCol2 = (AttributeCol52)columns.get(2);
        Assert.assertEquals((Object)"duration", (Object)attrCol2.getAttribute());
        Assert.assertFalse((boolean)attrCol2.isUseRowNumber());
        Assert.assertFalse((boolean)attrCol2.isReverseOrder());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Rule 1", 0}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Rule 2", 0}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadata() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Metadata.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"MetadataTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof MetadataCol52));
        MetadataCol52 mdCol2 = (MetadataCol52)columns.get(2);
        Assert.assertEquals((Object)"cheese", (Object)mdCol2.getMetadata());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Rule 1", "cheddar"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Rule 2", "edam"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalsConversion() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("BZ1310208.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List globals = listener.getGlobals();
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)1L, (long)globals.size());
        Global global = (Global)globals.get(0);
        Assert.assertEquals((Object)"list", (Object)global.getIdentifier());
        Assert.assertEquals((Object)"List", (Object)global.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActions() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Actions.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"ActionsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)7L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)4L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        Assert.assertTrue((boolean)(dtable.getActionCols().get(1) instanceof BRLActionColumn));
        Assert.assertTrue((boolean)(dtable.getActionCols().get(2) instanceof BRLActionColumn));
        Assert.assertTrue((boolean)(dtable.getActionCols().get(3) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Multi-parameters', 'Multi-parameters']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)2L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"policy.setBasePrice(@{param1}, @{param2});", (Object)actionCol0ffl.getText());
        BRLActionVariableColumn actionCol0param0 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)actionCol0param0.getVarName());
        Assert.assertEquals((Object)"Multi-parameters", (Object)actionCol0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0param0.getFieldType());
        Assert.assertNull((Object)actionCol0param0.getFactType());
        Assert.assertNull((Object)actionCol0param0.getFactField());
        BRLActionVariableColumn actionCol0param1 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)actionCol0param1.getVarName());
        Assert.assertEquals((Object)"Multi-parameters", (Object)actionCol0param1.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0param1.getFieldType());
        Assert.assertNull((Object)actionCol0param1.getFactType());
        Assert.assertNull((Object)actionCol0param1.getFactField());
        BRLActionColumn actionCol1 = (BRLActionColumn)dtable.getActionCols().get(1);
        Assert.assertEquals((Object)"Converted from ['Single-parameter']", (Object)actionCol1.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol1.getChildColumns().size());
        List actionCol1definition = actionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol1definition.size());
        Assert.assertTrue((boolean)(actionCol1definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol1ffl = (FreeFormLine)actionCol1definition.get(0);
        Assert.assertEquals((Object)"policy.setSmurf(@{param3});", (Object)actionCol1ffl.getText());
        BRLActionVariableColumn actionCol1param0 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param3", (Object)actionCol1param0.getVarName());
        Assert.assertEquals((Object)"Single-parameter", (Object)actionCol1param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol1param0.getFieldType());
        Assert.assertNull((Object)actionCol1param0.getFactType());
        Assert.assertNull((Object)actionCol1param0.getFactField());
        BRLActionColumn actionCol2 = (BRLActionColumn)dtable.getActionCols().get(2);
        Assert.assertEquals((Object)"Converted from ['Log-single-parameter']", (Object)actionCol2.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol2.getChildColumns().size());
        List actionCol2definition = actionCol2.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol2definition.size());
        Assert.assertTrue((boolean)(actionCol2definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol2ffl = (FreeFormLine)actionCol2definition.get(0);
        Assert.assertEquals((Object)"System.out.println(\"@{param4}\");", (Object)actionCol2ffl.getText());
        BRLActionVariableColumn actionCol2param0 = (BRLActionVariableColumn)actionCol2.getChildColumns().get(0);
        Assert.assertEquals((Object)"param4", (Object)actionCol2param0.getVarName());
        Assert.assertEquals((Object)"Log-single-parameter", (Object)actionCol2param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol2param0.getFieldType());
        Assert.assertNull((Object)actionCol2param0.getFactType());
        Assert.assertNull((Object)actionCol2param0.getFactField());
        BRLActionColumn actionCol3 = (BRLActionColumn)dtable.getActionCols().get(3);
        Assert.assertEquals((Object)"Converted from ['Zero-parameters']", (Object)actionCol3.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol3.getChildColumns().size());
        List actionCol3definition = actionCol3.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol3definition.size());
        Assert.assertTrue((boolean)(actionCol3definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol3ffl = (FreeFormLine)actionCol3definition.get(0);
        Assert.assertEquals((Object)"System.out.println(\"Woot\");", (Object)actionCol3ffl.getText());
        BRLActionVariableColumn actionCol3param0 = (BRLActionVariableColumn)actionCol3.getChildColumns().get(0);
        Assert.assertEquals((Object)"", (Object)actionCol3param0.getVarName());
        Assert.assertEquals((Object)"Zero-parameters", (Object)actionCol3param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol3param0.getFieldType());
        Assert.assertNull((Object)actionCol3param0.getFactType());
        Assert.assertNull((Object)actionCol3param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Row 1", "10", "20", "30", "hello", true}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Row 2", "50", "60", "70", "goodbye", false}, (List)dtable.getData().get(1)));
    }

    @Test
    public void testConditions() {
        ArrayList<Object[]> expectedRows = new ArrayList<Object[]>(2);
        expectedRows.add(new Object[]{1, "Row 1", 20, "Mike", "Brown", "BMW", "M3"});
        expectedRows.add(new Object[]{2, "Row 2", 30, "Jason", "Grey", "Audi", "S4"});
        this.conditionsTest("Conditions.xls", expectedRows);
    }

    @Test
    public void testConditionsIndexedParameters() {
        ArrayList<Object[]> expectedRows = new ArrayList<Object[]>(2);
        expectedRows.add(new Object[]{1, "Row 1", 20, "Mike", "Brown", "BMW", "M3"});
        expectedRows.add(new Object[]{2, "Row 2", 30, "Jason", "Grey", "", ""});
        this.conditionsTest("Conditions-indexedParameters.xls", expectedRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conditionsTest(String xlsFileName, List<Object[]> expectedRows) {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Driver", "this", "org.test.Driver", "this");
        this.addModelField("org.test.Driver", "age", Integer.class.getName(), "Integer");
        this.addModelField("org.test.Driver", "firstName", String.class.getName(), "String");
        this.addModelField("org.test.Driver", "surname", String.class.getName(), "String");
        this.addModelField("org.test.Vehicle", "this", "org.test.Vehicle", "this");
        this.addModelField("org.test.Vehicle", "make", String.class.getName(), "String");
        this.addModelField("org.test.Vehicle", "model", String.class.getName(), "String");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream(xlsFileName);
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"ConditionsTest", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)7L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLConditionVariableColumn));
        Assert.assertEquals((long)2L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        Assert.assertTrue((boolean)(dtable.getConditions().get(1) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Age of driver', 'First name', 'Surname']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)3L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Driver", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)3L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"age", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)">", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc0.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc1 = (SingleFieldConstraint)conditionCol0fp.getConstraint(1);
        Assert.assertEquals((Object)"firstName", (Object)conditionCol0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc1.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc2 = (SingleFieldConstraint)conditionCol0fp.getConstraint(2);
        Assert.assertEquals((Object)"surname", (Object)conditionCol0fpsfc2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc2.getOperator());
        Assert.assertEquals((Object)"param3", (Object)conditionCol0fpsfc2.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc2.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc2.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Age of driver", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Driver", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"age", (Object)conditionCol0param0.getFactField());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"First name", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param1.getFieldType());
        Assert.assertEquals((Object)"Driver", (Object)conditionCol0param1.getFactType());
        Assert.assertEquals((Object)"firstName", (Object)conditionCol0param1.getFactField());
        BRLConditionVariableColumn conditionCol0param2 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(2);
        Assert.assertEquals((Object)"param3", (Object)conditionCol0param2.getVarName());
        Assert.assertEquals((Object)"Surname", (Object)conditionCol0param2.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param2.getFieldType());
        Assert.assertEquals((Object)"Driver", (Object)conditionCol0param2.getFactType());
        Assert.assertEquals((Object)"surname", (Object)conditionCol0param2.getFactField());
        BRLConditionColumn conditionCol1 = (BRLConditionColumn)dtable.getConditions().get(1);
        Assert.assertEquals((Object)"Converted from ['something', 'something']", (Object)conditionCol1.getHeader());
        Assert.assertEquals((long)2L, (long)conditionCol1.getChildColumns().size());
        List conditionCol1definition = conditionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol1definition.size());
        Assert.assertTrue((boolean)(conditionCol1definition.get(0) instanceof FactPattern));
        FactPattern conditionCol1fp = (FactPattern)conditionCol1definition.get(0);
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol1fp.getFactType());
        Assert.assertEquals((long)2L, (long)conditionCol1fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol1fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol1fpsfc0 = (SingleFieldConstraint)conditionCol1fp.getConstraint(0);
        Assert.assertEquals((Object)"make", (Object)conditionCol1fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol1fpsfc0.getOperator());
        Assert.assertEquals((Object)"param4", (Object)conditionCol1fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol1fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol1fpsfc0.getFieldType());
        Assert.assertTrue((boolean)(conditionCol1fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol1fpsfc1 = (SingleFieldConstraint)conditionCol1fp.getConstraint(1);
        Assert.assertEquals((Object)"model", (Object)conditionCol1fpsfc1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol1fpsfc1.getOperator());
        Assert.assertEquals((Object)"param5", (Object)conditionCol1fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol1fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol1fpsfc1.getFieldType());
        BRLConditionVariableColumn conditionCol1param0 = (BRLConditionVariableColumn)conditionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param4", (Object)conditionCol1param0.getVarName());
        Assert.assertEquals((Object)"something", (Object)conditionCol1param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol1param0.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol1param0.getFactType());
        Assert.assertEquals((Object)"make", (Object)conditionCol1param0.getFactField());
        BRLConditionVariableColumn conditionCol1param1 = (BRLConditionVariableColumn)conditionCol1.getChildColumns().get(1);
        Assert.assertEquals((Object)"param5", (Object)conditionCol1param1.getVarName());
        Assert.assertEquals((Object)"something", (Object)conditionCol1param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol1param1.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol1param1.getFactType());
        Assert.assertEquals((Object)"model", (Object)conditionCol1param1.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertNotNull(expectedRows);
        Assert.assertTrue((expectedRows.size() == 2 ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.isRowEquivalent(expectedRows.get(i), (List)dtable.getData().get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRuleTables() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("MultipleRuleTables.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)2L, (long)dtables.size());
        GuidedDecisionTable52 dtable0 = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"Table1", (Object)dtable0.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable0.getTableFormat());
        GuidedDecisionTable52 dtable1 = (GuidedDecisionTable52)dtables.get(1);
        Assert.assertEquals((Object)"Table2", (Object)dtable1.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable1.getTableFormat());
        List columns0 = dtable0.getExpandedColumns();
        Assert.assertNotNull((Object)columns0);
        Assert.assertEquals((long)5L, (long)columns0.size());
        Assert.assertTrue((boolean)(columns0.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns0.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns0.get(2) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns0.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns0.get(4) instanceof BRLActionVariableColumn));
        AttributeCol52 attrCol0_2 = (AttributeCol52)columns0.get(2);
        Assert.assertEquals((Object)"agenda-group", (Object)attrCol0_2.getAttribute());
        Assert.assertEquals((long)1L, (long)dtable0.getConditions().size());
        Assert.assertTrue((boolean)(dtable0.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0_0 = (BRLConditionColumn)dtable0.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Person's name']", (Object)conditionCol0_0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0_0.getChildColumns().size());
        List conditionCol0_0definition = conditionCol0_0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0_0definition.size());
        Assert.assertTrue((boolean)(conditionCol0_0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0_0fp = (FactPattern)conditionCol0_0definition.get(0);
        Assert.assertEquals((Object)"Person", (Object)conditionCol0_0fp.getFactType());
        Assert.assertEquals((long)1L, (long)conditionCol0_0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0_0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0_0fpsfc0 = (SingleFieldConstraint)conditionCol0_0fp.getConstraint(0);
        Assert.assertEquals((Object)"name", (Object)conditionCol0_0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0_0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0_0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0_0fpsfc0.getConstraintValueType());
        BRLConditionVariableColumn conditionCol0_0param0 = (BRLConditionVariableColumn)conditionCol0_0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0_0param0.getVarName());
        Assert.assertEquals((Object)"Person's name", (Object)conditionCol0_0param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0_0param0.getFieldType());
        Assert.assertEquals((Object)"Person", (Object)conditionCol0_0param0.getFactType());
        Assert.assertEquals((Object)"name", (Object)conditionCol0_0param0.getFactField());
        BRLActionColumn actionCol0_0 = (BRLActionColumn)dtable0.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Salutation']", (Object)actionCol0_0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0_0.getChildColumns().size());
        List actionCol0_0definition = actionCol0_0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0_0definition.size());
        Assert.assertTrue((boolean)(actionCol0_0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0_0ffl = (FreeFormLine)actionCol0_0definition.get(0);
        Assert.assertEquals((Object)"System.out.println(\"@{param2}\");", (Object)actionCol0_0ffl.getText());
        BRLActionVariableColumn actionCol0_0param0 = (BRLActionVariableColumn)actionCol0_0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param2", (Object)actionCol0_0param0.getVarName());
        Assert.assertEquals((Object)"Salutation", (Object)actionCol0_0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0_0param0.getFieldType());
        Assert.assertNull((Object)actionCol0_0param0.getFactType());
        Assert.assertNull((Object)actionCol0_0param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable0.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Created from row 7", "AG1", "John", "Hello Sir"}, (List)dtable0.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Row 2", "AG2", "Jane", "Hello Madam"}, (List)dtable0.getData().get(1)));
        List columns1 = dtable1.getExpandedColumns();
        Assert.assertNotNull((Object)columns1);
        Assert.assertEquals((long)4L, (long)columns1.size());
        Assert.assertTrue((boolean)(columns1.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns1.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns1.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns1.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable0.getConditions().size());
        Assert.assertTrue((boolean)(dtable0.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol1_0 = (BRLConditionColumn)dtable1.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Person\u2019s name', 'Person\u2019s age']", (Object)conditionCol1_0.getHeader());
        Assert.assertEquals((long)2L, (long)conditionCol1_0.getChildColumns().size());
        List conditionCol1_0definition = conditionCol1_0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol1_0definition.size());
        Assert.assertTrue((boolean)(conditionCol1_0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol1_0fp = (FactPattern)conditionCol1_0definition.get(0);
        Assert.assertEquals((Object)"Person", (Object)conditionCol1_0fp.getFactType());
        Assert.assertEquals((long)2L, (long)conditionCol1_0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol1_0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol1_0fpsfc0 = (SingleFieldConstraint)conditionCol1_0fp.getConstraint(0);
        Assert.assertEquals((Object)"name", (Object)conditionCol1_0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol1_0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol1_0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol1_0fpsfc0.getConstraintValueType());
        Assert.assertTrue((boolean)(conditionCol1_0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol1_0fpsfc1 = (SingleFieldConstraint)conditionCol1_0fp.getConstraint(1);
        Assert.assertEquals((Object)"age", (Object)conditionCol1_0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol1_0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol1_0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol1_0fpsfc1.getConstraintValueType());
        BRLConditionVariableColumn conditionCol1_0param0 = (BRLConditionVariableColumn)conditionCol1_0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol1_0param0.getVarName());
        Assert.assertEquals((Object)"Person\u2019s name", (Object)conditionCol1_0param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol1_0param0.getFieldType());
        Assert.assertEquals((Object)"Person", (Object)conditionCol1_0param0.getFactType());
        Assert.assertEquals((Object)"name", (Object)conditionCol1_0param0.getFactField());
        BRLConditionVariableColumn conditionCol1_0param1 = (BRLConditionVariableColumn)conditionCol1_0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol1_0param1.getVarName());
        Assert.assertEquals((Object)"Person\u2019s age", (Object)conditionCol1_0param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol1_0param1.getFieldType());
        Assert.assertEquals((Object)"Person", (Object)conditionCol1_0param1.getFactType());
        Assert.assertEquals((Object)"age", (Object)conditionCol1_0param1.getFactField());
        Assert.assertEquals((long)2L, (long)dtable1.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Row 1", "John", "25"}, (List)dtable1.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Created from row 16", "Jane", "29"}, (List)dtable1.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSingleParameters() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("MultipleSingleParameters.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"MultipleSingleParameters", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Re-using single parameter']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine conditionCol0ffl = (FreeFormLine)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Driver(@{param1} != null, @{param1} == true)", (Object)conditionCol0ffl.getText());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Re-using single parameter", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol0param0.getFieldType());
        Assert.assertNull((Object)conditionCol0param0.getFactType());
        Assert.assertNull((Object)conditionCol0param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Row 1", "isQualified"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Row 2", "isLicensed"}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperties() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Properties.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List functions = listener.getFunctions();
        Assert.assertNotNull((Object)functions);
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertEquals((Object)"function a() { }", functions.get(0));
        List globals = listener.getGlobals();
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)1L, (long)globals.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Global)globals.get(0)).getClassName());
        Assert.assertEquals((Object)"list", (Object)((Global)globals.get(0)).getIdentifier());
        List imports = listener.getImports();
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"org.yourco.model.*", (Object)((Import)imports.get(0)).getClassName());
        Assert.assertEquals((Object)"java.util.Date", (Object)((Import)imports.get(1)).getClassName());
        List queries = listener.getQueries();
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        Assert.assertEquals((Object)"A query", queries.get(0));
        List types = listener.getTypeDeclarations();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)"declare Smurf name : String end", types.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTestNonExistentCellsFromPOI() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2188.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"IdentifyMetadataRules", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)6L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Ingest Path', 'Court Id', 'Artifact Metadata Identified']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)3L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"IdentifyMetadataArtifact", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)3L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"ingestPath", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc0.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc1 = (SingleFieldConstraint)conditionCol0fp.getConstraint(1);
        Assert.assertEquals((Object)"courtId", (Object)conditionCol0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc1.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc2 = (SingleFieldConstraint)conditionCol0fp.getConstraint(2);
        Assert.assertEquals((Object)"artifactMetadataIdentified", (Object)conditionCol0fpsfc2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc2.getOperator());
        Assert.assertEquals((Object)"param3", (Object)conditionCol0fpsfc2.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc2.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc2.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Ingest Path", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"IdentifyMetadataArtifact", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"ingestPath", (Object)conditionCol0param0.getFactField());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"Court Id", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param1.getFieldType());
        Assert.assertEquals((Object)"IdentifyMetadataArtifact", (Object)conditionCol0param1.getFactType());
        Assert.assertEquals((Object)"courtId", (Object)conditionCol0param1.getFactField());
        BRLConditionVariableColumn conditionCol0param2 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(2);
        Assert.assertEquals((Object)"param3", (Object)conditionCol0param2.getVarName());
        Assert.assertEquals((Object)"Artifact Metadata Identified", (Object)conditionCol0param2.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param2.getFieldType());
        Assert.assertEquals((Object)"IdentifyMetadataArtifact", (Object)conditionCol0param2.getFactType());
        Assert.assertEquals((Object)"artifactMetadataIdentified", (Object)conditionCol0param2.getFactField());
        Assert.assertEquals((long)1L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Identify Metadata Required']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof ActionSetField));
        ActionSetField actionCol0asf = (ActionSetField)actionCol0definition.get(0);
        Assert.assertEquals((Object)"fact1", (Object)actionCol0asf.getVariable());
        Assert.assertEquals((long)1L, (long)actionCol0asf.getFieldValues().length);
        ActionFieldValue actionCol0asf_afv0 = actionCol0asf.getFieldValues()[0];
        Assert.assertEquals((Object)"identifiedMetadataRequired", (Object)actionCol0asf_afv0.getField());
        Assert.assertEquals((Object)"param4", (Object)actionCol0asf_afv0.getValue());
        Assert.assertEquals((long)7L, (long)actionCol0asf_afv0.getNature());
        Assert.assertEquals((Object)"String", (Object)actionCol0asf_afv0.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingTemplateKeyValues_StringFields() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2030.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"asd", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)6L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Rule disabler', 'CovenanteeId', 'blah']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)3L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Transaction", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)3L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"isDisabled(\"asd\")", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"java.lang.String", (Object)conditionCol0fpsfc0.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc1 = (SingleFieldConstraint)conditionCol0fp.getConstraint(1);
        Assert.assertEquals((Object)"getClientCovenanteeId()", (Object)conditionCol0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"java.lang.String", (Object)conditionCol0fpsfc1.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc2 = (SingleFieldConstraint)conditionCol0fp.getConstraint(2);
        Assert.assertEquals((Object)"isBlacklisted(\"asd\")", (Object)conditionCol0fpsfc2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc2.getOperator());
        Assert.assertEquals((Object)"param3", (Object)conditionCol0fpsfc2.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc2.getConstraintValueType());
        Assert.assertEquals((Object)"java.lang.String", (Object)conditionCol0fpsfc2.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Rule disabler", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"java.lang.String", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"isDisabled(\"asd\")", (Object)conditionCol0param0.getFactField());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"CovenanteeId", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param1.getFieldType());
        Assert.assertEquals((Object)"java.lang.String", (Object)conditionCol0param1.getFactType());
        Assert.assertEquals((Object)"getClientCovenanteeId()", (Object)conditionCol0param1.getFactField());
        BRLConditionVariableColumn conditionCol0param2 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(2);
        Assert.assertEquals((Object)"param3", (Object)conditionCol0param2.getVarName());
        Assert.assertEquals((Object)"blah", (Object)conditionCol0param2.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param2.getFieldType());
        Assert.assertEquals((Object)"java.lang.String", (Object)conditionCol0param2.getFactType());
        Assert.assertEquals((Object)"isBlacklisted(\"asd\")", (Object)conditionCol0param2.getFactField());
        Assert.assertEquals((long)1L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Risk level']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"riskIndex.setRisk(\"asd\", @{param4});", (Object)actionCol0ffl.getText());
        Assert.assertEquals((long)1L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "asd", "false", "", "true", "0"}, (List)dtable.getData().get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowDescriptions() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("MultipleRuleTables.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)2L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertEquals((Object)"Created from row 7", (Object)((DTCellValue52)((List)dtable.getData().get(0)).get(1)).getStringValue());
        Assert.assertEquals((Object)"Row 2", (Object)((DTCellValue52)((List)dtable.getData().get(1)).get(1)).getStringValue());
        dtable = (GuidedDecisionTable52)dtables.get(1);
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertEquals((Object)"Row 1", (Object)((DTCellValue52)((List)dtable.getData().get(0)).get(1)).getStringValue());
        Assert.assertEquals((Object)"Created from row 16", (Object)((DTCellValue52)((List)dtable.getData().get(1)).get(1)).getStringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingTemplateKeyValues_NonStringFields() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Client", "this", "org.test.Client", "this");
        this.addModelField("org.test.Client", "monthlyTransactions", Integer.class.getName(), "Integer");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2030 (DecisionTable).xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"Steps", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)5L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['From', 'To']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)2L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Client", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)2L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"monthlyTransactions", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)">=", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc0.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc1 = (SingleFieldConstraint)conditionCol0fp.getConstraint(1);
        Assert.assertEquals((Object)"monthlyTransactions", (Object)conditionCol0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"<=", (Object)conditionCol0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc1.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"From", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Client", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"monthlyTransactions", (Object)conditionCol0param0.getFactField());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"To", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param1.getFieldType());
        Assert.assertEquals((Object)"Client", (Object)conditionCol0param1.getFactType());
        Assert.assertEquals((Object)"monthlyTransactions", (Object)conditionCol0param1.getFactField());
        Assert.assertEquals((long)1L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Step']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"if (!$c.isPricingStepCustom() && ($c.getPricingStep() == null || $c.getPricingStep().compareTo(\"@{param3}\") < 0)) { modify($c) { setPricingStep(\"@{param3}\"); } };", (Object)actionCol0ffl.getText());
        Assert.assertEquals((long)1L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Created from row 12", 0, 100, "A1"}, (List)dtable.getData().get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingTemplateKeyValues_RHSInsertThenUpdate() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Transaction", "this", "org.test.Transaction", "this");
        this.addModelField("org.test.Transaction", "enabled", Boolean.class.getName(), "Boolean");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2030 (RHS insert then update).xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"asd", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)6L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Disabled']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Transaction", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)1L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"enabled", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Boolean", (Object)conditionCol0fpsfc0.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Disabled", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Transaction", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"enabled", (Object)conditionCol0param0.getFactField());
        Assert.assertEquals((long)3L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Enable']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof ActionSetField));
        ActionSetField actionCol0asf0 = (ActionSetField)actionCol0definition.get(0);
        Assert.assertEquals((Object)"$t", (Object)actionCol0asf0.getVariable());
        ActionFieldValue[] actionCol0asf0afvs = actionCol0asf0.getFieldValues();
        Assert.assertEquals((long)1L, (long)actionCol0asf0afvs.length);
        ActionFieldValue actionCol0asf0afv0 = actionCol0asf0afvs[0];
        Assert.assertEquals((Object)"enabled", (Object)actionCol0asf0afv0.getField());
        Assert.assertEquals((Object)"param2", (Object)actionCol0asf0afv0.getValue());
        Assert.assertEquals((long)7L, (long)actionCol0asf0afv0.getNature());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol0asf0afv0.getType());
        BRLActionColumn actionCol1 = (BRLActionColumn)dtable.getActionCols().get(1);
        Assert.assertEquals((Object)"Converted from ['New']", (Object)actionCol1.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol1.getChildColumns().size());
        List actionCol1definition = actionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol1definition.size());
        Assert.assertTrue((boolean)(actionCol1definition.get(0) instanceof ActionInsertFact));
        ActionInsertFact actionCol1aif0 = (ActionInsertFact)actionCol1definition.get(0);
        Assert.assertEquals((Object)"$t2", (Object)actionCol1aif0.getBoundName());
        Assert.assertEquals((Object)"Transaction", (Object)actionCol1aif0.getFactType());
        ActionFieldValue[] actionCol1aif0afvs = actionCol1aif0.getFieldValues();
        Assert.assertEquals((long)0L, (long)actionCol1aif0afvs.length);
        BRLActionColumn actionCol2 = (BRLActionColumn)dtable.getActionCols().get(2);
        Assert.assertEquals((Object)"Converted from ['Disable']", (Object)actionCol2.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol2.getChildColumns().size());
        List actionCol2definition = actionCol2.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol2definition.size());
        Assert.assertTrue((boolean)(actionCol2definition.get(0) instanceof ActionSetField));
        ActionSetField actionCol2asf0 = (ActionSetField)actionCol2definition.get(0);
        Assert.assertEquals((Object)"$t2", (Object)actionCol2asf0.getVariable());
        ActionFieldValue[] actionCol2asf0afvs = actionCol2asf0.getFieldValues();
        Assert.assertEquals((long)1L, (long)actionCol2asf0afvs.length);
        ActionFieldValue actionCol2asf0afv0 = actionCol2asf0afvs[0];
        Assert.assertEquals((Object)"enabled", (Object)actionCol2asf0afv0.getField());
        Assert.assertEquals((Object)"param3", (Object)actionCol2asf0afv0.getValue());
        Assert.assertEquals((long)7L, (long)actionCol2asf0afv0.getNature());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol2asf0afv0.getType());
        Assert.assertEquals((long)1L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "asd", false, true, false, false}, (List)dtable.getData().get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyCells() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("EmptySpreadsheetCells.xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"ExceptionPrivateCar", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)20L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(3) instanceof AttributeCol52));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(7) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(8) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(9) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(10) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(11) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(12) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(13) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(14) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(15) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(16) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(17) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(18) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(19) instanceof BRLActionVariableColumn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void correctMergedConditionColumnHeaders() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Vehicle", "this", "org.test.Vehicle", "this");
        this.addModelField("org.test.Vehicle", "subRTO", String.class.getName(), "String");
        this.addModelField("org.test.Vehicle", "manufacturer", String.class.getName(), "String");
        this.addModelField("org.test.Vehicle", "model", String.class.getName(), "String");
        this.addModelField("org.test.Vehicle", "vehicleSegment", String.class.getName(), "String");
        this.addModelField("org.test.Vehicle", "vehicleAge", Integer.class.getName(), "Integer");
        this.addModelField("org.test.Vehicle", "discount", Double.class.getName(), "Double");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("RHBPMS-856 (Merged condition columns).xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"VehiclePremiumDiscount", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)9L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(7) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(8) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['RTO', 'Manufacturer', 'Model', 'Segment', 'Age Min', 'Age Max']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)6L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)6L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"subRTO", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc0.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc1 = (SingleFieldConstraint)conditionCol0fp.getConstraint(1);
        Assert.assertEquals((Object)"manufacturer", (Object)conditionCol0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc1.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc2 = (SingleFieldConstraint)conditionCol0fp.getConstraint(2);
        Assert.assertEquals((Object)"model", (Object)conditionCol0fpsfc2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc2.getOperator());
        Assert.assertEquals((Object)"param3", (Object)conditionCol0fpsfc2.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc2.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc2.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(3) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc3 = (SingleFieldConstraint)conditionCol0fp.getConstraint(3);
        Assert.assertEquals((Object)"vehicleSegment", (Object)conditionCol0fpsfc3.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc3.getOperator());
        Assert.assertEquals((Object)"param4", (Object)conditionCol0fpsfc3.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc3.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc3.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(4) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc4 = (SingleFieldConstraint)conditionCol0fp.getConstraint(4);
        Assert.assertEquals((Object)"vehicleAge", (Object)conditionCol0fpsfc4.getFieldName());
        Assert.assertEquals((Object)"<=", (Object)conditionCol0fpsfc4.getOperator());
        Assert.assertEquals((Object)"param5", (Object)conditionCol0fpsfc4.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc4.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc4.getFieldType());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(5) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc5 = (SingleFieldConstraint)conditionCol0fp.getConstraint(5);
        Assert.assertEquals((Object)"vehicleAge", (Object)conditionCol0fpsfc5.getFieldName());
        Assert.assertEquals((Object)">", (Object)conditionCol0fpsfc5.getOperator());
        Assert.assertEquals((Object)"param6", (Object)conditionCol0fpsfc5.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc5.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc5.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"RTO", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"subRTO", (Object)conditionCol0param0.getFactField());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"Manufacturer", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param1.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0param1.getFactType());
        Assert.assertEquals((Object)"manufacturer", (Object)conditionCol0param1.getFactField());
        BRLConditionVariableColumn conditionCol0param2 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(2);
        Assert.assertEquals((Object)"param3", (Object)conditionCol0param2.getVarName());
        Assert.assertEquals((Object)"Model", (Object)conditionCol0param2.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param2.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0param2.getFactType());
        Assert.assertEquals((Object)"model", (Object)conditionCol0param2.getFactField());
        BRLConditionVariableColumn conditionCol0param3 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(3);
        Assert.assertEquals((Object)"param4", (Object)conditionCol0param3.getVarName());
        Assert.assertEquals((Object)"Segment", (Object)conditionCol0param3.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param3.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0param3.getFactType());
        Assert.assertEquals((Object)"vehicleSegment", (Object)conditionCol0param3.getFactField());
        BRLConditionVariableColumn conditionCol0param4 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(4);
        Assert.assertEquals((Object)"param5", (Object)conditionCol0param4.getVarName());
        Assert.assertEquals((Object)"Age Min", (Object)conditionCol0param4.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param4.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0param4.getFactType());
        Assert.assertEquals((Object)"vehicleAge", (Object)conditionCol0param4.getFactField());
        BRLConditionVariableColumn conditionCol0param5 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(5);
        Assert.assertEquals((Object)"param6", (Object)conditionCol0param5.getVarName());
        Assert.assertEquals((Object)"Age Max", (Object)conditionCol0param5.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param5.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)conditionCol0param5.getFactType());
        Assert.assertEquals((Object)"vehicleAge", (Object)conditionCol0param5.getFactField());
        Assert.assertEquals((long)1L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Discount(%)']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof ActionSetField));
        ActionSetField actionCol0asf0 = (ActionSetField)actionCol0definition.get(0);
        Assert.assertEquals((Object)"v", (Object)actionCol0asf0.getVariable());
        ActionFieldValue[] actionCol0asf0afvs = actionCol0asf0.getFieldValues();
        Assert.assertEquals((long)1L, (long)actionCol0asf0afvs.length);
        ActionFieldValue actionCol0asf0afv0 = actionCol0asf0afvs[0];
        Assert.assertEquals((Object)"discount", (Object)actionCol0asf0afv0.getField());
        Assert.assertEquals((Object)"param7", (Object)actionCol0asf0afv0.getValue());
        Assert.assertEquals((long)7L, (long)actionCol0asf0afv0.getNature());
        Assert.assertEquals((Object)"Double", (Object)actionCol0asf0afv0.getType());
        BRLActionVariableColumn actionCol0param0 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param7", (Object)actionCol0param0.getVarName());
        Assert.assertEquals((Object)"Discount(%)", (Object)actionCol0param0.getHeader());
        Assert.assertEquals((Object)"Double", (Object)actionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Vehicle", (Object)actionCol0param0.getFactType());
        Assert.assertEquals((Object)"discount", (Object)actionCol0param0.getFactField());
        Assert.assertEquals((long)4L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "1", "ALL", "XYZ", "EL", "HighEnd", 1, 0, 1.75}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "2", "ALL", "XYZ", "EL", "HighEnd", 5, 1, 2.0}, (List)dtable.getData().get(1)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{3, "3", "ALL", "XYZ", "EL", "HighEnd", 7, 5, 2.0}, (List)dtable.getData().get(2)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{4, "4", "ALL", "XYZ", "EL", "HighEnd", 10, 7, 1.0}, (List)dtable.getData().get(3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void conversionWithEnumerationsInCells() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Message", "this", "org.test.Message", "this");
        this.addModelField("org.test.Message", "status", Integer.class.getName(), "Integer");
        this.addModelField("org.test.Message", "message", String.class.getName(), "String");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("RHBRMS-2055 (Decision table with enums).xls");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)3L, (long)result.getMessages().size());
        Assert.assertTrue((boolean)((ConversionMessage)result.getMessages().get(0)).getMessage().contains("C11"));
        Assert.assertTrue((boolean)((ConversionMessage)result.getMessages().get(1)).getMessage().contains("C12"));
        Assert.assertTrue((boolean)((ConversionMessage)result.getMessages().get(2)).getMessage().contains("F11"));
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"HelloWorld1", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)6L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Status']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Message", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)1L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"status", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc0.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Status", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"status", (Object)conditionCol0param0.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Print out message?']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl0 = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"System.out.println(m.getMessage());", (Object)actionCol0ffl0.getText());
        BRLActionColumn actionCol1 = (BRLActionColumn)dtable.getActionCols().get(1);
        Assert.assertEquals((Object)"Converted from ['Set message', 'Set status']", (Object)actionCol1.getHeader());
        Assert.assertEquals((long)2L, (long)actionCol1.getChildColumns().size());
        List actionCol1definition = actionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol1definition.size());
        Assert.assertTrue((boolean)(actionCol1definition.get(0) instanceof ActionSetField));
        ActionSetField actionCol1asf0 = (ActionSetField)actionCol1definition.get(0);
        Assert.assertEquals((Object)"m", (Object)actionCol1asf0.getVariable());
        ActionFieldValue[] actionCol1asf0afvs = actionCol1asf0.getFieldValues();
        Assert.assertEquals((long)2L, (long)actionCol1asf0afvs.length);
        ActionFieldValue actionCol1asf0afv0 = actionCol1asf0afvs[0];
        Assert.assertEquals((Object)"message", (Object)actionCol1asf0afv0.getField());
        Assert.assertEquals((Object)"param2", (Object)actionCol1asf0afv0.getValue());
        Assert.assertEquals((long)7L, (long)actionCol1asf0afv0.getNature());
        Assert.assertEquals((Object)"String", (Object)actionCol1asf0afv0.getType());
        ActionFieldValue actionCol1asf0afv1 = actionCol1asf0afvs[1];
        Assert.assertEquals((Object)"status", (Object)actionCol1asf0afv1.getField());
        Assert.assertEquals((Object)"param3", (Object)actionCol1asf0afv1.getValue());
        Assert.assertEquals((long)7L, (long)actionCol1asf0afv1.getNature());
        Assert.assertEquals((Object)"Integer", (Object)actionCol1asf0afv1.getType());
        BRLActionVariableColumn actionCol0param0 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"", (Object)actionCol0param0.getVarName());
        Assert.assertEquals((Object)"Print out message?", (Object)actionCol0param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol0param0.getFieldType());
        Assert.assertNull((Object)actionCol0param0.getFactType());
        Assert.assertNull((Object)actionCol0param0.getFactField());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionVariableColumn actionCol1param0 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param2", (Object)actionCol1param0.getVarName());
        Assert.assertEquals((Object)"Set message", (Object)actionCol1param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)actionCol1param0.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)actionCol1param0.getFactType());
        Assert.assertEquals((Object)"message", (Object)actionCol1param0.getFactField());
        BRLActionVariableColumn actionCol1param1 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(1);
        Assert.assertEquals((Object)"param3", (Object)actionCol1param1.getVarName());
        Assert.assertEquals((Object)"Set status", (Object)actionCol1param1.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)actionCol1param1.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)actionCol1param1.getFactType());
        Assert.assertEquals((Object)"status", (Object)actionCol1param1.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Hello World", null, false, "Goodbye cruel world", null}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Goodbye", null, false, "", null}, (List)dtable.getData().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void conversionWithRetract() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Employee", "this", "org.test.Employee", "this");
        this.addModelField("org.test.Employee", "yearsOfService", Integer.class.getName(), "Integer");
        this.addModelField("org.test.Employee", "name", String.class.getName(), "String");
        this.addModelField("org.test.Employee", "bigAbsence", Boolean.class.getName(), "Boolean");
        this.addModelField("org.test.Bonus", "this", "org.test.Bonus", "this");
        this.addModelField("org.test.Bonus", "amount", Double.class.getName(), "Double");
        this.addModelField("org.test.Bonus", "employee", "org.test.Employee", "Object");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("GUVNOR-2888.xlsx");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        Assert.assertEquals((long)1L, (long)result.getMessages().size());
        Assert.assertTrue((boolean)((ConversionMessage)result.getMessages().get(0)).getMessage().contains("I13"));
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"bonus_program", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)11L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(7) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(8) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(9) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(10) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)3L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Served between', 'Served between', 'Served more', 'absence']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)4L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Employee", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)4L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"yearsOfService", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)">=", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc0.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Served between", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Employee", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"yearsOfService", (Object)conditionCol0param0.getFactField());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc1 = (SingleFieldConstraint)conditionCol0fp.getConstraint(1);
        Assert.assertEquals((Object)"yearsOfService", (Object)conditionCol0fpsfc1.getFieldName());
        Assert.assertEquals((Object)"<", (Object)conditionCol0fpsfc1.getOperator());
        Assert.assertEquals((Object)"param2", (Object)conditionCol0fpsfc1.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc1.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc1.getFieldType());
        BRLConditionVariableColumn conditionCol0param1 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(1);
        Assert.assertEquals((Object)"param2", (Object)conditionCol0param1.getVarName());
        Assert.assertEquals((Object)"Served between", (Object)conditionCol0param1.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param1.getFieldType());
        Assert.assertEquals((Object)"Employee", (Object)conditionCol0param1.getFactType());
        Assert.assertEquals((Object)"yearsOfService", (Object)conditionCol0param1.getFactField());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc2 = (SingleFieldConstraint)conditionCol0fp.getConstraint(2);
        Assert.assertEquals((Object)"yearsOfService", (Object)conditionCol0fpsfc2.getFieldName());
        Assert.assertEquals((Object)">", (Object)conditionCol0fpsfc2.getOperator());
        Assert.assertEquals((Object)"param3", (Object)conditionCol0fpsfc2.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc2.getConstraintValueType());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0fpsfc2.getFieldType());
        BRLConditionVariableColumn conditionCol0param2 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(2);
        Assert.assertEquals((Object)"param3", (Object)conditionCol0param2.getVarName());
        Assert.assertEquals((Object)"Served more", (Object)conditionCol0param2.getHeader());
        Assert.assertEquals((Object)"Integer", (Object)conditionCol0param2.getFieldType());
        Assert.assertEquals((Object)"Employee", (Object)conditionCol0param2.getFactType());
        Assert.assertEquals((Object)"yearsOfService", (Object)conditionCol0param2.getFactField());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(3) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc3 = (SingleFieldConstraint)conditionCol0fp.getConstraint(3);
        Assert.assertEquals((Object)"bigAbsence", (Object)conditionCol0fpsfc3.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc3.getOperator());
        Assert.assertEquals((Object)"param4", (Object)conditionCol0fpsfc3.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc3.getConstraintValueType());
        Assert.assertEquals((Object)"Boolean", (Object)conditionCol0fpsfc3.getFieldType());
        BRLConditionVariableColumn conditionCol0param3 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(3);
        Assert.assertEquals((Object)"param4", (Object)conditionCol0param3.getVarName());
        Assert.assertEquals((Object)"absence", (Object)conditionCol0param3.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)conditionCol0param3.getFieldType());
        Assert.assertEquals((Object)"Employee", (Object)conditionCol0param3.getFactType());
        Assert.assertEquals((Object)"bigAbsence", (Object)conditionCol0param3.getFactField());
        Assert.assertTrue((boolean)(dtable.getConditions().get(1) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol1 = (BRLConditionColumn)dtable.getConditions().get(1);
        Assert.assertEquals((Object)"Converted from ['bonus for employee']", (Object)conditionCol1.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol1.getChildColumns().size());
        List conditionCol1definition = conditionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol1definition.size());
        Assert.assertTrue((boolean)(conditionCol1definition.get(0) instanceof FactPattern));
        FactPattern conditionCol1fp = (FactPattern)conditionCol1definition.get(0);
        Assert.assertEquals((Object)"Bonus", (Object)conditionCol1fp.getFactType());
        Assert.assertEquals((long)1L, (long)conditionCol1fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol1fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol1fpsfc0 = (SingleFieldConstraint)conditionCol1fp.getConstraint(0);
        Assert.assertEquals((Object)"employee", (Object)conditionCol1fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol1fpsfc0.getOperator());
        Assert.assertEquals((Object)"param5", (Object)conditionCol1fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol1fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Object", (Object)conditionCol1fpsfc0.getFieldType());
        BRLConditionVariableColumn conditionCol1param0 = (BRLConditionVariableColumn)conditionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param5", (Object)conditionCol1param0.getVarName());
        Assert.assertEquals((Object)"bonus for employee", (Object)conditionCol1param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol1param0.getFieldType());
        Assert.assertEquals((Object)"Bonus", (Object)conditionCol1param0.getFactType());
        Assert.assertEquals((Object)"employee", (Object)conditionCol1param0.getFactField());
        Assert.assertTrue((boolean)(dtable.getConditions().get(2) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol2 = (BRLConditionColumn)dtable.getConditions().get(2);
        Assert.assertEquals((Object)"Converted from ['no bonus for employee']", (Object)conditionCol2.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol2.getChildColumns().size());
        List conditionCol2definition = conditionCol2.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol2definition.size());
        Assert.assertTrue((boolean)(conditionCol2definition.get(0) instanceof CompositeFactPattern));
        CompositeFactPattern conditionCol2cfp = (CompositeFactPattern)conditionCol2definition.get(0);
        Assert.assertEquals((Object)"not", (Object)conditionCol2cfp.getType());
        Assert.assertEquals((long)1L, (long)conditionCol2cfp.getPatterns().length);
        Assert.assertTrue((boolean)(conditionCol2cfp.getPatterns()[0] instanceof FactPattern));
        FactPattern conditionCol2fp = (FactPattern)conditionCol2cfp.getPatterns()[0];
        Assert.assertEquals((Object)"Bonus", (Object)conditionCol2fp.getFactType());
        Assert.assertEquals((long)1L, (long)conditionCol2fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol2fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol2fpsfc0 = (SingleFieldConstraint)conditionCol2fp.getConstraint(0);
        Assert.assertEquals((Object)"employee", (Object)conditionCol2fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol2fpsfc0.getOperator());
        Assert.assertEquals((Object)"param6", (Object)conditionCol2fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol2fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"Object", (Object)conditionCol2fpsfc0.getFieldType());
        BRLConditionVariableColumn conditionCol2param0 = (BRLConditionVariableColumn)conditionCol2.getChildColumns().get(0);
        Assert.assertEquals((Object)"param6", (Object)conditionCol2param0.getVarName());
        Assert.assertEquals((Object)"no bonus for employee", (Object)conditionCol2param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)conditionCol2param0.getFieldType());
        Assert.assertEquals((Object)"Bonus", (Object)conditionCol2param0.getFactType());
        Assert.assertEquals((Object)"employee", (Object)conditionCol2param0.getFactField());
        Assert.assertEquals((long)3L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Inser bonus of amount']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl0 = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"Bonus $b = new Bonus(); $b.setAmount((double)@{param7}); $b.setEmployee($e); insert($b);", (Object)actionCol0ffl0.getText());
        BRLActionVariableColumn actionCol0param0 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param7", (Object)actionCol0param0.getVarName());
        Assert.assertEquals((Object)"Inser bonus of amount", (Object)actionCol0param0.getHeader());
        Assert.assertEquals((Object)"Object", (Object)actionCol0param0.getFieldType());
        BRLActionColumn actionCol1 = (BRLActionColumn)dtable.getActionCols().get(1);
        Assert.assertEquals((Object)"Converted from ['retract']", (Object)actionCol1.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol1.getChildColumns().size());
        List actionCol1definition = actionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol1definition.size());
        Assert.assertTrue((boolean)(actionCol1definition.get(0) instanceof ActionRetractFact));
        ActionRetractFact actionCol1arf = (ActionRetractFact)actionCol1definition.get(0);
        Assert.assertEquals((Object)"$bonus", (Object)actionCol1arf.getVariableName());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(1) instanceof BRLActionColumn));
        BRLActionVariableColumn actionCol1param0 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param8", (Object)actionCol1param0.getVarName());
        Assert.assertEquals((Object)"retract", (Object)actionCol1param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol1param0.getFieldType());
        BRLActionColumn actionCol2 = (BRLActionColumn)dtable.getActionCols().get(2);
        Assert.assertEquals((Object)"Converted from ['retract2']", (Object)actionCol2.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol2.getChildColumns().size());
        List actionCol2definition = actionCol2.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol2definition.size());
        Assert.assertTrue((boolean)(actionCol2definition.get(0) instanceof ActionRetractFact));
        ActionRetractFact actionCol2arf = (ActionRetractFact)actionCol2definition.get(0);
        Assert.assertEquals((Object)"$b", (Object)actionCol2arf.getVariableName());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(2) instanceof BRLActionColumn));
        BRLActionVariableColumn actionCol2param0 = (BRLActionVariableColumn)actionCol2.getChildColumns().get(0);
        Assert.assertEquals((Object)"", (Object)actionCol2param0.getVarName());
        Assert.assertEquals((Object)"retract2", (Object)actionCol2param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol2param0.getFieldType());
        Assert.assertEquals((long)4L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Lowest bonus", 0, 2, null, false, "", "$e", "400", false, false}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Middle bonus", 2, 6, null, false, "", "$e", "800", false, false}, (List)dtable.getData().get(1)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{3, "High bonus", null, null, 6, false, "", "", "1000", false, false}, (List)dtable.getData().get(2)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{4, "Big absence", null, null, null, true, "$e", "", "", true, true}, (List)dtable.getData().get(3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void conversionWithBigDecimals() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Message", "this", "org.test.Message", "this");
        this.addModelField("org.test.Message", "status", String.class.getName(), "String");
        this.addModelField("org.test.Message", "message", String.class.getName(), "String");
        this.addModelField("org.test.Message", "rate", BigDecimal.class.getName(), "BigDecimal");
        this.addModelField("org.test.Reply", "this", "org.test.Reply", "this");
        this.addModelField("org.test.Reply", "message", String.class.getName(), "String");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("RHBPMS-4737 (BigDecimal).xlsx");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        this.checkConversionWithBigMaths(result, listener, () -> "BigDecimal", () -> new BigDecimal("10.00"), () -> new BigDecimal("20.00"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void conversionWithBigDecimalsWithoutDMO() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("RHBPMS-4737 (No DMO).xlsx");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        this.checkConversionWithBigMaths(result, listener, () -> "Numeric", () -> new BigDecimal("10.00"), () -> new BigDecimal("20.00"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void conversionWithBigIntegers() {
        ConversionResult result = new ConversionResult();
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        this.addModelField("org.test.Message", "this", "org.test.Message", "this");
        this.addModelField("org.test.Message", "status", String.class.getName(), "String");
        this.addModelField("org.test.Message", "message", String.class.getName(), "String");
        this.addModelField("org.test.Message", "rate", BigDecimal.class.getName(), "BigInteger");
        this.addModelField("org.test.Reply", "this", "org.test.Reply", "this");
        this.addModelField("org.test.Reply", "message", String.class.getName(), "String");
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, this.dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("RHBPMS-4737 (BigInteger).xlsx");
        try {
            parser.parseFile(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.getMessage());
            }
        }
        this.checkConversionWithBigMaths(result, listener, () -> "BigInteger", () -> new BigInteger("10"), () -> new BigInteger("20"));
    }

    private void checkConversionWithBigMaths(ConversionResult result, GuidedDecisionTableGeneratorListener listener, Supplier<String> expectedDataType, Supplier<Object> expectedDataValueRow0, Supplier<Object> expectedDataValueRow1) {
        Assert.assertEquals((long)0L, (long)result.getMessages().size());
        List dtables = listener.getGuidedDecisionTables();
        Assert.assertNotNull((Object)dtables);
        Assert.assertEquals((long)1L, (long)dtables.size());
        GuidedDecisionTable52 dtable = (GuidedDecisionTable52)dtables.get(0);
        Assert.assertEquals((Object)"HelloWorld1", (Object)dtable.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)dtable.getTableFormat());
        List columns = dtable.getExpandedColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)8L, (long)columns.size());
        Assert.assertTrue((boolean)(columns.get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(columns.get(1) instanceof DescriptionCol52));
        Assert.assertTrue((boolean)(columns.get(2) instanceof BRLConditionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(3) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(4) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(5) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(6) instanceof BRLActionVariableColumn));
        Assert.assertTrue((boolean)(columns.get(7) instanceof BRLActionVariableColumn));
        Assert.assertEquals((long)1L, (long)dtable.getConditions().size());
        Assert.assertTrue((boolean)(dtable.getConditions().get(0) instanceof BRLConditionColumn));
        BRLConditionColumn conditionCol0 = (BRLConditionColumn)dtable.getConditions().get(0);
        Assert.assertEquals((Object)"Converted from ['Status']", (Object)conditionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)conditionCol0.getChildColumns().size());
        List conditionCol0definition = conditionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)conditionCol0definition.size());
        Assert.assertTrue((boolean)(conditionCol0definition.get(0) instanceof FactPattern));
        FactPattern conditionCol0fp = (FactPattern)conditionCol0definition.get(0);
        Assert.assertEquals((Object)"Message", (Object)conditionCol0fp.getFactType());
        Assert.assertEquals((long)1L, (long)conditionCol0fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(conditionCol0fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint conditionCol0fpsfc0 = (SingleFieldConstraint)conditionCol0fp.getConstraint(0);
        Assert.assertEquals((Object)"status", (Object)conditionCol0fpsfc0.getFieldName());
        Assert.assertEquals((Object)"==", (Object)conditionCol0fpsfc0.getOperator());
        Assert.assertEquals((Object)"param1", (Object)conditionCol0fpsfc0.getValue());
        Assert.assertEquals((long)7L, (long)conditionCol0fpsfc0.getConstraintValueType());
        Assert.assertEquals((Object)"String", (Object)conditionCol0fpsfc0.getFieldType());
        BRLConditionVariableColumn conditionCol0param0 = (BRLConditionVariableColumn)conditionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"param1", (Object)conditionCol0param0.getVarName());
        Assert.assertEquals((Object)"Status", (Object)conditionCol0param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)conditionCol0param0.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)conditionCol0param0.getFactType());
        Assert.assertEquals((Object)"status", (Object)conditionCol0param0.getFactField());
        Assert.assertEquals((long)3L, (long)dtable.getActionCols().size());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionColumn actionCol0 = (BRLActionColumn)dtable.getActionCols().get(0);
        Assert.assertEquals((Object)"Converted from ['Print out message?']", (Object)actionCol0.getHeader());
        Assert.assertEquals((long)1L, (long)actionCol0.getChildColumns().size());
        List actionCol0definition = actionCol0.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol0definition.size());
        Assert.assertTrue((boolean)(actionCol0definition.get(0) instanceof FreeFormLine));
        FreeFormLine actionCol0ffl0 = (FreeFormLine)actionCol0definition.get(0);
        Assert.assertEquals((Object)"System.out.println(m.getMessage());", (Object)actionCol0ffl0.getText());
        BRLActionColumn actionCol1 = (BRLActionColumn)dtable.getActionCols().get(1);
        Assert.assertEquals((Object)"Converted from ['Set message', 'Set status', 'Set rate']", (Object)actionCol1.getHeader());
        Assert.assertEquals((long)3L, (long)actionCol1.getChildColumns().size());
        List actionCol1definition = actionCol1.getDefinition();
        Assert.assertEquals((long)1L, (long)actionCol1definition.size());
        Assert.assertTrue((boolean)(actionCol1definition.get(0) instanceof ActionSetField));
        ActionSetField actionCol1asf0 = (ActionSetField)actionCol1definition.get(0);
        Assert.assertEquals((Object)"m", (Object)actionCol1asf0.getVariable());
        ActionFieldValue[] actionCol1asf0afvs = actionCol1asf0.getFieldValues();
        Assert.assertEquals((long)3L, (long)actionCol1asf0afvs.length);
        ActionFieldValue actionCol1asf0afv0 = actionCol1asf0afvs[0];
        Assert.assertEquals((Object)"message", (Object)actionCol1asf0afv0.getField());
        Assert.assertEquals((Object)"param2", (Object)actionCol1asf0afv0.getValue());
        Assert.assertEquals((long)7L, (long)actionCol1asf0afv0.getNature());
        Assert.assertEquals((Object)"String", (Object)actionCol1asf0afv0.getType());
        ActionFieldValue actionCol1asf0afv1 = actionCol1asf0afvs[1];
        Assert.assertEquals((Object)"status", (Object)actionCol1asf0afv1.getField());
        Assert.assertEquals((Object)"param3", (Object)actionCol1asf0afv1.getValue());
        Assert.assertEquals((long)7L, (long)actionCol1asf0afv1.getNature());
        Assert.assertEquals((Object)"String", (Object)actionCol1asf0afv1.getType());
        BRLActionVariableColumn actionCol0param0 = (BRLActionVariableColumn)actionCol0.getChildColumns().get(0);
        Assert.assertEquals((Object)"", (Object)actionCol0param0.getVarName());
        Assert.assertEquals((Object)"Print out message?", (Object)actionCol0param0.getHeader());
        Assert.assertEquals((Object)"Boolean", (Object)actionCol0param0.getFieldType());
        Assert.assertNull((Object)actionCol0param0.getFactType());
        Assert.assertNull((Object)actionCol0param0.getFactField());
        Assert.assertTrue((boolean)(dtable.getActionCols().get(0) instanceof BRLActionColumn));
        BRLActionVariableColumn actionCol1param0 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(0);
        Assert.assertEquals((Object)"param2", (Object)actionCol1param0.getVarName());
        Assert.assertEquals((Object)"Set message", (Object)actionCol1param0.getHeader());
        Assert.assertEquals((Object)"String", (Object)actionCol1param0.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)actionCol1param0.getFactType());
        Assert.assertEquals((Object)"message", (Object)actionCol1param0.getFactField());
        BRLActionVariableColumn actionCol1param1 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(1);
        Assert.assertEquals((Object)"param3", (Object)actionCol1param1.getVarName());
        Assert.assertEquals((Object)"Set status", (Object)actionCol1param1.getHeader());
        Assert.assertEquals((Object)"String", (Object)actionCol1param1.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)actionCol1param1.getFactType());
        Assert.assertEquals((Object)"status", (Object)actionCol1param1.getFactField());
        BRLActionVariableColumn actionCol1param2 = (BRLActionVariableColumn)actionCol1.getChildColumns().get(2);
        Assert.assertEquals((Object)"param4", (Object)actionCol1param2.getVarName());
        Assert.assertEquals((Object)"Set rate", (Object)actionCol1param2.getHeader());
        Assert.assertEquals((Object)expectedDataType.get(), (Object)actionCol1param2.getFieldType());
        Assert.assertEquals((Object)"Message", (Object)actionCol1param2.getFactType());
        Assert.assertEquals((Object)"rate", (Object)actionCol1param2.getFactField());
        Assert.assertEquals((long)2L, (long)dtable.getData().size());
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{1, "Hello World", "Message.HELLO", false, "Goodbye cruel world", "Message.GOODBYE", expectedDataValueRow0.get(), "m"}, (List)dtable.getData().get(0)));
        Assert.assertTrue((boolean)this.isRowEquivalent(new Object[]{2, "Goodbye", "Message.GOODBYE", false, "", "", expectedDataValueRow1.get(), "m"}, (List)dtable.getData().get(1)));
    }

    private boolean isRowEquivalent(Object[] expected, List<DTCellValue52> actual) {
        if (expected.length != actual.size()) {
            return false;
        }
        block12: for (int i = 0; i < expected.length; ++i) {
            DTCellValue52 dcv = actual.get(i);
            switch (dcv.getDataType()) {
                case NUMERIC: {
                    BigDecimal numeric = (BigDecimal)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numeric)) continue block12;
                    return false;
                }
                case NUMERIC_BIGDECIMAL: {
                    BigDecimal numericBigDecimal = (BigDecimal)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericBigDecimal)) continue block12;
                    return false;
                }
                case NUMERIC_BIGINTEGER: {
                    BigInteger numericBigInteger = (BigInteger)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericBigInteger)) continue block12;
                    return false;
                }
                case NUMERIC_BYTE: {
                    Byte numericByte = (Byte)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericByte)) continue block12;
                    return false;
                }
                case NUMERIC_DOUBLE: {
                    Double numericDouble = (Double)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericDouble)) continue block12;
                    return false;
                }
                case NUMERIC_FLOAT: {
                    Float numericFloat = (Float)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericFloat)) continue block12;
                    return false;
                }
                case NUMERIC_INTEGER: {
                    Integer numericInteger = (Integer)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericInteger)) continue block12;
                    return false;
                }
                case NUMERIC_LONG: {
                    Long numericLong = (Long)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericLong)) continue block12;
                    return false;
                }
                case NUMERIC_SHORT: {
                    Short numericShort = (Short)dcv.getNumericValue();
                    if (this.assertValues(expected[i], numericShort)) continue block12;
                    return false;
                }
                case BOOLEAN: {
                    if (this.assertValues(expected[i], dcv.getBooleanValue())) continue block12;
                    return false;
                }
                default: {
                    if (this.assertValues(expected[i], dcv.getStringValue())) continue block12;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean assertValues(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return expected.equals(actual);
    }

    private void addModelField(String factName, String fieldName, String clazz, String type) {
        ModelField[] modelFields = new ModelField[]{new ModelField(fieldName, clazz, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type)};
        if (this.packageModelFields.containsKey(factName)) {
            ArrayList<Object> existingModelFields = new ArrayList<Object>(Arrays.asList((Object[])this.packageModelFields.get(factName)));
            existingModelFields.add(modelFields[0]);
            modelFields = existingModelFields.toArray(modelFields);
        }
        this.packageModelFields.put(factName, modelFields);
    }
}

