/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.drools.workbench.screens.dtablexls.backend.server.indexing.TestDecisionTableXLSFileIndexer;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexDecisionTableXLSAttributeNameAndValueTest
extends BaseIndexingTest<DecisionTableXLSResourceTypeDefinition> {
    @Test
    public void testIndexDecisionTableXLSAttributeNameAndValue() throws IOException, InterruptedException {
        Path path1 = this.loadXLSFile(this.basePath, "dtable1.xls");
        Path path2 = this.loadXLSFile(this.basePath, "dtable2.xls");
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        ValueSharedPartIndexTerm valTerm = new ValueSharedPartIndexTerm("myruleflowgroup", PartType.RULEFLOW_GROUP);
        query.add((Query)new TermQuery(new Term(valTerm.getTerm(), valTerm.getValue())), BooleanClause.Occur.MUST);
        this.searchFor(index, (Query)query.build(), 1, new Path[]{path1});
    }

    protected TestIndexer getIndexer() {
        return new TestDecisionTableXLSFileIndexer();
    }

    protected DecisionTableXLSResourceTypeDefinition getResourceTypeDefinition() {
        return new DecisionTableXLSResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private Path loadXLSFile(Path basePath, String fileName) throws IOException {
        Path path = basePath.resolve(fileName);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        OutputStream os = this.ioService().newOutputStream(path, new OpenOption[0]);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        os.close();
        return path;
    }
}

