/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.indexing;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.dtablexls.backend.server.indexing.TestDecisionTableXLSFileIndexer;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexDecisionTableXLSInvalidDrlTest
extends BaseIndexingTest<DecisionTableXLSResourceTypeDefinition> {
    @Test
    public void testIndexDecisionTableXLSInvalidDrl() throws IOException, InterruptedException {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Appender mockAppender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)mockAppender.getName()).thenReturn((Object)"MOCK");
        root.addAppender(mockAppender);
        this.loadXLSFile(this.basePath, "bz1269366.xls");
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueSharedPartIndexTerm("myRuleFlowGroup", PartType.RULEFLOW_GROUP)).build();
        this.searchFor(index, query, 0, new Path[0]);
        ((Appender)Mockito.verify((Object)mockAppender)).doAppend(Matchers.argThat((Matcher)new ArgumentMatcher<ILoggingEvent>(){

            public boolean matches(Object argument) {
                return ((ILoggingEvent)argument).getMessage().startsWith("Unable to parse DRL");
            }
        }));
    }

    protected TestIndexer getIndexer() {
        return new TestDecisionTableXLSFileIndexer();
    }

    protected DecisionTableXLSResourceTypeDefinition getResourceTypeDefinition() {
        return new DecisionTableXLSResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private Path loadXLSFile(Path basePath, String fileName) throws IOException {
        Path path = basePath.resolve(fileName);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        OutputStream os = this.ioService().newOutputStream(path, new OpenOption[0]);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        os.close();
        return path;
    }
}

