/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.DTCellValueUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableLHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableRHSBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderDirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderIndirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.LiteralValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class GuidedDecisionTablePopulater {
    private static final String UNDEFINED = "(undefined)";
    private final GuidedDecisionTable52 dtable;
    private final List<GuidedDecisionTableSourceBuilder> sourceBuilders;
    private final ConversionResult conversionResult;
    private final PackageDataModelOracle dmo;
    private final int ruleRowStartIndex;
    private final int ruleColumnStartIndex;
    private final ParameterUtilities parameterUtilities;

    public GuidedDecisionTablePopulater(GuidedDecisionTable52 dtable, List<GuidedDecisionTableSourceBuilder> sourceBuilders, ConversionResult conversionResult, PackageDataModelOracle dmo, int ruleRowStartIndex, int ruleColumnStartIndex) {
        this.dtable = dtable;
        this.sourceBuilders = sourceBuilders;
        this.conversionResult = conversionResult;
        this.dmo = dmo;
        this.ruleRowStartIndex = ruleRowStartIndex;
        this.ruleColumnStartIndex = ruleColumnStartIndex;
        this.parameterUtilities = new ParameterUtilities();
    }

    public void populate() {
        int maxRowCount = this.getMaxRowCount();
        this.processDirectSourceBuilders(maxRowCount);
        this.processIndirectSourceBuilders(maxRowCount);
    }

    private int getMaxRowCount() {
        int maxRowCount = 0;
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            maxRowCount = Math.max(maxRowCount, sb.getRowCount());
        }
        return maxRowCount;
    }

    private void processDirectSourceBuilders(int maxRowCount) {
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableSourceBuilderDirect)) continue;
            ((GuidedDecisionTableSourceBuilderDirect)sb).populateDecisionTable(this.dtable, maxRowCount);
        }
    }

    private void processIndirectSourceBuilders(int maxRowCount) {
        this.addIndirectSourceBuildersColumns();
        this.addIndirectSourceBuildersData(maxRowCount);
    }

    private void addIndirectSourceBuildersColumns() {
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        ArrayList<GuidedDecisionTableLHSBuilder> lhsBuilders = new ArrayList<GuidedDecisionTableLHSBuilder>();
        ArrayList<GuidedDecisionTableRHSBuilder> rhsBuilders = new ArrayList<GuidedDecisionTableRHSBuilder>();
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (sb instanceof GuidedDecisionTableSourceBuilderIndirect) {
                for (BRLVariableColumn variableColumn : ((GuidedDecisionTableSourceBuilderIndirect)sb).getVariableColumns()) {
                    variableColumns.add(variableColumn);
                }
            }
            if (sb instanceof GuidedDecisionTableLHSBuilder) {
                lhsBuilders.add((GuidedDecisionTableLHSBuilder)sb);
            }
            if (!(sb instanceof GuidedDecisionTableRHSBuilder)) continue;
            rhsBuilders.add((GuidedDecisionTableRHSBuilder)sb);
        }
        int previousPatternCount = 0;
        for (int i = 0; i < lhsBuilders.size(); ++i) {
            String rule = this.assembleRuleDRL(i, lhsBuilders, Collections.emptyList());
            RuleModel rm = RuleModelDRLPersistenceImpl.getInstance().unmarshal(rule, Collections.emptyList(), this.dmo);
            if (Objects.nonNull(rm.lhs)) {
                Map templateKeys;
                IPattern pattern;
                int iPattern;
                HashMap patternTemplateKeys = new HashMap();
                BRLConditionColumn column = new BRLConditionColumn();
                this.dtable.getConditions().add(column);
                boolean allPatternsHaveTemplateKeys = true;
                for (iPattern = previousPatternCount; iPattern < rm.lhs.length; ++iPattern) {
                    pattern = rm.lhs[iPattern];
                    templateKeys = new HashMap();
                    RuleModelVisitor rmv = new RuleModelVisitor(templateKeys);
                    rmv.visit((Object)pattern);
                    patternTemplateKeys.put(pattern, templateKeys);
                    if (!templateKeys.isEmpty()) continue;
                    allPatternsHaveTemplateKeys = false;
                }
                if (allPatternsHaveTemplateKeys) {
                    for (iPattern = previousPatternCount; iPattern < rm.lhs.length; ++iPattern) {
                        pattern = rm.lhs[iPattern];
                        column.getDefinition().add(pattern);
                    }
                } else {
                    FreeFormLine ffl = new FreeFormLine();
                    ffl.setText(((GuidedDecisionTableLHSBuilder)lhsBuilders.get(i)).getResult());
                    column.setDefinition(Collections.singletonList(ffl));
                }
                for (iPattern = previousPatternCount; iPattern < rm.lhs.length; ++iPattern) {
                    pattern = rm.lhs[iPattern];
                    templateKeys = (Map)patternTemplateKeys.get(pattern);
                    if (!Objects.nonNull(templateKeys)) continue;
                    ArrayList ivs = new ArrayList(templateKeys.keySet());
                    for (BRLVariableColumn variableColumn : variableColumns) {
                        Iterator ivsIts = ivs.iterator();
                        while (ivsIts.hasNext()) {
                            InterpolationVariable iv = (InterpolationVariable)ivsIts.next();
                            if (!Objects.equals(iv.getVarName(), variableColumn.getVarName())) continue;
                            BRLConditionVariableColumn source = (BRLConditionVariableColumn)variableColumn;
                            BRLConditionVariableColumn target = this.makeBRLConditionVariableColumn(source, iv);
                            column.getChildColumns().add(target);
                            ivsIts.remove();
                        }
                    }
                }
                if (column.getChildColumns().isEmpty()) {
                    this.setZeroParameterConditionColumnHeader(column, variableColumns);
                } else {
                    this.setCompositeColumnHeader(column);
                }
            }
            previousPatternCount = rm.lhs.length;
        }
        String rule = this.assembleRuleDRL(lhsBuilders.size() - 1, lhsBuilders, rhsBuilders);
        RuleModel rm = RuleModelDRLPersistenceImpl.getInstance().unmarshal(rule, Collections.emptyList(), this.dmo, true);
        if (rm.rhs != null) {
            for (IAction action : rm.rhs) {
                BRLActionColumn column = new BRLActionColumn();
                column.getDefinition().add(action);
                this.dtable.getActionCols().add(column);
                if (action instanceof ActionRetractFact) {
                    ActionRetractFact arf = (ActionRetractFact)action;
                    this.createActionRetractFactChildColumns(arf, column, variableColumns);
                } else {
                    this.createRHSChildColumns(rm, action, column, variableColumns);
                }
                if (column.getChildColumns().isEmpty()) {
                    this.setZeroParameterActionColumnHeader(column, variableColumns);
                    continue;
                }
                this.setCompositeColumnHeader(column);
            }
        }
    }

    private String assembleRuleDRL(int currentLHSBuilderIndex, List<GuidedDecisionTableLHSBuilder> lhsBuilders, List<GuidedDecisionTableRHSBuilder> rhsBuilders) {
        StringBuilder rule = new StringBuilder();
        if (this.dmo.getPackageName() != null && !this.dmo.getPackageName().isEmpty()) {
            rule.append("package ").append(this.dmo.getPackageName()).append("\n");
        }
        rule.append("rule 'temp' \n").append("when \n");
        for (int lhsBuilderIndex = 0; lhsBuilderIndex <= currentLHSBuilderIndex; ++lhsBuilderIndex) {
            GuidedDecisionTableLHSBuilder guidedDecisionTableLHSBuilder = lhsBuilders.get(lhsBuilderIndex);
            rule.append(guidedDecisionTableLHSBuilder.getResult());
        }
        rule.append("\nthen \n");
        for (GuidedDecisionTableSourceBuilder guidedDecisionTableSourceBuilder : rhsBuilders) {
            rule.append(guidedDecisionTableSourceBuilder.getResult());
        }
        rule.append("end");
        return rule.toString();
    }

    private void createActionRetractFactChildColumns(ActionRetractFact arf, BRLActionColumn column, List<BRLVariableColumn> variableColumns) {
        String var = arf.getVariableName();
        Set<String> templateKeys = this.parameterUtilities.extractTemplateKeys(var);
        String templateKey = templateKeys.isEmpty() ? var : templateKeys.iterator().next();
        List<ParameterizedValueBuilder> valueBuilders = this.getOrderedValueBuilders();
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!templateKey.equals(variableColumn.getVarName())) continue;
            BRLActionVariableColumn source = (BRLActionVariableColumn)variableColumn;
            BRLActionVariableColumn target = new BRLActionVariableColumn(templateKey, "Boolean");
            target.setHeader(source.getHeader());
            target.setHideColumn(source.isHideColumn());
            column.getChildColumns().add(target);
            block1: for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
                if (!(sb instanceof GuidedDecisionTableRHSBuilder)) continue;
                GuidedDecisionTableRHSBuilder rhs = (GuidedDecisionTableRHSBuilder)sb;
                for (ParameterizedValueBuilder pvb : rhs.getValueBuilders().values()) {
                    if (!pvb.getParameters().contains(templateKey)) continue;
                    Optional<Object> firstBinding = Optional.empty();
                    int pvbIndex = pvb.getParameters().indexOf(templateKey);
                    List<List<DTCellValue52>> pvbData = pvb.getColumnData();
                    for (int iRowIndex = 0; iRowIndex < pvbData.size(); ++iRowIndex) {
                        List<DTCellValue52> pvbRow = pvbData.get(iRowIndex);
                        String binding = pvbRow.get(pvbIndex).getStringValue();
                        if (binding == null || binding.isEmpty() || arf.getVariableName().equals(binding)) continue;
                        int _rowIndex = this.ruleRowStartIndex + iRowIndex + 1;
                        int _columnIndex = this.ruleColumnStartIndex + valueBuilders.indexOf(pvb) + 1;
                        if (firstBinding.isPresent()) {
                            this.addConversionMessage("Removing Retract binding for " + binding + ". See previous conversion messages for details.", _rowIndex, _columnIndex);
                            pvbRow.get(pvbIndex).clearValues();
                            continue;
                        }
                        this.addConversionMessage("Setting Retract to use first binding, " + binding + ". Others will be removed.", _rowIndex, _columnIndex);
                        arf.setVariableName(binding);
                        pvbRow.get(pvbIndex).setBooleanValue(Boolean.valueOf(true));
                        firstBinding = Optional.of(binding);
                    }
                    continue block1;
                }
            }
        }
    }

    private void createRHSChildColumns(RuleModel rm, IAction action, BRLActionColumn column, List<BRLVariableColumn> variableColumns) {
        HashMap templateKeys = new HashMap();
        RuleModelVisitor rmv = new RuleModelVisitor(rm.lhs, templateKeys);
        rmv.visit((Object)action);
        ArrayList ivs = new ArrayList(templateKeys.keySet());
        for (BRLVariableColumn variableColumn : variableColumns) {
            Iterator ivsIts = ivs.iterator();
            while (ivsIts.hasNext()) {
                InterpolationVariable iv = (InterpolationVariable)ivsIts.next();
                if (!iv.getVarName().equals(variableColumn.getVarName())) continue;
                BRLActionVariableColumn source = (BRLActionVariableColumn)variableColumn;
                BRLActionVariableColumn target = this.makeBRLActionVariableColumn(source, iv);
                column.getChildColumns().add(target);
                ivsIts.remove();
            }
        }
    }

    private BRLConditionVariableColumn makeBRLConditionVariableColumn(BRLConditionVariableColumn source, InterpolationVariable iv) {
        String varName = source.getVarName();
        String dataType = iv.getDataType() == null ? "Object" : iv.getDataType();
        String factType = iv.getFactType();
        String factField = iv.getFactField();
        BRLConditionVariableColumn target = factType != null && factField != null ? new BRLConditionVariableColumn(varName, dataType, factType, factField) : new BRLConditionVariableColumn(varName, dataType);
        target.setHeader(source.getHeader());
        return target;
    }

    private void setZeroParameterConditionColumnHeader(BRLConditionColumn column, List<BRLVariableColumn> allVariableColumns) {
        BRLConditionVariableColumn source = this.findZeroParameterSourceConditionColumn(allVariableColumns);
        BRLConditionVariableColumn target = new BRLConditionVariableColumn("", "Boolean");
        column.getChildColumns().add(target);
        this.setZeroParameterColumnHeader((BRLColumn)column, (BaseColumn)source, (BaseColumn)target);
    }

    private BRLConditionVariableColumn findZeroParameterSourceConditionColumn(List<BRLVariableColumn> variableColumns) {
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!(variableColumn instanceof BRLConditionVariableColumn) || !variableColumn.getVarName().equals("")) continue;
            return (BRLConditionVariableColumn)variableColumn;
        }
        return null;
    }

    private void setCompositeColumnHeader(BRLConditionColumn column) {
        BRLConditionVariableColumn variableColumn;
        int i;
        List columnVariableColumns = column.getChildColumns();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> variableColumnHeaders = new ArrayList<String>();
        sb.append("Converted from [");
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLConditionVariableColumn)columnVariableColumns.get(i);
            String header = variableColumn.getHeader();
            variableColumnHeaders.add(header);
            sb.append("'").append(header).append("'");
            sb.append(i < columnVariableColumns.size() - 1 ? ", " : "");
        }
        sb.append("]");
        column.setHeader(sb.toString());
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLConditionVariableColumn)columnVariableColumns.get(i);
            variableColumn.setHeader((String)variableColumnHeaders.get(i));
        }
    }

    private BRLActionVariableColumn makeBRLActionVariableColumn(BRLActionVariableColumn source, InterpolationVariable iv) {
        String varName = source.getVarName();
        String dataType = iv.getDataType() == null ? "Object" : iv.getDataType();
        String factType = iv.getFactType();
        String factField = iv.getFactField();
        BRLActionVariableColumn target = factType != null && factField != null ? new BRLActionVariableColumn(varName, dataType, factType, factField) : new BRLActionVariableColumn(varName, dataType);
        target.setHeader(source.getHeader());
        return target;
    }

    private void setZeroParameterActionColumnHeader(BRLActionColumn column, List<BRLVariableColumn> allVariableColumns) {
        BRLActionVariableColumn source = this.findZeroParameterSourceActionColumn(allVariableColumns);
        BRLActionVariableColumn target = new BRLActionVariableColumn("", "Boolean");
        column.getChildColumns().add(target);
        this.setZeroParameterColumnHeader((BRLColumn)column, (BaseColumn)source, (BaseColumn)target);
    }

    private void setCompositeColumnHeader(BRLActionColumn column) {
        BRLActionVariableColumn variableColumn;
        int i;
        List columnVariableColumns = column.getChildColumns();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> variableColumnHeaders = new ArrayList<String>();
        sb.append("Converted from [");
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLActionVariableColumn)columnVariableColumns.get(i);
            String header = variableColumn.getHeader();
            variableColumnHeaders.add(header);
            sb.append("'").append(header).append("'");
            sb.append(i < columnVariableColumns.size() - 1 ? ", " : "");
        }
        sb.append("]");
        column.setHeader(sb.toString());
        for (i = 0; i < columnVariableColumns.size(); ++i) {
            variableColumn = (BRLActionVariableColumn)columnVariableColumns.get(i);
            variableColumn.setHeader((String)variableColumnHeaders.get(i));
        }
    }

    private BRLActionVariableColumn findZeroParameterSourceActionColumn(List<BRLVariableColumn> variableColumns) {
        for (BRLVariableColumn variableColumn : variableColumns) {
            if (!(variableColumn instanceof BRLActionVariableColumn) || !variableColumn.getVarName().equals("")) continue;
            return (BRLActionVariableColumn)variableColumn;
        }
        return null;
    }

    private void setZeroParameterColumnHeader(BRLColumn column, BaseColumn source, BaseColumn target) {
        StringBuilder sb = new StringBuilder();
        String header = source == null ? UNDEFINED : source.getHeader();
        sb.append(source == null ? "" : "Converted from ['");
        sb.append(header);
        sb.append(source == null ? "" : "']");
        column.setHeader(sb.toString());
        target.setHeader(header);
    }

    private void addIndirectSourceBuildersData(int maxRowCount) {
        List<ParameterizedValueBuilder> valueBuilders = this.getOrderedValueBuilders();
        List allColumns = this.dtable.getExpandedColumns();
        for (int iColIndex = 0; iColIndex < allColumns.size(); ++iColIndex) {
            BaseColumn column = (BaseColumn)allColumns.get(iColIndex);
            if (!(column instanceof BRLVariableColumn)) continue;
            String varName = ((BRLVariableColumn)column).getVarName();
            String varDataType = ((BRLVariableColumn)column).getFieldType();
            this.assertDecisionTableData(varName, varDataType, valueBuilders, maxRowCount);
        }
    }

    private List<ParameterizedValueBuilder> getOrderedValueBuilders() {
        ArrayList<ParameterizedValueBuilder> valueBuilders = new ArrayList<ParameterizedValueBuilder>();
        for (GuidedDecisionTableSourceBuilder sb : this.sourceBuilders) {
            if (!(sb instanceof GuidedDecisionTableSourceBuilderIndirect)) continue;
            GuidedDecisionTableSourceBuilderIndirect isb = (GuidedDecisionTableSourceBuilderIndirect)sb;
            TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(isb.getValueBuilders().keySet());
            for (Integer index : sortedIndexes) {
                ParameterizedValueBuilder vb = isb.getValueBuilders().get(index);
                valueBuilders.add(vb);
            }
        }
        return valueBuilders;
    }

    private void assertDecisionTableData(String varName, String varDataType, List<ParameterizedValueBuilder> valueBuilders, int maxRowCount) {
        if (varName.equals("")) {
            for (ParameterizedValueBuilder pvb : valueBuilders) {
                if (!(pvb instanceof LiteralValueBuilder)) continue;
                for (int iRowIndex = 0; iRowIndex < maxRowCount; ++iRowIndex) {
                    int _rowIndex = this.ruleRowStartIndex + iRowIndex + 1;
                    int _columnIndex = this.ruleColumnStartIndex + valueBuilders.indexOf(pvb) + 1;
                    List<DTCellValue52> fragmentRow = pvb.getColumnData().get(iRowIndex);
                    List dtableRow = (List)this.dtable.getData().get(iRowIndex);
                    DTCellValue52 fragmentCell = fragmentRow.get(0);
                    DTCellValueUtilities.assertDTCellValue(varDataType, fragmentCell, (value, dataType) -> this.addConversionMessage(value, dataType, _rowIndex, _columnIndex));
                    dtableRow.add(fragmentCell);
                }
                break;
            }
        } else {
            for (ParameterizedValueBuilder pvb : valueBuilders) {
                int varNameIndex = pvb.getParameters().indexOf(varName);
                if (varNameIndex <= -1) continue;
                for (int iRowIndex = 0; iRowIndex < maxRowCount; ++iRowIndex) {
                    int _rowIndex = this.ruleRowStartIndex + iRowIndex + 1;
                    int _columnIndex = this.ruleColumnStartIndex + valueBuilders.indexOf(pvb) + 1;
                    List<DTCellValue52> fragmentRow = pvb.getColumnData().get(iRowIndex);
                    List dtableRow = (List)this.dtable.getData().get(iRowIndex);
                    DTCellValue52 fragmentCell = fragmentRow.get(varNameIndex);
                    DTCellValueUtilities.assertDTCellValue(varDataType, fragmentCell, (value, dataType) -> this.addConversionMessage(value, dataType, _rowIndex, _columnIndex));
                    dtableRow.add(fragmentCell);
                }
                break;
            }
        }
    }

    private void addConversionMessage(String value, DataType.DataTypes dataType, int rowIndex, int columnIndex) {
        this.conversionResult.addMessage("Unable to convert value '" + value + "' to " + dataType + ". Cell (" + this.toColumnName(columnIndex) + rowIndex + ")", ConversionMessageType.WARNING);
    }

    private void addConversionMessage(String message, int rowIndex, int columnIndex) {
        this.conversionResult.addMessage(message + ". Cell (" + this.toColumnName(columnIndex) + rowIndex + ")", ConversionMessageType.WARNING);
    }

    private String toColumnName(int columnIndex) {
        StringBuilder sb = new StringBuilder();
        while (columnIndex-- > 0) {
            sb.append((char)(65 + columnIndex % 26));
            columnIndex /= 26;
        }
        return sb.reverse().toString();
    }
}

