/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.GuidedDecisionTableSourceBuilderIndirect;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.HasColumnHeadings;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.IndexedParametersValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.LiteralValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterUtilities;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.ParameterizedValueBuilder;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.builders.SingleParameterValueBuilder;

public class GuidedDecisionTableRHSBuilder
implements HasColumnHeadings,
GuidedDecisionTableSourceBuilderIndirect {
    private final int headerRow;
    private final int headerCol;
    private final String variable;
    private final List<String> drlFragments = new ArrayList<String>();
    private final Map<Integer, String> columnHeaders = new HashMap<Integer, String>();
    private final Map<Integer, ParameterizedValueBuilder> valueBuilders = new HashMap<Integer, ParameterizedValueBuilder>();
    private List<GuidedDecisionTableSourceBuilder> sourceBuilders;
    private final ParameterUtilities parameterUtilities;
    private ConversionResult conversionResult;

    public GuidedDecisionTableRHSBuilder(int row, int column, String boundVariable, List<GuidedDecisionTableSourceBuilder> sourceBuilders, ParameterUtilities parameterUtilities, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.variable = boundVariable == null ? "" : boundVariable.trim();
        this.sourceBuilders = sourceBuilders;
        this.parameterUtilities = parameterUtilities;
        this.conversionResult = conversionResult;
    }

    @Override
    public List<BRLVariableColumn> getVariableColumns() {
        TreeSet<Integer> sortedIndexes = new TreeSet<Integer>(this.valueBuilders.keySet());
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = this.valueBuilders.get(index);
            List<BRLVariableColumn> vbVariableColumns = this.addColumn(vb);
            for (BRLVariableColumn vbVariableColumn : vbVariableColumns) {
                ((BRLActionVariableColumn)vbVariableColumn).setHeader(this.columnHeaders.get(index));
            }
            variableColumns.addAll(vbVariableColumns);
        }
        return variableColumns;
    }

    @Override
    public Map<Integer, ParameterizedValueBuilder> getValueBuilders() {
        return this.valueBuilders;
    }

    private List<BRLVariableColumn> addColumn(ParameterizedValueBuilder vb) {
        if (vb instanceof LiteralValueBuilder) {
            return this.addLiteralColumn((LiteralValueBuilder)vb);
        }
        return this.addBRLFragmentColumn(vb);
    }

    private List<BRLVariableColumn> addLiteralColumn(LiteralValueBuilder vb) {
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        BRLActionVariableColumn parameterColumn = new BRLActionVariableColumn("", "Boolean");
        variableColumns.add((BRLVariableColumn)parameterColumn);
        this.drlFragments.add(vb.getTemplate());
        return variableColumns;
    }

    private List<BRLVariableColumn> addBRLFragmentColumn(ParameterizedValueBuilder vb) {
        ArrayList<BRLVariableColumn> variableColumns = new ArrayList<BRLVariableColumn>();
        for (String parameter : vb.getParameters()) {
            BRLActionVariableColumn parameterColumn = new BRLActionVariableColumn(parameter, "Object");
            variableColumns.add((BRLVariableColumn)parameterColumn);
        }
        this.drlFragments.add(vb.getTemplate());
        return variableColumns;
    }

    public void addTemplate(int row, int column, String content) {
        if (this.valueBuilders.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionMessageType.ERROR);
            return;
        }
        String template = content.trim();
        if (this.isBoundVar()) {
            template = this.variable + "." + template;
        }
        if (!template.endsWith(";")) {
            template = template + ";";
        }
        try {
            this.valueBuilders.put(column, this.getValueBuilder(template));
        }
        catch (DecisionTableParseException pe) {
            this.conversionResult.addMessage(pe.getMessage(), ConversionMessageType.WARNING);
        }
    }

    private boolean isBoundVar() {
        return !"".equals(this.variable);
    }

    @Override
    public void setColumnHeader(int column, String value) {
        this.columnHeaders.put(column, value.trim());
    }

    private ParameterizedValueBuilder getValueBuilder(String template) {
        SnippetBuilder.SnippetType type = SnippetBuilder.getType((String)template);
        switch (type) {
            case INDEXED: {
                return new IndexedParametersValueBuilder(template, this.parameterUtilities, ParameterizedValueBuilder.Part.RHS);
            }
            case PARAM: {
                return new SingleParameterValueBuilder(template, this.parameterUtilities, ParameterizedValueBuilder.Part.RHS);
            }
            case SINGLE: {
                return new LiteralValueBuilder(template);
            }
        }
        throw new DecisionTableParseException("SnippetBuilder.SnippetType '" + type.toString() + "' is not supported. The column will not be added.");
    }

    public void addCellValue(int row, int column, String value) {
        ParameterizedValueBuilder vb = this.valueBuilders.get(column);
        if (vb == null) {
            String message = "No code snippet for ACTION, above cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionMessageType.ERROR);
            return;
        }
        vb.addCellValue(row, column, value);
    }

    public String getResult() {
        StringBuilder sb = new StringBuilder();
        for (String drlFragment : this.drlFragments) {
            sb.append(drlFragment).append("\n");
        }
        return sb.toString();
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.ACTION;
    }

    public void clearValues() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRowCount() {
        int maxRowCount = 0;
        for (ParameterizedValueBuilder pvb : this.valueBuilders.values()) {
            maxRowCount = Math.max(maxRowCount, pvb.getColumnData().size());
        }
        return maxRowCount;
    }

    public int getColumn() {
        return this.headerCol;
    }
}

