/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorView;
import org.drools.workbench.screens.dtablexls.client.editor.URLHelper;
import org.drools.workbench.screens.dtablexls.client.resources.i18n.DecisionTableXLSEditorConstants;
import org.gwtbootstrap3.client.ui.Button;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.workbench.events.NotificationEvent;

public class DecisionTableXLSEditorViewImpl
extends KieEditorViewImpl
implements DecisionTableXLSEditorView {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    AttachmentFileWidget uploadWidget;
    @UiField
    Button downloadButton;
    @UiField
    SimplePanel uploadWidgetContainer;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    @Inject
    private ClientMessageBus clientMessageBus;
    private DecisionTableXLSEditorView.Presenter presenter;

    public DecisionTableXLSEditorViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(DecisionTableXLSEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setupUploadWidget(ClientResourceType resourceTypeDefinition) {
        this.uploadWidget = new AttachmentFileWidget(new String[]{resourceTypeDefinition.getSuffix()}, true);
        this.uploadWidgetContainer.clear();
        this.uploadWidgetContainer.setWidget((Widget)this.uploadWidget);
        this.uploadWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BusyPopup.showMessage((String)DecisionTableXLSEditorConstants.INSTANCE.Uploading());
                DecisionTableXLSEditorViewImpl.this.presenter.onUpload();
            }
        });
    }

    @Override
    public void setPath(final Path path) {
        this.downloadButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.open((String)DecisionTableXLSEditorViewImpl.this.getDownloadUrl(path), (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
            }
        });
    }

    @Override
    public void submit(Path path) {
        this.uploadWidget.submit(path, this.getServletUrl(), new Command(){

            public void execute() {
                BusyPopup.close();
                DecisionTableXLSEditorViewImpl.this.notifySuccess();
            }
        }, new Command(){

            public void execute() {
                BusyPopup.close();
            }
        });
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.uploadWidget.setEnabled(!isReadOnly);
    }

    private void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCreatedSuccessfully()));
    }

    String getDownloadUrl(Path path) {
        return URLHelper.getDownloadUrl(path, this.getClientId());
    }

    String getServletUrl() {
        return URLHelper.getServletUrl(this.getClientId());
    }

    String getClientId() {
        return this.clientMessageBus.getClientId();
    }

    static interface ViewBinder
    extends UiBinder<Widget, DecisionTableXLSEditorViewImpl> {
    }
}

