/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.handlers;

import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.drools.workbench.screens.dtablexls.client.handlers.NewDecisionTableXLSHandler;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSXResourceType;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewDecisionTableXLSHandlerTest {
    private NewDecisionTableXLSHandler handler;
    @Mock
    private EventSourceMock<NewResourceSuccessEvent> newResourceSuccessEventMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private NewResourcePresenter newResourcePresenter;
    @Mock
    private ClientMessageBus clientMessageBus;
    @Mock
    private AttachmentFileWidget uploadWidget;
    @Mock
    private ValidationService validationService;
    @Mock
    private Caller<ValidationService> validationServiceCaller;
    @Captor
    private ArgumentCaptor<Command> successCmdCaptor;
    @Captor
    private ArgumentCaptor<Command> failureCmdCaptor;
    @Captor
    private ArgumentCaptor<Path> newPathCaptor;
    private DecisionTableXLSResourceType decisionTableXLSResourceType = new DecisionTableXLSResourceType(new Decision());
    private DecisionTableXLSXResourceType decisionTableXLSXResourceType = new DecisionTableXLSXResourceType(new Decision());
    @Mock
    private EventSourceMock<NotificationEvent> mockNotificationEvent;

    @Before
    public void setup() {
        this.handler = new NewDecisionTableXLSHandler(this.placeManager, this.decisionTableXLSResourceType, this.decisionTableXLSXResourceType, this.busyIndicatorView, this.clientMessageBus){
            {
                this.notificationEvent = NewDecisionTableXLSHandlerTest.this.mockNotificationEvent;
                this.newResourceSuccessEvent = NewDecisionTableXLSHandlerTest.this.newResourceSuccessEventMock;
                this.validationService = NewDecisionTableXLSHandlerTest.this.validationServiceCaller;
            }

            protected String encode(String fileName) {
                return NewDecisionTableXLSHandlerTest.this.encode(fileName);
            }

            protected String getClientId() {
                return "123";
            }
        };
        Mockito.when((Object)((ValidationService)this.validationServiceCaller.call((RemoteCallback)Mockito.any(RemoteCallback.class)))).thenReturn((Object)this.validationService);
        this.handler.setUploadWidget(this.uploadWidget);
    }

    @Test
    public void testSuccess() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"fileName.xls");
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
        ((EventSourceMock)Mockito.verify(this.newResourceSuccessEventMock, (VerificationMode)Mockito.times((int)1))).fire((Object)((NewResourceSuccessEvent)Mockito.any(NewResourceSuccessEvent.class)));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://project/src/main/resources/fileName.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessXLSX() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"fileName.xlsx");
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.decisionTableXLSXResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
        ((EventSourceMock)Mockito.verify(this.newResourceSuccessEventMock, (VerificationMode)Mockito.times((int)1))).fire((Object)((NewResourceSuccessEvent)Mockito.any(NewResourceSuccessEvent.class)));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://project/src/main/resources/fileName.xlsx", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessMultiByteProjectName() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://\u3042\u3042\u3042/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"fileName.xls");
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://\u3042\u3042\u3042/src/main/resources/fileName.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessMultiByteFileName() {
        String fileName = "\u3042\u3042\u3042";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"\u3042\u3042\u3042.xls");
        this.handler.create(pkg, "\u3042\u3042\u3042", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("\u3042\u3042\u3042." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://project/src/main/resources/%E3%81%82%E3%81%82%E3%81%82.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessMultiByteProjectNameAndFileName() {
        String fileName = "\u3042\u3042\u3042";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)("default://" + this.encode("\u3042\u3042") + "/src/main/resources"));
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"\u3042\u3042\u3042.xls");
        this.handler.create(pkg, "\u3042\u3042\u3042", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("\u3042\u3042\u3042." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://%E3%81%82%E3%81%82/src/main/resources/%E3%81%82%E3%81%82%E3%81%82.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testGetServletUrl() {
        Assert.assertEquals((Object)"dtablexls/file?clientId=123", (Object)this.handler.getServletUrl());
    }

    @Test
    public void testValidateNullFile() {
        ValidatorWithReasonCallback validatorWithReasonCallback = (ValidatorWithReasonCallback)Mockito.mock(ValidatorWithReasonCallback.class);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn(null);
        this.handler.validate("filename", validatorWithReasonCallback);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget)).addStyleName(ValidationState.ERROR.getCssName());
    }

    @Test
    public void testValidateEmptyFile() {
        ValidatorWithReasonCallback validatorWithReasonCallback = (ValidatorWithReasonCallback)Mockito.mock(ValidatorWithReasonCallback.class);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"");
        this.handler.validate("filename", validatorWithReasonCallback);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget)).addStyleName(ValidationState.ERROR.getCssName());
    }

    @Test
    public void testValidateNonEmptyFile() {
        ValidatorWithReasonCallback validatorWithReasonCallback = (ValidatorWithReasonCallback)Mockito.mock(ValidatorWithReasonCallback.class);
        Mockito.when((Object)this.uploadWidget.getFilenameSelectedToUpload()).thenReturn((Object)"table.xls");
        this.handler.validate("filename", validatorWithReasonCallback);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.never())).addStyleName(ValidationState.ERROR.getCssName());
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Assert.fail((String)uee.getMessage());
            return "";
        }
    }
}

