/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.screens.enums.backend.server.indexing.TestEnumFileIndexer;
import org.drools.workbench.screens.enums.type.EnumResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.metadata.engine.Index;
import org.uberfire.metadata.model.KObject;

public class IndexEnumEntriesTest
extends BaseIndexingTest<EnumResourceTypeDefinition> {
    @Test
    public void testIndexEnumEntries() throws IOException, InterruptedException {
        int i;
        Path basePath = this.getDirectoryPath().resolveSibling("someNewOtherPath");
        this.ioService().write(basePath.resolve("dummy"), "<none>", new OpenOption[0]);
        Path path1 = basePath.resolve("enum1.enumeration");
        String dsl1 = this.loadText("enum1.enumeration");
        this.ioService().write(path1, dsl1, new OpenOption[0]);
        Path path2 = basePath.resolve("enum2.enumeration");
        String dsl2 = this.loadText("enum2.enumeration");
        this.ioService().write(path2, dsl2, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexEnumEntriesTest.getConfig().getIndexManager().get(org.uberfire.metadata.io.KObjectUtil.toKCluster((FileSystem)basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        Query query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.enums.backend.server.indexing.classes.Applicant")).build();
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        ArrayList<KObject> results = new ArrayList<KObject>();
        for (i = 0; i < hits.length; ++i) {
            results.add(KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path1);
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.enums.backend.server.indexing.classes.Mortgage")).build();
        searcher.search(query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        results = new ArrayList();
        for (i = 0; i < hits.length; ++i) {
            results.add(KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.enums.backend.server.indexing.classes.Mortgage")).addTerm((ValueIndexTerm)new ValueFieldIndexTerm("amount")).build();
        searcher.search(query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        results = new ArrayList();
        for (i = 0; i < hits.length; ++i) {
            results.add(KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("java.lang.Integer")).build();
        searcher.search(query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        results = new ArrayList();
        for (i = 0; i < hits.length; ++i) {
            results.add(KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path1);
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestEnumFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("rule_attribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected EnumResourceTypeDefinition getResourceTypeDefinition() {
        return new EnumResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

