/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.enums.model.EnumModel;
import org.drools.workbench.screens.enums.model.EnumModelContent;
import org.drools.workbench.screens.enums.service.EnumService;
import org.drools.workbench.screens.enums.type.EnumResourceTypeDefinition;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.builder.LRUBuilderCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOPackageCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class EnumServiceImpl
implements EnumService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOPackageCacheEvent> invalidateDMOPackageCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private EnumResourceTypeDefinition resourceTypeDefinition;
    @Inject
    private ProjectService projectService;
    @Inject
    private LRUBuilderCache builderCache;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, String content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, content, new OpenOption[]{this.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return content;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public EnumModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return new EnumModelContent(new EnumModel(this.load(path)));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, String content, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), content, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.invalidateDMOPackageCache.fire((Object)new InvalidateDMOPackageCacheEvent(resource));
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean accepts(org.uberfire.backend.vfs.Path path) {
        return this.resourceTypeDefinition.accept(path);
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return this.validate(path, content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, String content) {
        return this.doValidation(path, content);
    }

    private List<ValidationMessage> doValidation(org.uberfire.backend.vfs.Path path, String content) {
        try {
            Project project = this.projectService.resolveProject(path);
            KieModule module = this.builderCache.assertBuilder(project).getKieModuleIgnoringErrors();
            ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
            DataEnumLoader loader = new DataEnumLoader(content, classLoader);
            if (!loader.hasErrors()) {
                return Collections.emptyList();
            }
            ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
            List loaderErrors = loader.getErrors();
            for (String message : loaderErrors) {
                validationMessages.add(this.makeValidationMessages(path, message));
            }
            return validationMessages;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private ValidationMessage makeValidationMessages(org.uberfire.backend.vfs.Path path, String message) {
        ValidationMessage msg = new ValidationMessage();
        msg.setPath(path);
        msg.setLevel(ValidationMessage.Level.ERROR);
        msg.setText(message);
        return msg;
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

