/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.screens.enums.backend.server.indexing.EnumIndexVisitor;
import org.drools.workbench.screens.enums.type.EnumResourceTypeDefinition;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class EnumFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(EnumFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected EnumResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            String enumDefinition = this.ioService.readAllString(path);
            DataEnumLoader enumLoader = new DataEnumLoader(enumDefinition);
            if (enumLoader.hasErrors()) {
                logger.info("Unable to index '" + path.toUri().toString() + "'. Related errors follow:");
                for (String e : enumLoader.getErrors()) {
                    logger.info(e);
                }
                return index;
            }
            String packageName = this.getPackageName(path);
            ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
            Project project = this.projectService.resolveProject(Paths.convert((Path)path));
            Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
            DefaultIndexBuilder builder = new DefaultIndexBuilder(project, pkg);
            EnumIndexVisitor visitor = new EnumIndexVisitor(dmo, builder, enumLoader, packageName);
            visitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
            return index;
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
            return index;
        }
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }

    protected String getPackageName(Path path) {
        return this.projectService.resolvePackage(Paths.convert((Path)path)).getPackageName();
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }
}

