/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Type;
import org.kie.workbench.common.services.refactoring.model.index.TypeField;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class EnumIndexVisitor {
    private final ProjectDataModelOracle dmo;
    private final DefaultIndexBuilder builder;
    private final DataEnumLoader enumLoader;
    private final String packageName;
    private final Set<Pair<String, String>> results = new HashSet<Pair<String, String>>();

    public EnumIndexVisitor(ProjectDataModelOracle dmo, DefaultIndexBuilder builder, DataEnumLoader enumLoader, String packageName) {
        this.dmo = (ProjectDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.enumLoader = (DataEnumLoader)PortablePreconditions.checkNotNull((String)"enumLoader", (Object)enumLoader);
        this.packageName = (String)PortablePreconditions.checkNotNull((String)"packageName", (Object)packageName);
    }

    public Set<Pair<String, String>> visit() {
        if (this.enumLoader.hasErrors()) {
            return this.results;
        }
        for (Map.Entry e : this.enumLoader.getData().entrySet()) {
            String typeName = this.getTypeName((String)e.getKey());
            String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
            this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(fullyQualifiedClassName)));
            String fieldName = this.getFieldName((String)e.getKey());
            String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
            this.builder.addGenerator((IndexElementsGenerator)new TypeField(new ValueFieldIndexTerm(fieldName), new ValueTypeIndexTerm(fieldFullyQualifiedClassName), new ValueTypeIndexTerm(fullyQualifiedClassName)));
        }
        this.results.addAll(this.builder.build());
        return this.results;
    }

    private String getTypeName(String key) {
        int hashIndex = key.indexOf("#");
        return key.substring(0, hashIndex);
    }

    private String getFieldName(String key) {
        int hashIndex = key.indexOf("#");
        return key.substring(hashIndex + 1);
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        return this.packageName != null && !this.packageName.isEmpty() ? this.packageName + "." + typeName : typeName;
    }

    private String getFieldFullyQualifiedClassName(String fullyQualifiedClassName, String fieldName) {
        ModelField[] mfs;
        for (ModelField mf : mfs = (ModelField[])this.dmo.getProjectModelFields().get(fullyQualifiedClassName)) {
            if (!mf.getName().equals(fieldName)) continue;
            return mf.getClassName();
        }
        return "Object";
    }
}

