/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.enums.model.EnumModel;
import org.drools.workbench.screens.enums.model.EnumModelContent;
import org.drools.workbench.screens.enums.service.EnumService;
import org.drools.workbench.screens.enums.type.EnumResourceTypeDefinition;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.builder.events.InvalidateDMOPackageCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class EnumServiceImpl
extends KieService<EnumModelContent>
implements EnumService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOPackageCacheEvent> invalidateDMOPackageCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private EnumResourceTypeDefinition resourceTypeDefinition;
    @Inject
    private LRUBuilderCache builderCache;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    private SafeSessionInfo safeSessionInfo;

    public EnumServiceImpl() {
    }

    @Inject
    public EnumServiceImpl(SessionInfo sessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, String content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, content, new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return content;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public EnumModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (EnumModelContent)super.loadContent(path);
    }

    protected EnumModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new EnumModelContent(new EnumModel(this.load(path)), overview);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, String content, Metadata metadata, String comment) {
        try {
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), content, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.invalidateDMOPackageCache.fire((Object)new InvalidateDMOPackageCacheEvent(resource));
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean accepts(org.uberfire.backend.vfs.Path path) {
        return this.resourceTypeDefinition.accept(path);
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return this.validate(path, content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, String content) {
        return this.doValidation(path, content);
    }

    private List<ValidationMessage> doValidation(org.uberfire.backend.vfs.Path path, String content) {
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            KieModule module = this.builderCache.assertBuilder((Project)project).getKieModuleIgnoringErrors();
            ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
            DataEnumLoader loader = new DataEnumLoader(content, classLoader);
            if (!loader.hasErrors()) {
                return Collections.emptyList();
            }
            ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
            List loaderErrors = loader.getErrors();
            for (String message : loaderErrors) {
                validationMessages.add(this.makeValidationMessages(path, message));
            }
            return validationMessages;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private ValidationMessage makeValidationMessages(org.uberfire.backend.vfs.Path path, String message) {
        ValidationMessage msg = new ValidationMessage();
        msg.setPath(path);
        msg.setLevel(Level.ERROR);
        msg.setText(message);
        return msg;
    }
}

