/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Type;
import org.kie.workbench.common.services.refactoring.model.index.TypeField;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class EnumIndexVisitor {
    private static final Logger logger = LoggerFactory.getLogger(EnumIndexVisitor.class);
    private final ProjectDataModelOracle dmo;
    private final DefaultIndexBuilder builder;
    private final DataEnumLoader enumLoader;
    private final Set<Pair<String, String>> results = new HashSet<Pair<String, String>>();

    public EnumIndexVisitor(ProjectDataModelOracle dmo, DefaultIndexBuilder builder, DataEnumLoader enumLoader) {
        this.dmo = (ProjectDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.enumLoader = (DataEnumLoader)PortablePreconditions.checkNotNull((String)"enumLoader", (Object)enumLoader);
    }

    public Set<Pair<String, String>> visit() {
        if (this.enumLoader.hasErrors()) {
            return this.results;
        }
        for (Map.Entry e : this.enumLoader.getData().entrySet()) {
            String typeName = this.getTypeName((String)e.getKey());
            String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
            String fieldName = this.getFieldName((String)e.getKey());
            String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
            if (fullyQualifiedClassName == null) {
                logger.warn("Index entry will not be created for '" + (String)e.getKey() + "'. Unable to determine FQCN for '" + typeName + "'. ");
                continue;
            }
            this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(fullyQualifiedClassName)));
            if (fieldFullyQualifiedClassName == null) {
                logger.warn("Index entry will not be created for '" + (String)e.getKey() + "'. Unable to determine FQCN for '" + typeName + "." + fieldName + "'. ");
                continue;
            }
            this.builder.addGenerator((IndexElementsGenerator)new TypeField(new ValueFieldIndexTerm(fieldName), new ValueTypeIndexTerm(fieldFullyQualifiedClassName), new ValueTypeIndexTerm(fullyQualifiedClassName)));
        }
        this.results.addAll(this.builder.build());
        return this.results;
    }

    private String getTypeName(String key) {
        int hashIndex = key.indexOf("#");
        return key.substring(0, hashIndex);
    }

    private String getFieldName(String key) {
        int hashIndex = key.indexOf("#");
        return key.substring(hashIndex + 1);
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Map.Entry e : this.dmo.getProjectModelFields().entrySet()) {
            String fqcn = (String)e.getKey();
            if (((String)e.getKey()).contains(".")) {
                fqcn = fqcn.substring(fqcn.lastIndexOf(".") + 1);
            }
            if (!fqcn.equals(typeName)) continue;
            return (String)e.getKey();
        }
        return null;
    }

    private String getFieldFullyQualifiedClassName(String fullyQualifiedClassName, String fieldName) {
        ModelField[] mfs = (ModelField[])this.dmo.getProjectModelFields().get(fullyQualifiedClassName);
        if (mfs != null) {
            for (ModelField mf : mfs) {
                if (!mf.getName().equals(fieldName)) continue;
                return mf.getClassName();
            }
        }
        return null;
    }
}

