/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.enums.backend.server.indexing.TestEnumFileIndexer;
import org.drools.workbench.screens.enums.type.EnumResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePartReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexEnumEntriesTest
extends BaseIndexingTest<EnumResourceTypeDefinition> {
    @Test
    public void testIndexEnumEntries() throws IOException, InterruptedException {
        Path path1 = this.basePath.resolve("enum1.enumeration");
        String dsl1 = this.loadText("enum1.enumeration");
        this.ioService().write(path1, dsl1, new OpenOption[0]);
        Path path2 = this.basePath.resolve("enum2.enumeration");
        String dsl2 = this.loadText("enum2.enumeration");
        this.ioService().write(path2, dsl2, new OpenOption[0]);
        Path path3 = this.basePath.resolve("enum3.enumeration");
        String dsl3 = this.loadText("enum3.enumeration");
        this.ioService().write(path3, dsl3, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexEnumEntriesTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("org.drools.workbench.screens.enums.backend.server.indexing.classes.Applicant", ResourceType.JAVA)).build();
        this.searchFor(index, query, 2, new Path[]{path1, path2});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("org.drools.workbench.screens.enums.backend.server.indexing.classes.Mortgage", ResourceType.JAVA)).build();
        this.searchFor(index, query, 1, new Path[]{path2});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValuePartReferenceIndexTerm("org.drools.workbench.screens.enums.backend.server.indexing.classes.Mortgage", "amount", PartType.FIELD)).build();
        this.searchFor(index, query, 1, new Path[]{path2});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("java.lang.Integer", ResourceType.JAVA)).build();
        this.searchFor(index, query, 2, new Path[]{path1, path2});
    }

    protected TestIndexer getIndexer() {
        return new TestEnumFileIndexer();
    }

    protected EnumResourceTypeDefinition getResourceTypeDefinition() {
        return new EnumResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

