/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.enums.backend.server.indexing.EnumIndexVisitor;
import org.drools.workbench.screens.enums.type.EnumResourceTypeDefinition;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class EnumFileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(EnumFileIndexer.class);
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected EnumResourceTypeDefinition type;
    private MVELEvaluator mvelEvaluator;

    @Inject
    public EnumFileIndexer(MVELEvaluator mvelEvaluator) {
        this.mvelEvaluator = mvelEvaluator;
    }

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        String enumDefinition = this.ioService.readAllString(path);
        DataEnumLoader enumLoader = new DataEnumLoader(enumDefinition, this.mvelEvaluator);
        if (enumLoader.hasErrors()) {
            logger.info("Unable to index '" + path.toUri().toString() + "'. Related errors follow:");
            for (String e : enumLoader.getErrors()) {
                logger.info(e);
            }
        }
        ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
        DefaultIndexBuilder builder = this.getIndexBuilder(path);
        if (builder == null) {
            return null;
        }
        EnumIndexVisitor visitor = new EnumIndexVisitor(dmo, path, enumLoader);
        visitor.visit();
        this.addReferencedResourcesToIndexBuilder(builder, visitor);
        return builder;
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }
}

